/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.Item;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.gd.ControllableStream;
import com.ibm.ws.sib.processor.gd.StateStream;
import com.ibm.ws.sib.processor.gd.TickRange;
import com.ibm.ws.sib.processor.impl.AORequested;
import com.ibm.ws.sib.processor.impl.AORequestedTick;
import com.ibm.ws.sib.processor.impl.AnycastOutputHandler;
import com.ibm.ws.sib.processor.impl.JSRemoteConsumerPoint;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.OrderingContextImpl;
import com.ibm.ws.sib.processor.impl.exceptions.ClosedException;
import com.ibm.ws.sib.processor.impl.interfaces.ConsumableKey;
import com.ibm.ws.sib.processor.impl.interfaces.ControllableResource;
import com.ibm.ws.sib.processor.impl.interfaces.JSConsumerManager;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.AsyncUpdate;
import com.ibm.ws.sib.processor.impl.store.AsyncUpdateThread;
import com.ibm.ws.sib.processor.impl.store.items.AOValue;
import com.ibm.ws.sib.processor.impl.store.itemstreams.AOProtocolItemStream;
import com.ibm.ws.sib.processor.runtime.SIMPDeliveryTransmitControllable;
import com.ibm.ws.sib.processor.runtime.impl.ControlAdapter;
import com.ibm.ws.sib.processor.runtime.impl.RemoteConsumerTransmit;
import com.ibm.ws.sib.processor.utils.am.BatchedTimeoutManager;
import com.ibm.ws.sib.processor.utils.am.BatchedTimeoutProcessor;
import com.ibm.ws.sib.processor.utils.am.MPAlarmManager;
import com.ibm.ws.sib.transactions.LocalTransaction;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.SelectorDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public final class AOStream
extends ControllableStream
implements BatchedTimeoutProcessor,
ControllableResource {
    private MessageProcessor mp;
    private MPAlarmManager am;
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static TraceComponent tc = SibTr.register(AOStream.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    public static final int NUM_OF_BUCKETS = 4;
    public final SIBUuid8 remoteMEUuid;
    public final SIBUuid12 streamId;
    private final long controlItemLockID;
    private SIBUuid12 gatheringTargetDestUuid;
    private JSConsumerManager consumerDispatcher;
    public final AOProtocolItemStream itemStream;
    private final AnycastOutputHandler parent;
    private final StateStream stream;
    private AOStreamState streamState = AOStreamState.ACTIVE;
    private RequestHighestGeneratedTick requestHighestGeneratedTickTimer;
    private long totalReceivedRequests;
    private long firstUnknownTick;
    private final Hashtable consumerKeyTable;
    private boolean startedFlush;
    private boolean isFlushed;
    private boolean scheduleWriteStartedFlush;
    private boolean completedTicksInitialized;
    private Alarm initRepeatHandler;
    private long initRequestId;
    private long initHighestValueTick;
    private ResetRequestAckSender resetRequestAckSender;
    private final BatchedTimeoutManager dem;
    private BatchedTimeoutManager imeRestorationHandler;
    private long dmeVerion;
    private boolean active;
    private boolean closed;
    private final AsyncUpdateThread msUpdateThread;
    private int countAsyncUpdatesOutstanding;
    private final long[][] latestTick;
    private Alarm inactivityTimer;
    private final InactivityTimerHandler inactivityHandler;
    private boolean messagesReceived = false;
    private ControlAdapter _controlAdapter;
    private static final int ACCEPT_MSG = 1;
    private static final int REJECT_MSG = 2;
    private static final int COMPLETED_MSG = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AOStream(SIBUuid8 remoteMEId, SIBUuid12 gatheringTargetDestUuid, SIBUuid12 streamId, AOProtocolItemStream itemStream, AnycastOutputHandler parent, AsyncUpdateThread msUpdateThread, boolean firstTime, List valueTicks, boolean startedFlush, MessageProcessor mp, long dmeVersion, JSConsumerManager consumerDispatcher) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AOStream", (Object)new Object[]{remoteMEId, gatheringTargetDestUuid, streamId, itemStream, parent, msUpdateThread, firstTime, valueTicks, startedFlush, mp, dmeVersion, consumerDispatcher});
        }
        AOStream aOStream = this;
        synchronized (aOStream) {
            this.controlItemLockID = mp.getMessageStore().getUniqueLockID(1);
            this.remoteMEUuid = remoteMEId;
            this.gatheringTargetDestUuid = gatheringTargetDestUuid;
            this.streamId = streamId;
            this.itemStream = itemStream;
            this.parent = parent;
            this.consumerDispatcher = consumerDispatcher;
            this.msUpdateThread = msUpdateThread;
            this.countAsyncUpdatesOutstanding = 0;
            this.mp = mp;
            this.am = mp.getAlarmManager();
            this.startedFlush = startedFlush;
            this.isFlushed = false;
            this.consumerKeyTable = new Hashtable();
            this.scheduleWriteStartedFlush = false;
            this.closed = false;
            this.inactivityHandler = new InactivityTimerHandler();
            this.dmeVerion = dmeVersion;
            this.latestTick = new long[Reliability.MAX_INDEX + 1][10];
            for (int i = 0; i <= Reliability.MAX_INDEX; ++i) {
                for (int j = 0; j <= 9; ++j) {
                    this.latestTick[i][j] = i == Reliability.MAX_INDEX ? 0L : -1L;
                }
            }
            this.initHighestValueTick = 0L;
            this.stream = new StateStream();
            this.stream.init();
            if (!firstTime) {
                ArrayList<AOValue> valueTicksToRemove = null;
                for (int i = 0; i < valueTicks.size(); ++i) {
                    try {
                        int priority;
                        int reliability;
                        AOValue value = (AOValue)valueTicks.get(i);
                        boolean toRemove = false;
                        if (value.getStorageStrategy() == 3 && gatheringTargetDestUuid == null) {
                            SIMPMessage msg = consumerDispatcher.getMessageByValue(value);
                            if (msg == null) {
                                toRemove = true;
                            } else if (msg.getLockID() != value.getPLockId()) {
                                toRemove = true;
                            }
                        }
                        if (toRemove) {
                            if (valueTicksToRemove == null) {
                                valueTicksToRemove = new ArrayList<AOValue>(10);
                            }
                            valueTicksToRemove.add(value);
                            continue;
                        }
                        if (value.getTick() > this.initHighestValueTick) {
                            this.initHighestValueTick = value.getTick();
                        }
                        TickRange tr = TickRange.newValueTick(value.getTick(), value, 0L);
                        this.stream.writeRange(tr);
                        ++this.totalReceivedRequests;
                        SIMPMessage msg = consumerDispatcher.getMessageByValue(value);
                        if (msg != null) {
                            if (consumerDispatcher.getDestination().isOrdered()) {
                                consumerDispatcher.setCurrentTransaction(msg, true);
                            }
                            reliability = msg.getMessage().getReliability().getIndex();
                            priority = msg.getMessage().getPriority();
                        } else {
                            priority = value.getMsgPriority();
                            reliability = value.getMsgReliability();
                            value.restored = false;
                        }
                        if (this.latestTick[reliability][priority] >= value.getTick()) continue;
                        this.latestTick[reliability][priority] = value.getTick();
                        continue;
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AOStream.AOStream", (String)"1:455:1.80.3.24", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)e);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"AOStream", (Object)e);
                        }
                        throw e;
                    }
                }
                if (valueTicksToRemove != null) {
                    LocalTransaction tran = parent.getLocalTransaction();
                    try {
                        Transaction msTran = mp.resolveAndEnlistMsgStoreTransaction((TransactionCommon)tran);
                        int length = valueTicksToRemove.size();
                        for (int i = 0; i < length; ++i) {
                            AOValue value = (AOValue)valueTicksToRemove.get(i);
                            this.unlockRejectedTick((TransactionCommon)msTran, value);
                        }
                        tran.commit();
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AOStream.AOStream", (String)"1:484:1.80.3.24", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)e);
                        try {
                            tran.rollback();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"AOStream", (Object)e);
                        }
                        throw e;
                    }
                }
            }
            this.dem = new BatchedTimeoutManager(4, mp.getCustomProperties().get_decision_expected_repetition_interval(), valueTicks, this, mp);
            if (firstTime) {
                this.completedTicksInitialized = true;
                this.firstUnknownTick = 1L;
                this.changeUnknownToCompleted(0L, 0L);
            } else if (startedFlush) {
                this.completedTicksInitialized = true;
                if (valueTicks.isEmpty()) {
                    this.isFlushed = true;
                    this.closed = true;
                    SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AOStream", "1:538:1.80.3.24"}, null));
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AOStream.AOStream", (String)"1:543:1.80.3.24", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AOStream", "1:549:1.80.3.24"});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"AOStream", (Object)((Object)e));
                    }
                    throw e;
                }
                this.firstUnknownTick = Long.MAX_VALUE;
                this.changeUnknownToCompleted(0L, Long.MAX_VALUE);
            } else {
                this.completedTicksInitialized = false;
                this.initRequestId = -1L;
                this.resetRequestAckSender = new ResetRequestAckSender();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AOStream", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConsumerKey(JSRemoteConsumerPoint aock) {
        AOStream aOStream = this;
        synchronized (aOStream) {
            this.consumerKeyTable.put("", aock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"start");
        }
        AOStream aOStream = this;
        synchronized (aOStream) {
            boolean done;
            this.active = true;
            if (!this.completedTicksInitialized) {
                if (this.initRequestId == -1L) {
                    this.initRequestId = this.parent.generateUniqueValue();
                }
                this.requestHighestGeneratedTickTimer = new RequestHighestGeneratedTick();
                this.requestHighestGeneratedTickTimer.alarm(null);
            }
            if (this.parent.getCardinalityOne() && !this.isFlushed) {
                this.inactivityTimer = this.am.create(this.mp.getCustomProperties().get_remote_consumer_cardinality_inactivity_interval(), this.inactivityHandler);
            }
            if (this.resetRequestAckSender != null && (done = this.resetRequestAckSender.start())) {
                this.resetRequestAckSender = null;
            }
            this.dem.startTimer();
            if (this.imeRestorationHandler != null) {
                this.imeRestorationHandler.startTimer();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"start");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop");
        }
        AOStream aOStream = this;
        synchronized (aOStream) {
            this.active = false;
            if (this.initRepeatHandler != null) {
                this.initRepeatHandler.cancel();
            }
            if (this.inactivityTimer != null) {
                this.inactivityTimer.cancel();
                this.inactivityTimer = null;
            }
            if (this.resetRequestAckSender != null) {
                this.resetRequestAckSender.stop();
            }
            this.dem.stopTimer();
            if (this.imeRestorationHandler != null) {
                this.imeRestorationHandler.stopTimer();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public final long getInitRequestId() {
        return this.initRequestId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processTimedoutEntries(List timedout) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processTimedoutEntries", (Object)new Object[]{this, timedout});
        }
        boolean sendMsg = false;
        AOStream aOStream = this;
        synchronized (aOStream) {
            if (this.active && this.completedTicksInitialized && !timedout.isEmpty()) {
                sendMsg = true;
            }
        }
        if (sendMsg) {
            this.parent.sendDecisionExpected(this.remoteMEUuid, this.gatheringTargetDestUuid, this.streamId, timedout);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processTimedoutEntries");
        }
    }

    public final void expiredRequest(long tick) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"expiredRequest", (Object)tick);
        }
        this.expiredRequest(tick, false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"expiredRequest");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void expiredRequest(long tick, boolean flushValue) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"expiredRequest", (Object)new Object[]{tick, flushValue});
        }
        TickRange r2 = null;
        boolean transitionToFlushed = false;
        AOStream aOStream = this;
        synchronized (aOStream) {
            this.stream.setCursor(tick);
            TickRange r = this.stream.getNext();
            byte type = r.type;
            if (type == 1 || type == 0 || flushValue && type == 3) {
                r2 = new TickRange(7, tick, tick);
                this.stream.writeCompleted(r2);
                if (!this.active) {
                    r2 = null;
                }
                transitionToFlushed = this.tryTransitionToFlushed();
            }
        }
        if (r2 != null) {
            this.parent.sendCompleted(this.remoteMEUuid, this.gatheringTargetDestUuid, this.streamId, r2);
        }
        if (transitionToFlushed) {
            this.parent.sendFlushed(this.remoteMEUuid, this.gatheringTargetDestUuid, this.streamId);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"expiredRequest");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void satisfiedRequest(long tick, SIMPMessage msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"satisfiedRequest", (Object)new Object[]{tick, msg});
        }
        boolean sendMsg = false;
        long startstamp = tick;
        AOValue value = null;
        boolean transitionToFlushed = false;
        AOStream aOStream = this;
        synchronized (aOStream) {
            try {
                if (this.startedFlush || this.closed) {
                    msg.unlockMsg(msg.getLockID(), null, true);
                    TickRange r = new TickRange(7, tick, tick);
                    this.stream.writeCompleted(r);
                    transitionToFlushed = this.tryTransitionToFlushed();
                } else {
                    this.stream.setCursor(tick);
                    TickRange r = this.stream.getNext();
                    if (r.type != 1) {
                        msg.unlockMsg(msg.getLockID(), null, true);
                    } else {
                        AORequested requested = (AORequested)r.value;
                        long waitTime = System.currentTimeMillis() - requested.startTime;
                        if (msg.getReliability().compareTo((Object)Reliability.RELIABLE_NONPERSISTENT) <= 0) {
                            int reliability = msg.getReliability().getIndex();
                            int priority = msg.getMessage().getPriority();
                            value = new AOValue(tick, msg, msg.getID(), 1, 0L, waitTime, this.latestTick[reliability][priority]);
                            this.latestTick[reliability][priority] = tick;
                            TickRange r2 = TickRange.newValueTick(tick, value, 0L);
                            this.stream.writeCombinedRange(r2);
                            r2 = this.stream.findCompletedRange(r2);
                            this.dem.addTimeoutEntry(value);
                            if (this.active) {
                                sendMsg = true;
                                startstamp = r2.startstamp;
                            }
                        } else {
                            int storagePolicy = msg.getReliability().compareTo((Object)Reliability.ASSURED_PERSISTENT) < 0 ? 3 : 4;
                            ((AORequested)r.value).inserting = true;
                            int reliability = msg.getReliability().getIndex();
                            int priority = msg.getMessage().getPriority();
                            PersistLockAndTick update = new PersistLockAndTick(tick, msg, storagePolicy, waitTime, this.latestTick[reliability][priority]);
                            this.latestTick[reliability][priority] = tick;
                            this.parent.getPersistLockThread().enqueueWork(update);
                            ++this.countAsyncUpdatesOutstanding;
                        }
                    }
                }
            }
            catch (MessageStoreException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AOStream.satisfiedRequest", (String)"1:1058:1.80.3.24", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AOStream.satisfiedRequest", (String)"1:1069:1.80.3.24", (Object)this);
                SIErrorException e2 = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.AOStream", "1:1077:1.80.3.24", e}, null));
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e2));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AOStream", "1:1084:1.80.3.24", e});
            }
        }
        if (sendMsg) {
            long prevTick = value.getPrevTick();
            this.parent.sendRemoteGetData(msg, this.remoteMEUuid, this.gatheringTargetDestUuid, this.streamId, prevTick, startstamp, tick, value.getWaitTime());
            msg.releaseJsMessage();
        }
        if (transitionToFlushed) {
            this.parent.sendFlushed(this.remoteMEUuid, this.gatheringTargetDestUuid, this.streamId);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"satisfiedRequest");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeConsumerKey(String selector, JSRemoteConsumerPoint aock) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeConsumerKey", (Object)new Object[]{selector, aock});
        }
        AOStream aOStream = this;
        synchronized (aOStream) {
            JSRemoteConsumerPoint aock2 = (JSRemoteConsumerPoint)this.consumerKeyTable.get(selector);
            if (aock2 == aock) {
                this.consumerKeyTable.remove(selector);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeConsumerKey");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storedTicksRemoved(ArrayList storedTicks) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"storedTicksRemoved", (Object)storedTicks);
        }
        ArrayList<TickRange> ranges = new ArrayList<TickRange>(storedTicks.size());
        TickRange r2 = null;
        boolean sendMsg = false;
        boolean transitionToFlushed = false;
        AOStream aOStream = this;
        synchronized (aOStream) {
            --this.countAsyncUpdatesOutstanding;
            if (this.active) {
                sendMsg = true;
            }
            for (int i = 0; i < storedTicks.size(); ++i) {
                AOValue stick = (AOValue)storedTicks.get(i);
                this.dem.removeTimeoutEntry(stick);
                r2 = new TickRange(7, stick.getTick(), stick.getTick());
                r2 = this.stream.writeCompleted(r2);
                ranges.add(r2);
            }
            transitionToFlushed = this.tryTransitionToFlushed();
        }
        if (sendMsg) {
            if (ranges.size() > 0) {
                this.parent.sendCompleted(this.remoteMEUuid, this.gatheringTargetDestUuid, this.streamId, ranges);
            }
            if (transitionToFlushed) {
                this.parent.sendFlushed(this.remoteMEUuid, this.gatheringTargetDestUuid, this.streamId);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"storedTicksRemoved");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest(String[] discriminators, int[] selectorDomains, String[] selectors, long[] rejectStartTicks, long[] getTicks, long[] timeouts) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processRequest", (Object)new Object[]{Arrays.toString(discriminators), Arrays.toString(selectorDomains), Arrays.toString(selectors), Arrays.toString(rejectStartTicks), Arrays.toString(getTicks), Arrays.toString(timeouts)});
        }
        ArrayList<AORequested> requestAckList = null;
        for (int i = 0; i < rejectStartTicks.length; ++i) {
            long rejectStartTick = rejectStartTicks[i];
            long getTick = getTicks[i];
            long timeout = timeouts[i];
            boolean sendDataMsg = false;
            AOValue value = null;
            SIMPMessage msg = null;
            long starttick = getTick;
            boolean sendCompletedMsg = false;
            TickRange completedRange = null;
            AOStream aOStream = this;
            synchronized (aOStream) {
                this.messagesReceived = true;
                if (this.completedTicksInitialized && this.active) {
                    if (getTick >= this.firstUnknownTick && !this.startedFlush) {
                        if (rejectStartTick >= getTick || rejectStartTick < this.firstUnknownTick) {
                            // empty if block
                        }
                        try {
                            if (this.firstUnknownTick < getTick) {
                                completedRange = new TickRange(7, this.firstUnknownTick, getTick - 1L);
                                this.stream.writeCompletedRange(completedRange);
                            }
                            starttick = this.firstUnknownTick;
                            this.firstUnknownTick = getTick + 1L;
                            JSRemoteConsumerPoint rcp = this.findOrCreateJSRemoteConsumerPoint(discriminators, selectorDomains, selectors);
                            AORequestedTick aoTick = null;
                            rcp.lock();
                            try {
                                aoTick = rcp.newRequest(getTick, timeout);
                                msg = aoTick.getMessage();
                            }
                            finally {
                                rcp.unlock();
                            }
                            ++this.totalReceivedRequests;
                            if (msg != null) {
                                if (msg.getReliability().compareTo((Object)Reliability.RELIABLE_NONPERSISTENT) <= 0) {
                                    int reliability = msg.getReliability().getIndex();
                                    int priority = msg.getMessage().getPriority();
                                    value = new AOValue(getTick, msg, msg.getID(), 1, 0L, 0L, this.latestTick[reliability][priority]);
                                    this.latestTick[reliability][priority] = getTick;
                                    TickRange r = TickRange.newValueTick(getTick, value, 0L);
                                    this.stream.writeCombinedRange(r);
                                    r = this.stream.findCompletedRange(r);
                                    starttick = r.startstamp;
                                    this.dem.addTimeoutEntry(value);
                                    sendDataMsg = true;
                                } else {
                                    int storagePolicy = msg.getReliability().compareTo((Object)Reliability.ASSURED_PERSISTENT) < 0 ? 3 : 4;
                                    AORequested requested = new AORequested(rcp, System.currentTimeMillis(), timeout, getTick);
                                    requested.inserting = true;
                                    TickRange r = new TickRange(1, getTick, getTick);
                                    r.value = requested;
                                    this.stream.writeRange(r);
                                    int reliability = msg.getReliability().getIndex();
                                    int priority = msg.getMessage().getPriority();
                                    PersistLockAndTick asyncUpdate = new PersistLockAndTick(getTick, msg, storagePolicy, 0L, this.latestTick[reliability][priority]);
                                    this.latestTick[reliability][priority] = getTick;
                                    this.parent.getPersistLockThread().enqueueWork(asyncUpdate);
                                    ++this.countAsyncUpdatesOutstanding;
                                }
                            } else if (aoTick.timeout != 0L) {
                                AORequested requested = new AORequested(rcp, System.currentTimeMillis(), aoTick.timeout, getTick);
                                TickRange r = new TickRange(1, getTick, getTick);
                                r.value = requested;
                                this.stream.writeRange(r);
                            }
                        }
                        catch (ClosedException e) {
                            TickRange r = new TickRange(7, getTick, getTick);
                            this.stream.writeCompletedRange(r);
                            if (this.parent.getCardinalityOne()) {
                                this.processRequestFlush();
                            }
                        }
                        catch (MessageStoreException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AOStream.processRequest", (String)"1:1666:1.80.3.24", (Object)this);
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        }
                        catch (SINotPossibleInCurrentConfigurationException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AOStream.processRequest", (String)"1:1676:1.80.3.24", (Object)this);
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        }
                    } else {
                        this.stream.setCursor(getTick);
                        TickRange r = this.stream.getNext();
                        if (r.type == 7) {
                            sendCompletedMsg = true;
                            completedRange = r;
                        } else if (r.type == 3) {
                            value = (AOValue)r.value;
                            try {
                                msg = this.consumerDispatcher.getMessageByValue(value);
                            }
                            catch (SIResourceException e) {
                                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                            }
                            if (msg != null) {
                                starttick = getTick;
                                sendDataMsg = true;
                            }
                        } else if (r.type == 1) {
                            AORequested requested = (AORequested)r.value;
                            if (!requested.inserting) {
                                long remainingExpiryInterval;
                                if (requested.expiryInterval == -1L) {
                                    remainingExpiryInterval = Long.MAX_VALUE;
                                } else {
                                    long elapsedInterval = System.currentTimeMillis() - requested.startTime;
                                    remainingExpiryInterval = requested.expiryInterval - elapsedInterval;
                                }
                                if (remainingExpiryInterval >= this.mp.getCustomProperties().get_slowed_get_request_interval()) {
                                    if (requestAckList == null) {
                                        requestAckList = new ArrayList<AORequested>(getTicks.length);
                                    }
                                    requestAckList.add(requested);
                                }
                            }
                        }
                    }
                }
            }
            if (sendDataMsg) {
                long prevTick = -1L;
                if (this.parent.getCardinalityOne()) {
                    prevTick = value.getPrevTick();
                }
                this.parent.sendRemoteGetData(msg, this.remoteMEUuid, this.gatheringTargetDestUuid, this.streamId, prevTick, starttick, getTick, value.getWaitTime());
                msg.releaseJsMessage();
            }
            if (!sendCompletedMsg) continue;
            this.parent.sendCompleted(this.remoteMEUuid, this.gatheringTargetDestUuid, this.streamId, completedRange);
        }
        if (requestAckList != null) {
            long[] ralist = new long[requestAckList.size()];
            for (int i = 0; i < ralist.length; ++i) {
                ralist[i] = ((AORequested)requestAckList.get((int)i)).tick;
            }
            this.parent.sendRequestAck(this.remoteMEUuid, this.gatheringTargetDestUuid, this.streamId, this.parent.dmeVersion, ralist);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processRequest");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAccept(long[] tick) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processAccept", (Object)Arrays.toString(tick));
        }
        ArrayList completedRanges = null;
        boolean transitionToFlushed = false;
        AOStream aOStream = this;
        synchronized (aOStream) {
            this.messagesReceived = true;
            if (this.completedTicksInitialized && this.active) {
                completedRanges = this.processDecisionInternal(tick, tick, null, 1, false);
                transitionToFlushed = this.tryTransitionToFlushed();
            }
        }
        if (completedRanges != null && completedRanges.size() != 0) {
            this.parent.sendCompleted(this.remoteMEUuid, this.gatheringTargetDestUuid, this.streamId, completedRanges);
        }
        if (transitionToFlushed) {
            this.parent.sendFlushed(this.remoteMEUuid, this.gatheringTargetDestUuid, this.streamId);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processAccept");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processReject(long[] startTick, long[] endTick, long[] unlockCount, boolean recovery) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processReject", (Object)new Object[]{Arrays.toString(startTick), Arrays.toString(endTick), Arrays.toString(unlockCount), recovery});
        }
        ArrayList completedRanges = null;
        boolean transitionToFlushed = false;
        AOStream aOStream = this;
        synchronized (aOStream) {
            this.messagesReceived = true;
            if (this.completedTicksInitialized && this.active) {
                completedRanges = this.processDecisionInternal(startTick, endTick, unlockCount, 2, recovery);
                transitionToFlushed = this.tryTransitionToFlushed();
            }
        }
        if (completedRanges != null && completedRanges.size() != 0) {
            this.parent.sendCompleted(this.remoteMEUuid, this.gatheringTargetDestUuid, this.streamId, completedRanges);
        }
        if (transitionToFlushed) {
            this.parent.sendFlushed(this.remoteMEUuid, this.gatheringTargetDestUuid, this.streamId);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processReject");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processCompleted(long[] startTick, long[] endTick) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processCompleted", (Object)new Object[]{Arrays.toString(startTick), Arrays.toString(endTick)});
        }
        boolean transitionToFlushed = false;
        AOStream aOStream = this;
        synchronized (aOStream) {
            this.messagesReceived = true;
            if (this.completedTicksInitialized && this.active) {
                this.processDecisionInternal(startTick, endTick, null, 3, false);
                transitionToFlushed = this.tryTransitionToFlushed();
            }
        }
        if (transitionToFlushed) {
            this.parent.sendFlushed(this.remoteMEUuid, this.gatheringTargetDestUuid, this.streamId);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processCompleted");
        }
    }

    private ArrayList processDecisionInternal(long[] startTick, long[] endTick, long[] rejectUnlockCount, int type, boolean recovery) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processDecisionInternal", (Object)new Object[]{Arrays.toString(startTick), Arrays.toString(endTick), Arrays.toString(rejectUnlockCount), type, recovery});
        }
        ArrayList<AOValue> asyncTicksToRemove = new ArrayList<AOValue>(startTick.length);
        ArrayList<AOValue> syncTicksToRemove = new ArrayList<AOValue>(startTick.length);
        ArrayList<TickRange> completedRanges = new ArrayList<TickRange>(startTick.length);
        for (int i = 0; i < startTick.length; ++i) {
            TickRange r1;
            this.stream.setCursor(startTick[i]);
            TickRange r2 = r1 = this.stream.getNext();
            TickRange writeRange = null;
            while (r1.startstamp <= endTick[i]) {
                if (r1.type == 0 || r1.type == 7) {
                    writeRange = this.startOrIncludeInWriteRange(writeRange, startTick[i], endTick[i], r1);
                } else if (r1.type == 1) {
                    AORequested req = (AORequested)r1.value;
                    if (req.inserting) {
                        if (writeRange != null) {
                            completedRanges.add(writeRange);
                            writeRange = null;
                        }
                    } else {
                        writeRange = this.startOrIncludeInWriteRange(writeRange, startTick[i], endTick[i], r1);
                        req.aock.cancelRequest(r1.startstamp);
                    }
                } else if (r1.type == 3) {
                    AOValue value = (AOValue)r1.value;
                    if (value.removing) {
                        if (writeRange != null) {
                            completedRanges.add(writeRange);
                            writeRange = null;
                        }
                    } else if (value.getStorageStrategy() == 4 || value.getStorageStrategy() == 3) {
                        if (value.isRestored()) {
                            value.removing = true;
                            if (type == 2) {
                                value.rmeUnlockCount = rejectUnlockCount != null && rejectUnlockCount.length > i ? rejectUnlockCount[i] : 1L;
                            }
                            asyncTicksToRemove.add(value);
                        }
                        if (writeRange != null) {
                            completedRanges.add(writeRange);
                            writeRange = null;
                        }
                    } else if (value.getStorageStrategy() == 1) {
                        syncTicksToRemove.add(value);
                        writeRange = this.startOrIncludeInWriteRange(writeRange, startTick[i], endTick[i], r1);
                    }
                }
                r2 = r1;
                r1 = this.stream.getNext();
                if (r1 != r2) continue;
            }
            if (this.firstUnknownTick <= endTick[i]) {
                this.firstUnknownTick = endTick[i] + 1L;
            }
            if (writeRange == null) continue;
            completedRanges.add(writeRange);
            writeRange = null;
        }
        this.doWriteCompletedRanges(completedRanges);
        if (asyncTicksToRemove.size() > 0) {
            if (type == 1) {
                ConsumeAcceptedTicks asyncUpdate = new ConsumeAcceptedTicks(asyncTicksToRemove);
                this.doEnqueueWork(asyncUpdate);
            } else if (type == 2) {
                UnlockRejectedTicks asyncUpdate = new UnlockRejectedTicks(asyncTicksToRemove);
                this.doEnqueueWork(asyncUpdate);
            } else if (type == 3) {
                UnlockRejectedTicks asyncUpdate = new UnlockRejectedTicks(asyncTicksToRemove);
                this.doEnqueueWork(asyncUpdate);
            }
        }
        if (syncTicksToRemove.size() > 0) {
            if (type == 1) {
                this.consumeNonPersistentMessages(syncTicksToRemove);
            } else if (type == 2) {
                if (recovery) {
                    this.consumeNonPersistentMessages(syncTicksToRemove);
                } else {
                    this.unlockNonPersistentMessages(syncTicksToRemove);
                }
            } else if (type == 3) {
                this.unlockNonPersistentMessages(syncTicksToRemove);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processDecisionInternal", completedRanges);
        }
        return completedRanges;
    }

    public synchronized void syncRemoveValueTick(long tick, Transaction msTran, SIMPMessage msgToDiscard) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"syncRemoveValueTick", (Object)new Object[]{tick, msTran});
        }
        AOValue value = null;
        this.stream.setCursor(tick);
        TickRange r = this.stream.getNext();
        if (r.type == 3) {
            value = (AOValue)r.value;
            if (value.removing) {
                value = null;
            } else {
                value.removing = true;
            }
        }
        TickRange r2 = new TickRange(7, tick, tick);
        r2 = this.stream.writeCompleted(r2);
        if (!this.active) {
            r2 = null;
        }
        boolean transitionToFlushed = this.tryTransitionToFlushed();
        if (value != null) {
            this.dem.removeTimeoutEntry(value);
            try {
                if (value.getStorageStrategy() == 4 || value.getStorageStrategy() == 3) {
                    if (msgToDiscard != null && msgToDiscard.isInStore()) {
                        msgToDiscard.remove(msTran, value.getPLockId());
                    }
                    value.remove(msTran, -2L);
                } else if (msgToDiscard != null && msgToDiscard.isInStore()) {
                    msgToDiscard.remove(msTran, msgToDiscard.getLockID());
                }
            }
            catch (MessageStoreException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AOStream.syncRemoveValueTick", (String)"1:2176:1.80.3.24", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"syncRemoveValueTick", (Object)((Object)e));
                }
                throw new SIResourceException((Throwable)e);
            }
            if (r2 != null) {
                this.parent.sendCompleted(this.remoteMEUuid, this.gatheringTargetDestUuid, this.streamId, r2);
            }
            if (transitionToFlushed) {
                this.parent.sendFlushed(this.remoteMEUuid, this.gatheringTargetDestUuid, this.streamId);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"syncRemoveValueTick");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processHighestGeneratedTick(long requestId, long tick) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processHighestGeneratedTick", (Object)new Object[]{requestId, tick});
        }
        AOStream aOStream = this;
        synchronized (aOStream) {
            if (requestId == this.initRequestId && !this.completedTicksInitialized) {
                this.changeUnknownToCompleted(0L, tick);
                this.firstUnknownTick = tick + 1L;
                if (tick < this.initHighestValueTick) {
                    SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AOStream", "1:2226:1.80.3.24"}, null));
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AOStream.processHighestGeneratedTick", (String)"1:2232:1.80.3.24", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AOStream", "1:2238:1.80.3.24"});
                } else {
                    this.completedTicksInitialized = true;
                    if (this.initRepeatHandler != null) {
                        this.initRepeatHandler.cancel();
                        this.initRepeatHandler = null;
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processHighestGeneratedTick");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAreYouFlushed(long requestId, SIBUuid12 parentDest) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processAreYouFlushed", (Object)new Object[]{new Long(requestId), parentDest});
        }
        boolean sendFlushed = false;
        boolean sendNotFlushed = false;
        long completedPrefix = 0L;
        long duplicatePrefix = 0L;
        AOStream aOStream = this;
        synchronized (aOStream) {
            if (this.active) {
                if (this.isFlushed) {
                    sendFlushed = true;
                } else {
                    sendNotFlushed = true;
                    if (this.completedTicksInitialized) {
                        completedPrefix = this.stream.getCompletedPrefix();
                        duplicatePrefix = this.firstUnknownTick - 1L;
                    } else {
                        completedPrefix = 0L;
                        duplicatePrefix = 0L;
                    }
                }
            }
        }
        if (sendFlushed) {
            this.parent.sendFlushed(this.remoteMEUuid, this.gatheringTargetDestUuid, this.streamId);
        } else if (sendNotFlushed) {
            this.parent.sendNotFlushed(this.remoteMEUuid, this.gatheringTargetDestUuid, this.streamId, requestId, completedPrefix, duplicatePrefix, parentDest);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processAreYouFlushed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequestFlush() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processRequestFlush");
        }
        boolean sendFlushed = false;
        AOStream aOStream = this;
        synchronized (aOStream) {
            if (this.startedFlush) {
                sendFlushed = this.isFlushed && this.active ? true : this.tryTransitionToFlushed();
            } else if (!this.scheduleWriteStartedFlush) {
                this.scheduleWriteStartedFlush = true;
                WriteStartedFlush update = new WriteStartedFlush();
                this.doEnqueueWork(update);
            }
        }
        if (sendFlushed) {
            this.parent.sendFlushed(this.remoteMEUuid, this.gatheringTargetDestUuid, this.streamId);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processRequestFlush");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"close");
        }
        AOStream aOStream = this;
        synchronized (aOStream) {
            TickRange r1;
            this.closeInternal();
            this.stream.setCursor(0L);
            TickRange r2 = r1 = this.stream.getNext();
            ArrayList<AOValue> syncTicksToRemove = new ArrayList<AOValue>();
            do {
                AOValue value;
                if (r1.type == 3 && (value = (AOValue)r1.value).getStorageStrategy() == 1) {
                    syncTicksToRemove.add(value);
                }
                r2 = r1;
            } while ((r1 = this.stream.getNext()) != r2);
            this.unlockNonPersistentMessages(syncTicksToRemove);
            if (this.countAsyncUpdatesOutstanding != 0) {
                long sleepTime = 5000L;
                long maxWaitTime = 60000L;
                int sleepCount = (int)(maxWaitTime / sleepTime);
                for (int i = 0; this.countAsyncUpdatesOutstanding != 0 && i < sleepCount; ++i) {
                    try {
                        Thread.sleep(sleepTime);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.countAsyncUpdatesOutstanding != 0) {
                    SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AOStream", "1:2407:1.80.3.24"}, null));
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AOStream.close", (String)"1:2412:1.80.3.24", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AOStream", "1:2418:1.80.3.24"});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"close");
                    }
                    throw e;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"close");
        }
    }

    @Override
    public String getID() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getID");
        }
        String id = this.streamId.toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getID", (Object)id);
        }
        return id;
    }

    public synchronized long getNumberOfRequestsInState(int requiredState) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNumberOfRequestsInState", (Object)requiredState);
        }
        long requestCount = 0L;
        this.stream.setCursor(0L);
        this.stream.getNext();
        TickRange tr = this.stream.getNext();
        while (tr.endstamp < Long.MAX_VALUE) {
            if (tr.type == requiredState) {
                ++requestCount;
            }
            tr = this.stream.getNext();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNumberOfRequestsInState", (Object)requestCount);
        }
        return requestCount;
    }

    public long getDMEVersion() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDMEVersion");
            SibTr.exit((TraceComponent)tc, (String)"getDMEVersion", (Object)this.dmeVerion);
        }
        return this.dmeVerion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writtenStartedFlush() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writtenStartedFlush");
        }
        boolean sendFlushed = false;
        AOStream aOStream = this;
        synchronized (aOStream) {
            if (!this.startedFlush) {
                this.startedFlush = true;
                this.completedTicksInitialized = true;
                if (this.initRepeatHandler != null) {
                    this.initRepeatHandler.cancel();
                    this.initRepeatHandler = null;
                }
                this.firstUnknownTick = Long.MAX_VALUE;
                if (!this.parent.getCardinalityOne() || !this.parent.isMEReachable(this.remoteMEUuid)) {
                    Enumeration vEnum = this.consumerKeyTable.elements();
                    while (vEnum.hasMoreElements()) {
                        JSRemoteConsumerPoint aock = (JSRemoteConsumerPoint)vEnum.nextElement();
                        aock.close();
                    }
                    this.consumerKeyTable.clear();
                }
                this.changeUnknownToCompleted(0L, Long.MAX_VALUE);
                sendFlushed = this.tryTransitionToFlushed();
            }
        }
        if (sendFlushed) {
            this.parent.sendFlushed(this.remoteMEUuid, this.gatheringTargetDestUuid, this.streamId);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writtenStartedFlush");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResetRequestAckAck() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processResetRequestAckAck");
        }
        AOStream aOStream = this;
        synchronized (aOStream) {
            if (this.resetRequestAckSender != null) {
                this.resetRequestAckSender.stop();
                this.resetRequestAckSender = null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processResetRequestAckAck");
        }
    }

    private void changeUnknownToCompleted(long startTick, long endTick) {
        TickRange r1;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"changeUnknownToCompleted", (Object)new Object[]{startTick, endTick});
        }
        this.stream.setCursor(startTick);
        TickRange r2 = r1 = this.stream.getNext();
        TickRange writeRange = null;
        ArrayList<TickRange> list = new ArrayList<TickRange>(5);
        while (r1.startstamp <= endTick) {
            if (r1.type == 0) {
                writeRange = this.startOrIncludeInWriteRange(writeRange, startTick, endTick, r1);
            } else if (writeRange != null) {
                list.add(writeRange);
                writeRange = null;
            }
            r2 = r1;
            r1 = this.stream.getNext();
            if (r1 != r2) continue;
        }
        if (writeRange != null) {
            list.add(writeRange);
            writeRange = null;
        }
        this.doWriteCompletedRanges(list);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"changeUnknownToCompleted");
        }
    }

    private final void doWriteCompletedRanges(List completedRanges) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"doWriteCompletedRanges", (Object)new Object[]{completedRanges});
        }
        int length = completedRanges.size();
        for (int i = 0; i < length; ++i) {
            completedRanges.set(i, this.stream.writeCompletedRange((TickRange)completedRanges.get(i)));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"doWriteCompletedRanges");
        }
    }

    private final void doEnqueueWork(AsyncUpdate asyncUpdate) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"doEnqueueWork", (Object)asyncUpdate);
        }
        try {
            this.msUpdateThread.enqueueWork(asyncUpdate);
            ++this.countAsyncUpdatesOutstanding;
        }
        catch (ClosedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AOStream.doEnqueueWork", (String)"1:2713:1.80.3.24", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"doEnqueueWork");
        }
    }

    private final TickRange startOrIncludeInWriteRange(TickRange writeRange, long lowerBound, long upperBound, TickRange r) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"startOrIncludeInWriteRange");
        }
        if (writeRange == null) {
            writeRange = new TickRange(7, 0L, 0L);
            writeRange.startstamp = AOStream.max(r.startstamp, lowerBound);
            writeRange.endstamp = AOStream.min(r.endstamp, upperBound);
        } else {
            writeRange.endstamp = AOStream.min(r.endstamp, upperBound);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"startOrIncludeInWriteRange", (Object)writeRange);
        }
        return writeRange;
    }

    private final void consumeNonPersistentMessages(ArrayList consumeList) {
        block7: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"consumeNonPersistentMessages", (Object)consumeList);
            }
            LocalTransaction tran = this.parent.getLocalTransaction();
            try {
                Transaction msTran = this.parent.getMessageProcessor().resolveAndEnlistMsgStoreTransaction((TransactionCommon)tran);
                int length = consumeList.size();
                for (int i = 0; i < length; ++i) {
                    AOValue value = (AOValue)consumeList.get(i);
                    this.dem.removeTimeoutEntry(value);
                    SIMPMessage msgItem = this.consumerDispatcher.getMessageByValue(value);
                    if (msgItem == null) continue;
                    msgItem.remove(msTran, msgItem.getLockID());
                }
                tran.commit();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AOStream.consumeNonPersistentMessages", (String)"1:2792:1.80.3.24", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)e);
                try {
                    tran.commit();
                }
                catch (SIException e2) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                    SibTr.debug((TraceComponent)tc, (String)("commit failed " + (Object)((Object)e2)));
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"consumeNonPersistentMessages");
        }
    }

    private final void unlockNonPersistentMessages(ArrayList unlockList) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unlockNonPersistentMessages", (Object)unlockList);
        }
        try {
            int length = unlockList.size();
            for (int i = 0; i < length; ++i) {
                AOValue value = (AOValue)unlockList.get(i);
                this.dem.removeTimeoutEntry(value);
                SIMPMessage msgItem = this.consumerDispatcher.getMessageByValue(value);
                if (msgItem == null) continue;
                msgItem.unlockMsg(msgItem.getLockID(), null, true);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AOStream.unlockNonPersistentMessages", (String)"1:2846:1.80.3.24", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unlockNonPersistentMessages");
        }
    }

    private final JSRemoteConsumerPoint findOrCreateJSRemoteConsumerPoint(String[] discriminators, int[] selectorDomains, String[] selectors) throws ClosedException {
        String selectionCriteriasAsString;
        JSRemoteConsumerPoint aock;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"findOrCreateJSRemoteConsumerPoint", (Object)new Object[]{Arrays.toString(discriminators), Arrays.toString(selectorDomains), Arrays.toString(selectors)});
        }
        if ((aock = (JSRemoteConsumerPoint)this.consumerKeyTable.get(selectionCriteriasAsString = this.parent.convertSelectionCriteriasToString(discriminators, selectorDomains, selectors))) == null) {
            try {
                aock = new JSRemoteConsumerPoint();
                SelectionCriteria[] criterias = new SelectionCriteria[discriminators.length];
                ConsumableKey[] consumerKeys = new ConsumableKey[discriminators.length];
                OrderingContextImpl ocontext = null;
                SIBUuid12 connectionUuid = new SIBUuid12();
                if (discriminators.length > 1) {
                    ocontext = new OrderingContextImpl();
                }
                for (int i = 0; i < discriminators.length; ++i) {
                    SelectorDomain domain = SelectorDomain.getSelectorDomain((int)selectorDomains[i]);
                    criterias[i] = this.parent.createSelectionCriteria(discriminators[i], selectors[i], domain);
                    consumerKeys[i] = (ConsumableKey)this.consumerDispatcher.attachConsumerPoint(aock, criterias[i], connectionUuid, false, false, null);
                    if (ocontext != null) {
                        this.consumerDispatcher.joinKeyGroup(consumerKeys[i], ocontext);
                    }
                    consumerKeys[i].start();
                }
                if (this.parent.getCardinalityOne() || this.consumerDispatcher.isPubSub()) {
                    aock.init(this, selectionCriteriasAsString, consumerKeys, 0L, this.am, criterias);
                } else {
                    aock.init(this, selectionCriteriasAsString, consumerKeys, this.mp.getCustomProperties().get_ck_idle_timeout(), this.am, criterias);
                }
                this.consumerKeyTable.put(selectionCriteriasAsString, aock);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AOStream.findOrCreateJSRemoteConsumerPoint", (String)"1:2942:1.80.3.24", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)e);
                aock = null;
                ClosedException e2 = new ClosedException(e);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"findOrCreateJSRemoteConsumerPoint", (Object)e2);
                }
                throw e2;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"findOrCreateJSRemoteConsumerPoint", (Object)aock);
        }
        return aock;
    }

    private final boolean tryTransitionToFlushed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"tryTransitionToFlushed");
        }
        boolean ret = false;
        if (this.startedFlush && !this.isFlushed && this.stream.getCompletedPrefix() == Long.MAX_VALUE) {
            this.isFlushed = true;
            ret = this.active;
            this.closeInternal();
            this.parent.streamIsFlushed(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"tryTransitionToFlushed", (Object)ret);
        }
        return ret;
    }

    private final void closeInternal() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"closeInternal");
        }
        this.stop();
        this.dem.close();
        this.closed = true;
        Enumeration vEnum = this.consumerKeyTable.elements();
        while (vEnum.hasMoreElements()) {
            JSRemoteConsumerPoint aock = (JSRemoteConsumerPoint)vEnum.nextElement();
            aock.close();
        }
        this.consumerKeyTable.clear();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"closeInternal");
        }
    }

    private static final long max(long a, long b) {
        return a > b ? a : b;
    }

    private static final long min(long a, long b) {
        return a > b ? b : a;
    }

    @Override
    public long getCompletedPrefix() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getCompletedPrefix");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getCompletedPrefix", (Object)this.stream.getCompletedPrefix());
        }
        return this.stream.getCompletedPrefix();
    }

    @Override
    protected int getPriority() {
        return 0;
    }

    @Override
    protected Reliability getReliability() {
        return null;
    }

    public SIBUuid8 getRemoteMEUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteMEUuid");
            SibTr.exit((TraceComponent)tc, (String)"getRemoteMEUuid", (Object)this.remoteMEUuid);
        }
        return this.remoteMEUuid;
    }

    public SIBUuid12 getGatheringTargetDestUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"gatheringTargetDestUuid");
            SibTr.exit((TraceComponent)tc, (String)"gatheringTargetDestUuid", (Object)this.gatheringTargetDestUuid);
        }
        return this.gatheringTargetDestUuid;
    }

    @Override
    public StateStream getStateStream() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStateStream");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStateStream", (Object)this.stream);
        }
        return this.stream;
    }

    public AOStreamState getStreamState() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamState");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamState", (Object)this.streamState);
        }
        return this.streamState;
    }

    public synchronized long getTotalRequestsReceived() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTotalRequestsReceived");
            SibTr.exit((TraceComponent)tc, (String)"getTotalRequestsReceived");
        }
        return this.totalReceivedRequests;
    }

    @Override
    public void writeSilenceForced(long tick) {
    }

    public final void unlockRejectedTick(TransactionCommon t, AOValue storedTick) throws MessageStoreException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unlockRejectedTick");
        }
        try {
            SIMPMessage msg = this.consumerDispatcher.getMessageByValue(storedTick);
            Transaction msTran = this.mp.resolveAndEnlistMsgStoreTransaction(t);
            if (msg != null) {
                boolean incrementCount = false;
                if (storedTick.rmeUnlockCount > 0L) {
                    incrementCount = true;
                    msg.setRMEUnlockCount(storedTick.rmeUnlockCount - 1L);
                }
                if (msg.getLockID() == storedTick.getPLockId()) {
                    msg.unlockMsg(storedTick.getPLockId(), msTran, incrementCount);
                }
            }
            storedTick.lockItemIfAvailable(this.controlItemLockID);
            storedTick.remove(msTran, this.controlItemLockID);
        }
        catch (MessageStoreException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"unlockRejectedTick", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unlockRejectedTick");
        }
    }

    public final void consumeAcceptedTick(TransactionCommon t, AOValue storedTick) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"consumeAcceptedTick", (Object)storedTick);
        }
        try {
            SIMPMessage msg = this.consumerDispatcher.getMessageByValue(storedTick);
            Transaction msTran = this.mp.resolveAndEnlistMsgStoreTransaction(t);
            if (msg != null) {
                msg.remove(msTran, storedTick.getPLockId());
            }
            storedTick.lockItemIfAvailable(this.controlItemLockID);
            storedTick.remove(msTran, this.controlItemLockID);
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"consumeAcceptedTick", (Object)e);
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"consumeAcceptedTick");
        }
    }

    @Override
    public void createControlAdapter() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlAdapter");
        }
        this._controlAdapter = new RemoteConsumerTransmit(this, this.parent);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlAdapter");
        }
    }

    @Override
    public void dereferenceControlAdapter() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControlAdapter");
        }
        this._controlAdapter = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControlAdapter");
        }
    }

    @Override
    public ControlAdapter getControlAdapter() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getControlAdapter");
        }
        if (this._controlAdapter == null) {
            this.createControlAdapter();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getControlAdapter");
        }
        return this._controlAdapter;
    }

    @Override
    public void registerControlAdapterAsMBean() {
    }

    @Override
    public void deregisterControlAdapterMBean() {
    }

    public String toString() {
        String text = super.toString() + "[";
        text = text + "StreamId:" + this.streamId + "]";
        return text;
    }

    class InactivityTimerHandler
    implements AlarmListener {
        InactivityTimerHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void alarm(Object thandle) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)new Object[]{thandle, "InactivityTimerHandler", AOStream.this});
            }
            AOStream aOStream = AOStream.this;
            synchronized (aOStream) {
                if (AOStream.this.active) {
                    if (!(AOStream.this.isFlushed || AOStream.this.messagesReceived || AOStream.this.parent.isMEReachable(AOStream.this.remoteMEUuid))) {
                        if (!AOStream.this.startedFlush) {
                            AOStream.this.processRequestFlush();
                        }
                        Enumeration vEnum = AOStream.this.consumerKeyTable.elements();
                        while (vEnum.hasMoreElements()) {
                            JSRemoteConsumerPoint aock = (JSRemoteConsumerPoint)vEnum.nextElement();
                            aock.close();
                        }
                        AOStream.this.consumerKeyTable.clear();
                        if (!AOStream.this.startedFlush) {
                            AOStream.this.inactivityTimer = AOStream.this.am.create(AOStream.this.mp.getCustomProperties().get_remote_consumer_cardinality_inactivity_interval(), AOStream.this.inactivityHandler);
                        }
                    } else if (!AOStream.this.isFlushed) {
                        AOStream.this.inactivityTimer = AOStream.this.am.create(AOStream.this.mp.getCustomProperties().get_remote_consumer_cardinality_inactivity_interval(), AOStream.this.inactivityHandler);
                    }
                    AOStream.this.messagesReceived = false;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"alarm");
            }
        }
    }

    public static class AOStreamState
    implements SIMPDeliveryTransmitControllable.StreamState {
        public static final AOStreamState ACTIVE = new AOStreamState("Active", 1);
        private String name;
        private int id;

        private AOStreamState(String _name, int _id) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"AOStreamState", (Object)new Object[]{_name, _id});
            }
            this.name = _name;
            this.id = _id;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"AOStreamState", (Object)this);
            }
        }

        public String toString() {
            return this.name;
        }

        public int getValue() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getValue");
                SibTr.exit((TraceComponent)tc, (String)"getValue", (Object)this.id);
            }
            return this.id;
        }
    }

    class ResetRequestAckSender
    implements AlarmListener {
        final long initTime = System.currentTimeMillis();
        boolean done = false;
        Alarm rraAlarm;

        ResetRequestAckSender() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean start() {
            AOStream aOStream = AOStream.this;
            synchronized (aOStream) {
                if (!this.done) {
                    this.alarm(null);
                }
                return this.done;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop() {
            AOStream aOStream = AOStream.this;
            synchronized (aOStream) {
                if (this.rraAlarm != null) {
                    this.rraAlarm.cancel();
                    this.rraAlarm = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void alarm(Object thandle) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)new Object[]{thandle, "ResetRequestAckSender", AOStream.this});
            }
            boolean sendMsg = false;
            long currTime = System.currentTimeMillis();
            AOStream aOStream = AOStream.this;
            synchronized (aOStream) {
                if (currTime - this.initTime > AOStream.this.mp.getCustomProperties().get_slowed_get_request_interval()) {
                    this.rraAlarm = null;
                    this.done = true;
                } else {
                    sendMsg = AOStream.this.active;
                    this.rraAlarm = AOStream.this.am.create(AOStream.this.mp.getCustomProperties().get_reset_repetition_interval(), this);
                }
            }
            if (sendMsg) {
                AOStream.this.parent.sendResetRequestAck(AOStream.this.remoteMEUuid, AOStream.this.gatheringTargetDestUuid, AOStream.this.streamId, ((AOStream)AOStream.this).parent.dmeVersion);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"alarm");
            }
        }
    }

    class RequestHighestGeneratedTick
    implements AlarmListener {
        RequestHighestGeneratedTick() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void alarm(Object thandle) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)new Object[]{thandle, "RequestHighestGeneratedTick", AOStream.this});
            }
            boolean sendMsg = false;
            long requestId = -1L;
            AOStream aOStream = AOStream.this;
            synchronized (aOStream) {
                if (AOStream.this.isFlushed && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Sending requestHighestGeneratedTick despite stream being flushed!");
                }
                if (AOStream.this.active && !AOStream.this.completedTicksInitialized) {
                    sendMsg = true;
                    requestId = AOStream.this.initRequestId;
                    AOStream.this.initRepeatHandler = AOStream.this.am.create(AOStream.this.mp.getCustomProperties().get_init_repetition_interval(), this);
                }
            }
            if (sendMsg) {
                AOStream.this.parent.sendRequestHighestGeneratedTick(AOStream.this.remoteMEUuid, AOStream.this.gatheringTargetDestUuid, AOStream.this.streamId, requestId);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"alarm");
            }
        }
    }

    class PersistLockAndTick
    extends AnycastOutputHandler.AsyncUpdateWithRetry {
        long tick;
        SIMPMessage msg;
        int storagePolicy;
        long waitTime;
        long prevTick;
        AOValue storedTick;

        public PersistLockAndTick(long tick, SIMPMessage msg, int storagePolicy, long waitTime, long prevTick) {
            super(-1L, AOStream.this.parent.getPersistLockThread(), AOStream.this.parent.getDestName());
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"PersistLockAndTick", (Object)new Object[]{tick, msg, storagePolicy, waitTime, prevTick});
            }
            this.tick = tick;
            this.msg = msg;
            this.storagePolicy = storagePolicy;
            this.waitTime = waitTime;
            this.prevTick = prevTick;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"PersistLockAndTick", (Object)this);
            }
        }

        @Override
        public void execute(TransactionCommon t) throws Throwable {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"execute", (Object)new Object[]{t, "PersistLockAndTick", AOStream.this});
            }
            this.storedTick = AOStream.this.parent.persistLockAndTick(t, AOStream.this, this.tick, this.msg, this.storagePolicy, this.waitTime, this.prevTick);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"execute");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rolledback(Throwable e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"rolledback", (Object)new Object[]{e, "PersistLockAndTick", AOStream.this});
            }
            if (!this.rolledbackRetry(e)) {
                PersistLockAndTick persistLockAndTick = this;
                synchronized (persistLockAndTick) {
                    AOStream.this.countAsyncUpdatesOutstanding--;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"rolledback");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void committed() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"committed", (Object)new Object[]{"PersistLockAndTick", AOStream.this});
            }
            TickRange r2 = null;
            boolean sendMsg = false;
            AOStream aOStream = AOStream.this;
            synchronized (aOStream) {
                AOStream.this.countAsyncUpdatesOutstanding--;
                r2 = TickRange.newValueTick(this.tick, this.storedTick, 0L);
                AOStream.this.stream.writeCombinedRange(r2);
                r2 = AOStream.this.stream.findCompletedRange(r2);
                AOStream.this.dem.addTimeoutEntry(this.storedTick);
                if (AOStream.this.active) {
                    sendMsg = true;
                }
            }
            if (sendMsg) {
                long prevTick = this.storedTick.getPrevTick();
                AOStream.this.parent.sendRemoteGetData(this.msg, AOStream.this.remoteMEUuid, AOStream.this.gatheringTargetDestUuid, AOStream.this.streamId, prevTick, r2.startstamp, this.tick, this.waitTime);
                this.msg.releaseJsMessage();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"committed");
            }
        }
    }

    class ConsumeAcceptedTicks
    extends AnycastOutputHandler.AsyncUpdateWithRetry {
        ArrayList storedTicks;

        public ConsumeAcceptedTicks(ArrayList storedTicks) {
            super(-1L, AOStream.this.msUpdateThread, AOStream.this.parent.getDestName());
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"ConsumeAcceptedTicks", (Object)storedTicks);
            }
            this.storedTicks = storedTicks;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"ConsumeAcceptedTicks", (Object)this);
            }
        }

        @Override
        public void execute(TransactionCommon t) throws Throwable {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"execute", (Object)new Object[]{t, "ConsumeAcceptedTicks", AOStream.this});
            }
            for (int i = 0; i < this.storedTicks.size(); ++i) {
                AOStream.this.consumeAcceptedTick(t, (AOValue)this.storedTicks.get(i));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"execute");
            }
        }

        @Override
        public void committed() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"committed", (Object)new Object[]{"ConsumeAcceptedTicks", AOStream.this});
            }
            AOStream.this.storedTicksRemoved(this.storedTicks);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"committed");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rolledback(Throwable e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"rolledback", (Object)new Object[]{e, "ConsumeAcceptedTicks", AOStream.this});
            }
            if (!this.rolledbackRetry(e)) {
                ConsumeAcceptedTicks consumeAcceptedTicks = this;
                synchronized (consumeAcceptedTicks) {
                    AOStream.this.countAsyncUpdatesOutstanding--;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"rolledback");
            }
        }
    }

    class UnlockRejectedTicks
    extends AnycastOutputHandler.AsyncUpdateWithRetry {
        ArrayList storedTicks;

        public UnlockRejectedTicks(ArrayList storedTicks) {
            super(-1L, AOStream.this.msUpdateThread, AOStream.this.parent.getDestName());
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"UnlockRejectedTicks", (Object)storedTicks);
            }
            this.storedTicks = storedTicks;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"UnlockRejectedTicks", (Object)this);
            }
        }

        @Override
        public void execute(TransactionCommon t) throws Throwable {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"execute", (Object)new Object[]{t, "UnlockRejectedTicks", AOStream.this});
            }
            for (int i = 0; i < this.storedTicks.size(); ++i) {
                AOStream.this.unlockRejectedTick(t, (AOValue)this.storedTicks.get(i));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"execute");
            }
        }

        @Override
        public void committed() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"committed", (Object)new Object[]{"UnlockRejectedTicks", AOStream.this});
            }
            AOStream.this.storedTicksRemoved(this.storedTicks);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"committed");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rolledback(Throwable e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"rolledback", (Object)new Object[]{e, "UnlockRejectedTicks", AOStream.this});
            }
            if (!this.rolledbackRetry(e)) {
                UnlockRejectedTicks unlockRejectedTicks = this;
                synchronized (unlockRejectedTicks) {
                    AOStream.this.countAsyncUpdatesOutstanding--;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"rolledback");
            }
        }
    }

    class WriteStartedFlush
    extends AnycastOutputHandler.AsyncUpdateWithRetry {
        Item startedFlushItem;

        WriteStartedFlush() {
            super(-1L, AOStream.this.msUpdateThread, AOStream.this.parent.getDestName());
            this.startedFlushItem = null;
        }

        @Override
        public void execute(TransactionCommon t) throws Throwable {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"execute", (Object)new Object[]{t, "WriteStartedFlush", AOStream.this});
            }
            this.startedFlushItem = AOStream.this.parent.writeStartedFlush(t, AOStream.this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"execute");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rolledback(Throwable e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"rolledback", (Object)new Object[]{e, "WriteStartedFlush", AOStream.this});
            }
            if (!this.rolledbackRetry(e)) {
                WriteStartedFlush writeStartedFlush = this;
                synchronized (writeStartedFlush) {
                    AOStream.this.countAsyncUpdatesOutstanding--;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"rolledback");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void committed() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"committed", (Object)new Object[]{"WriteStartedFlush", AOStream.this});
            }
            WriteStartedFlush writeStartedFlush = this;
            synchronized (writeStartedFlush) {
                AOStream.this.countAsyncUpdatesOutstanding--;
            }
            AOStream.this.parent.writtenStartedFlush(AOStream.this, this.startedFlushItem);
            AOStream.this.writtenStartedFlush();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"committed");
            }
        }
    }
}

