/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.util;

import com.ibm.ws.webcontainer.util.ClauseNode;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class URIMatcher {
    protected ClauseNode root;
    protected HashMap<String, Object> extensions = new HashMap();
    protected static final String starString = "*";
    protected ClauseNode defaultNode;
    protected static int range = 91;

    public static int computeHash(String key) {
        int hash = 0;
        for (int i = 0; i < key.length(); ++i) {
            hash = hash * range + key.charAt(i);
        }
        return hash;
    }

    public URIMatcher() {
        this(false, false);
    }

    public URIMatcher(boolean scalable) {
        this(scalable, false);
    }

    public URIMatcher(boolean scalable, boolean stringKeys) {
        this.init();
    }

    public URIMatcher(boolean scalable, int r) {
        range = r;
        this.init();
    }

    URIMatcher(String file) throws Exception {
        this();
        BufferedReader in = new BufferedReader(new FileReader(file));
        String line = in.readLine();
        while (line != null) {
            if (line.equals("")) {
                line = in.readLine();
                continue;
            }
            StringTokenizer tok = new StringTokenizer(line);
            String tok1 = tok.nextToken();
            String tok2 = tok.nextToken();
            this.put(tok1, tok2);
            line = in.readLine();
        }
        in.close();
    }

    private void init() {
        if (this.root == null) {
            this.root = new ClauseNode(null, "/", null);
        }
    }

    public void put(String uri, Object target) throws Exception {
        if (uri.startsWith("*.")) {
            this.extensions.put(uri.substring(2), target);
            return;
        }
        if (uri.equals("")) {
            this.root.setTarget(target);
            return;
        }
        int startIdx = 0;
        if (uri.length() > 0 && uri.charAt(0) == '/') {
            startIdx = 1;
        }
        ClauseNode currentNode = this.root;
        int slashIdx = uri.indexOf(47, startIdx);
        while (slashIdx != -1) {
            currentNode = currentNode.add(new ClauseNode(currentNode, uri.substring(startIdx, slashIdx), null));
            startIdx = slashIdx + 1;
            slashIdx = uri.indexOf(47, startIdx);
        }
        slashIdx = uri.length();
        if (startIdx < slashIdx) {
            String segment = uri.substring(startIdx, slashIdx);
            if (segment.equals(starString)) {
                if (currentNode.getStarTarget() != null) {
                    throw new Exception("Mapping clash for " + currentNode.getTarget() + ": Target " + target + " already exists at node " + currentNode.getClause());
                }
                currentNode.setStarTarget(target);
            } else {
                currentNode = currentNode.add(new ClauseNode(currentNode, segment, target));
            }
        }
        if (this.root.getStarTarget() != null) {
            this.defaultNode = this.root;
        }
    }

    public Iterator iterator() {
        List<Object> l = this.root.targets();
        l.addAll(this.extensions.values());
        return l.listIterator();
    }

    public Object match(String uri) {
        Result result = this.findNode(uri);
        if (result != null && result.node != this.defaultNode) {
            return result.target;
        }
        Object target = this.findByExtension(uri);
        if (target != null) {
            return target;
        }
        if (this.defaultNode != null) {
            return this.defaultNode.getStarTarget();
        }
        return null;
    }

    protected Object findByExtension(String uri) {
        Object target;
        int dot = uri.lastIndexOf(".");
        if (dot != -1 && (target = this.extensions.get(uri.substring(dot + 1))) != null) {
            return target;
        }
        return null;
    }

    protected Result findNode(String uri) {
        Result result = null;
        ClauseNode currentNode = this.root;
        ClauseNode starNode = this.defaultNode;
        int startIdx = 1;
        boolean done = false;
        while (!done) {
            String segment;
            int slashIdx = uri.indexOf(47, startIdx);
            if (slashIdx == -1) {
                done = true;
                slashIdx = uri.length();
                segment = startIdx < slashIdx ? uri.substring(startIdx, slashIdx) : null;
            } else {
                segment = uri.substring(startIdx, slashIdx);
            }
            if (segment != null) {
                if ((currentNode = currentNode.traverse(segment)) == null) {
                    done = true;
                } else {
                    if (done && currentNode.getTarget() != null) {
                        return new Result(currentNode, currentNode.getTarget());
                    }
                    if (currentNode.getStarTarget() != null) {
                        starNode = currentNode;
                    }
                }
                startIdx = slashIdx + 1;
                continue;
            }
            if (WCCustomProperties.STRICT_SERVLET_MAPPING) {
                if (currentNode.getStarTarget() != null) {
                    return new Result(currentNode, currentNode.getStarTarget());
                }
            } else if (currentNode.getTarget() != null) {
                return new Result(currentNode, currentNode.getTarget());
            }
            currentNode = null;
        }
        if (starNode != null) {
            result = new Result(starNode, starNode.getStarTarget());
        }
        return result;
    }

    public List matchAll(String uri) {
        Object target;
        Object tar;
        ClauseNode currentNode = this.root;
        ArrayList<Object> returnList = new ArrayList<Object>();
        int dot = uri.lastIndexOf(".");
        if (dot != -1 && (tar = this.extensions.get(uri.substring(dot + 1))) != null) {
            returnList.add(tar);
        }
        if (this.defaultNode != null) {
            returnList.add(this.defaultNode.getStarTarget());
        }
        boolean exact = true;
        int startIdx = 1;
        boolean done = false;
        while (!done) {
            String segment;
            int slashIdx = uri.indexOf(47, startIdx);
            if (slashIdx == -1) {
                done = true;
                slashIdx = uri.length();
                segment = startIdx < slashIdx ? uri.substring(startIdx, slashIdx) : null;
            } else {
                segment = uri.substring(startIdx, slashIdx);
            }
            if (segment == null) continue;
            if ((currentNode = currentNode.traverse(segment)) == null) {
                exact = false;
                done = true;
            } else if (currentNode.getStarTarget() != null) {
                returnList.add(currentNode.getStarTarget());
            }
            startIdx = slashIdx + 1;
        }
        if (exact && (target = currentNode.getTarget()) != null && currentNode.getStarTarget() == null) {
            returnList.add(target);
        }
        return returnList;
    }

    public void remove(String path) {
        if (path.startsWith("*.")) {
            this.extensions.remove(path.substring(2));
        }
        this.root.remove(path);
    }

    public static void main(String[] args) {
        try {
            URIMatcher t = new URIMatcher();
            t.put("/portal/*", new String("/portal/* target"));
            t.put("/portal/abc/xyz/*", new String("/portal/abc/xyz/* target1"));
            t.put("/exact/exact.jsp", new String("/exact/exact.jsp"));
            List l = t.matchAll("/portal/abc/xyz/blah.jsp");
            Iterator it = l.iterator();
            while (it.hasNext()) {
                System.out.println("out:" + it.next());
            }
            l = t.matchAll("/exact/exact.jsp");
            it = l.iterator();
            while (it.hasNext()) {
                System.out.println("out:" + it.next());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object replace(String uri, Object newTarget) throws Exception {
        if (uri.startsWith("*.")) {
            Object oldTarget = null;
            String extension = uri.substring(2);
            if (this.extensions.containsKey(extension)) {
                oldTarget = this.extensions.put(extension, newTarget);
            }
            return oldTarget;
        }
        return this.root.replace(uri, newTarget);
    }

    public boolean exists(String uri) {
        if (uri.startsWith("*.")) {
            return this.extensions.get(uri.substring(2)) != null;
        }
        Result result = this.findNode(uri);
        if (result != null) {
            ClauseNode node = result.node;
            int nodeLen = node.getDepth();
            if (node.getStarTarget() != null) {
                nodeLen += 2;
            }
            return nodeLen == uri.length();
        }
        return false;
    }

    protected static class Result {
        public ClauseNode node;
        public Object target;

        public Result(ClauseNode node, Object target) {
            this.node = node;
            this.target = target;
        }
    }
}

