/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.config.liberty;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.internal.config.AggregatedConfiguration;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Map;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(name="com.ibm.ws.cdi.config.liberty.CDIContainerConfig", service={CDIContainerConfig.class}, configurationPid={"io.openliberty.cdi.configuration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, property={"service.vendor=IBM"})
public class CDIContainerConfig {
    private static final TraceComponent tc = Tr.register(CDIContainerConfig.class, (String)"JCDI", (String)"com.ibm.ws.cdi.internal.resources.CDI");
    private Boolean enableImplicitBeanArchives = null;
    private Boolean emptyBeansXmlCDI3Compatibility = null;
    @Reference
    private AggregatedConfiguration aggregatedConfig;
    static final long serialVersionUID = 1352916536444063027L;

    protected void activate(ComponentContext compcontext, Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Activating " + this), (Object[])new Object[0]);
        }
        this.updateConfiguration(properties);
    }

    protected void deactivate(ComponentContext compcontext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Deactivating " + this), (Object[])new Object[0]);
        }
        this.updateConfiguration(null);
    }

    @Modified
    protected void modified(ComponentContext compcontext, Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Modifying " + this), (Object[])new Object[0]);
        }
        this.updateConfiguration(properties);
    }

    protected void updateConfiguration(Map<String, Object> properties) {
        if (properties != null) {
            this.enableImplicitBeanArchives = (Boolean)properties.get("enableImplicitBeanArchives");
            this.emptyBeansXmlCDI3Compatibility = (Boolean)properties.get("emptyBeansXmlCDI3Compatibility");
        } else {
            this.enableImplicitBeanArchives = null;
            this.emptyBeansXmlCDI3Compatibility = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("cdi.enableImplicitBeanArchives: " + this.enableImplicitBeanArchives), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("cdi.emptyBeansXmlCDI3Compatibility: " + this.emptyBeansXmlCDI3Compatibility), (Object[])new Object[0]);
        }
        this.aggregatedConfig.setCdiConfig(this.enableImplicitBeanArchives, this.emptyBeansXmlCDI3Compatibility);
    }
}

