/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.auth;

import io.opentelemetry.exporter.internal.grpc.GrpcExporterBuilder;
import io.opentelemetry.exporter.internal.okhttp.OkHttpExporterBuilder;
import java.lang.reflect.Field;
import java.util.Map;

public interface Authenticator {
    public Map<String, String> getHeaders();

    public static void setAuthenticatorOnDelegate(Object builder, Authenticator authenticator) {
        try {
            Field field = builder.getClass().getDeclaredField("delegate");
            field.setAccessible(true);
            Object value = field.get(builder);
            if (value instanceof GrpcExporterBuilder) {
                throw new IllegalArgumentException("GrpcExporterBuilder not supported yet.");
            }
            if (!(value instanceof OkHttpExporterBuilder)) {
                throw new IllegalArgumentException("Delegate field is not type DefaultGrpcExporterBuilder or OkHttpGrpcExporterBuilder.");
            }
            ((OkHttpExporterBuilder)value).setAuthenticator(authenticator);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalArgumentException("Unable to access delegate reflectively.", e);
        }
    }
}

