/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.management;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.jpa.JPAPuId;
import com.ibm.ws.jpa.management.JPAPUnitInfo;
import jakarta.persistence.SharedCacheMode;
import jakarta.persistence.ValidationMode;
import jakarta.persistence.spi.ClassTransformer;
import jakarta.persistence.spi.PersistenceUnitInfo;
import jakarta.persistence.spi.PersistenceUnitTransactionType;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;

final class JPACompPUnitInfo
implements PersistenceUnitInfo {
    private static final TraceComponent tc = Tr.register(JPACompPUnitInfo.class, (String)"JPA", (String)"com.ibm.ws.jpa.jpa");
    protected JPAPuId ivPuId;
    private final JPAPUnitInfo ivPUnitInfo;
    private final J2EEName ivJ2eeName;
    private DataSource ivJtaDataSource = null;
    private DataSource ivNonJtaDataSource = null;

    JPACompPUnitInfo(JPAPuId puId, JPAPUnitInfo puInfo, J2EEName j2eeName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("<init> : " + puId + ", " + j2eeName), (Object[])new Object[0]);
        }
        this.ivPuId = puId;
        this.ivPUnitInfo = puInfo;
        this.ivJ2eeName = j2eeName;
    }

    public void addTransformer(ClassTransformer transformerClass) {
        this.ivPUnitInfo.addTransformer(transformerClass);
    }

    public boolean excludeUnlistedClasses() {
        return this.ivPUnitInfo.excludeUnlistedClasses();
    }

    public ClassLoader getClassLoader() {
        return this.ivPUnitInfo.getClassLoader();
    }

    public List<URL> getJarFileUrls() {
        return this.ivPUnitInfo.getJarFileUrls();
    }

    public DataSource getJtaDataSource() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getJtaDataSource : " + this), (Object[])new Object[0]);
        }
        if (this.ivJtaDataSource == null) {
            this.ivJtaDataSource = this.ivPUnitInfo.lookupJtaDataSource();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getJtaDataSource : " + this.ivJtaDataSource));
        }
        return this.ivJtaDataSource;
    }

    public List<String> getManagedClassNames() {
        return this.ivPUnitInfo.getManagedClassNames();
    }

    public List<String> getMappingFileNames() {
        return this.ivPUnitInfo.getMappingFileNames();
    }

    public ClassLoader getNewTempClassLoader() {
        return this.ivPUnitInfo.getNewTempClassLoader();
    }

    public DataSource getNonJtaDataSource() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getNonJtaDataSource : " + this), (Object[])new Object[0]);
        }
        if (this.ivNonJtaDataSource == null) {
            this.ivNonJtaDataSource = this.ivPUnitInfo.lookupNonJtaDataSource();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getNonJtaDataSource : " + this.ivNonJtaDataSource));
        }
        return this.ivNonJtaDataSource;
    }

    public final String getPersistenceProviderClassName() {
        return this.ivPUnitInfo.getPersistenceProviderClassName();
    }

    public String getPersistenceUnitName() {
        return this.ivPUnitInfo.getPersistenceUnitName();
    }

    public final List<String> getQualifierAnnotationNames() {
        return this.ivPUnitInfo.getQualifierAnnotationNames();
    }

    public final String getScopeAnnotationName() {
        return this.ivPUnitInfo.getScopeAnnotationName();
    }

    public final URL getPersistenceUnitRootUrl() {
        return this.ivPUnitInfo.getPersistenceUnitRootUrl();
    }

    public final Properties getProperties() {
        return this.ivPUnitInfo.getProperties();
    }

    public final PersistenceUnitTransactionType getTransactionType() {
        return this.ivPUnitInfo.getTransactionType();
    }

    public String getPersistenceXMLSchemaVersion() {
        return this.ivPUnitInfo.getPersistenceXMLSchemaVersion();
    }

    public SharedCacheMode getSharedCacheMode() {
        return this.ivPUnitInfo.getSharedCacheMode();
    }

    public ValidationMode getValidationMode() {
        return this.ivPUnitInfo.getValidationMode();
    }

    public String toString() {
        String identity = Integer.toHexString(System.identityHashCode(this));
        return "JPACompPUnitInfo@" + identity + "[" + this.ivPuId + ", " + this.ivJ2eeName + "]";
    }
}

