/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.api.jms.JmsMsgConsumer;
import com.ibm.websphere.sib.api.jms.JmsMsgProducer;
import com.ibm.ws.sib.api.jms.impl.ConsumerProperties;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.JmsSessionImpl;
import com.ibm.ws.sib.api.jms.impl.JmsTopicConnectionImpl;
import com.ibm.ws.sib.api.jms.impl.JmsTopicPublisherImpl;
import com.ibm.ws.sib.api.jms.impl.JmsTopicSubscriberImpl;
import com.ibm.ws.sib.api.jmsra.JmsJcaSession;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import jakarta.jms.Destination;
import jakarta.jms.IllegalStateException;
import jakarta.jms.JMSException;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.Topic;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSession;
import jakarta.jms.TopicSubscriber;

public class JmsTopicSessionImpl
extends JmsSessionImpl
implements TopicSession {
    private static TraceComponent tc = SibTr.register(JmsTopicSessionImpl.class, (String)"SIBJms_External", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");

    protected JmsTopicSessionImpl(boolean trans, int ack, SICoreConnection coreConnection, JmsTopicConnectionImpl jmsTopicConnection, JmsJcaSession jcaSession) throws JMSException {
        super(trans, ack, coreConnection, jmsTopicConnection, jcaSession);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"JmsTopicSessionImpl");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"JmsTopicSessionImpl");
        }
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createPublisher", (Object)topic);
        }
        TopicPublisher jmsTopicPublisher = null;
        try {
            jmsTopicPublisher = (TopicPublisher)this.createProducer((Destination)topic);
        }
        catch (JMSException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"exception caught: ", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createPublisher", (Object)jmsTopicPublisher);
        }
        return jmsTopicPublisher;
    }

    @Override
    public Queue createQueue(String queueName) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createQueue", (Object)queueName);
        }
        throw (IllegalStateException)JmsErrorUtils.newThrowable(IllegalStateException.class, "INVALID_OP_FOR_CLASS_CWSIA0483", new Object[]{"createQueue", "TopicSession"}, tc);
    }

    @Override
    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createBrowser", (Object)queue);
        }
        throw (IllegalStateException)JmsErrorUtils.newThrowable(IllegalStateException.class, "INVALID_OP_FOR_CLASS_CWSIA0483", new Object[]{"createBrowser", "TopicSession"}, tc);
    }

    @Override
    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createBrowser", (Object)new Object[]{queue, messageSelector});
        }
        throw (IllegalStateException)JmsErrorUtils.newThrowable(IllegalStateException.class, "INVALID_OP_FOR_CLASS_CWSIA0483", new Object[]{"createBrowser", "TopicSession"}, tc);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createSubscriber", (Object)topic);
        }
        TopicSubscriber topicSubscriber = null;
        try {
            topicSubscriber = this.createSubscriber(topic, null, false);
        }
        catch (JMSException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"exception caught: ", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createSubscriber", (Object)topicSubscriber);
        }
        return topicSubscriber;
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createSubscriber", (Object)new Object[]{topic, messageSelector, noLocal});
        }
        TopicSubscriber jmsTopicSubscriber = null;
        try {
            jmsTopicSubscriber = (TopicSubscriber)this.createConsumer((Destination)topic, messageSelector, noLocal);
        }
        catch (JMSException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"exception caught: ", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createSubscriber", (Object)jmsTopicSubscriber);
        }
        return jmsTopicSubscriber;
    }

    @Override
    public TemporaryQueue createTemporaryQueue() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createTemporaryQueue");
        }
        throw (IllegalStateException)JmsErrorUtils.newThrowable(IllegalStateException.class, "INVALID_OP_FOR_CLASS_CWSIA0483", new Object[]{"createTemporaryQueue", "TopicSession"}, tc);
    }

    @Override
    JmsMsgConsumer instantiateConsumer(ConsumerProperties _props) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"instantiateConsumer", (Object)_props);
        }
        JmsTopicSubscriberImpl jmsTopicSubscriber = null;
        try {
            jmsTopicSubscriber = new JmsTopicSubscriberImpl(this.getCoreConnection(), this, _props);
        }
        catch (JMSException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"exception caught: ", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"instantiateConsumer", (Object)jmsTopicSubscriber);
        }
        return jmsTopicSubscriber;
    }

    @Override
    JmsMsgProducer instantiateProducer(Destination jsDest) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"instantiateProducer", (Object)jsDest);
        }
        JmsTopicPublisherImpl jmsTopicPublisher = null;
        try {
            jmsTopicPublisher = new JmsTopicPublisherImpl(jsDest, this.getCoreConnection(), this);
        }
        catch (JMSException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"exception caught: ", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"instantiateProducer", (Object)jmsTopicPublisher);
        }
        return jmsTopicPublisher;
    }
}

