/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.csiv2.server.config.css;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.csiv2.Authenticator;
import com.ibm.ws.security.csiv2.CommonCfg;
import com.ibm.ws.security.csiv2.config.css.CommonClientCfg;
import com.ibm.ws.security.csiv2.server.config.css.ClientLTPAMechConfig;
import com.ibm.ws.security.csiv2.server.config.css.ClientSASITTDistinguishedName;
import com.ibm.ws.security.csiv2.server.config.css.ClientSASITTX509CertChain;
import com.ibm.ws.transport.iiop.security.config.css.CSSASMechConfig;
import com.ibm.ws.transport.iiop.security.config.css.CSSGSSUPMechConfigDynamic;
import com.ibm.ws.transport.iiop.security.config.css.CSSSASITTAbsent;
import com.ibm.ws.transport.iiop.security.config.css.CSSSASITTAnonymous;
import com.ibm.ws.transport.iiop.security.config.css.CSSSASITTPrincipalNameDynamic;
import com.ibm.ws.transport.iiop.security.config.css.CSSSASIdentityToken;
import com.ibm.ws.transport.iiop.security.config.css.CSSSASMechConfig;
import com.ibm.ws.transport.iiop.security.config.css.CSSSSLTransportConfig;
import com.ibm.ws.transport.iiop.security.config.css.CSSTransportMechConfig;
import com.ibm.ws.transport.iiop.security.config.tss.OptionsKey;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ClientConfigHelper
extends CommonClientCfg {
    private static TraceComponent tc = Tr.register(ClientConfigHelper.class, (String)"CSIv2", (String)"com.ibm.ws.security.csiv2.server.internal.resources.CSIv2ServerContainerMessages");
    private static final String TYPE = "com.ibm.ws.security.csiv2.clientPolicyCSIV2";
    static final long serialVersionUID = -7816606294672743364L;

    public ClientConfigHelper(Authenticator authenticator, String domain, String defaultAlias) {
        super(authenticator, domain, defaultAlias, TYPE);
    }

    protected CSSTransportMechConfig extractSSLTransport(Map<String, Object> transportLayerProperties) throws SSLException {
        String sslRef = (String)transportLayerProperties.get("sslRef");
        CSSSSLTransportConfig transportLayerConfig = new CSSSSLTransportConfig();
        if (sslRef != null) {
            OptionsKey options = this.sslConfig.getAssociationOptions(sslRef);
            transportLayerConfig.setSupports(options.supports);
            transportLayerConfig.setRequires(options.requires);
            transportLayerConfig.setSslConfigName(sslRef);
        } else {
            transportLayerConfig.setOutboundSSLReference();
        }
        return transportLayerConfig;
    }

    public CSSASMechConfig handleASMech(String mech, Authenticator authenticator, String domain, boolean required, Map<String, Object> props) {
        ClientLTPAMechConfig config = null;
        if (mech.equalsIgnoreCase("LTPA")) {
            config = new ClientLTPAMechConfig(authenticator, domain, required);
        } else if (mech.equalsIgnoreCase("GSSUP")) {
            config = new CSSGSSUPMechConfigDynamic(domain, required);
        }
        return config;
    }

    public void logWarning(String messageKey, Object ... objs) {
        Tr.warning((TraceComponent)tc, (String)messageKey, (Object[])objs);
    }

    public Map<String, Object> getAttributeLayerProperties(CommonCfg.LayersData mechInfo) {
        return mechInfo.attributeLayer;
    }

    protected CSSSASMechConfig extractSASMech(Map<String, Object> attributeLayerProperties) {
        CSSSASMechConfig sasMechConfig = new CSSSASMechConfig();
        sasMechConfig.addIdentityToken((CSSSASIdentityToken)new CSSSASITTAbsent());
        boolean identityAssertionEnabled = (Boolean)attributeLayerProperties.get("identityAssertionEnabled");
        String[] identityAssertionTypes = (String[])attributeLayerProperties.get("identityAssertionTypes");
        String trustedIdentity = (String)attributeLayerProperties.get("trustedIdentity");
        SerializableProtectedString trustedPassword = (SerializableProtectedString)attributeLayerProperties.get("trustedPassword");
        ClientConfigHelper.printTrace((String)"IdentityAssertionEnabled", (Object)identityAssertionEnabled, (int)3);
        ClientConfigHelper.printTrace((String)"TrustedIdentity", (Object)trustedIdentity, (int)3);
        if (identityAssertionEnabled) {
            for (String assertionType : identityAssertionTypes) {
                if ("ITTAnonymous".equals(assertionType)) {
                    sasMechConfig.addIdentityToken((CSSSASIdentityToken)new CSSSASITTAnonymous());
                    continue;
                }
                if ("ITTPrincipalName".equals(assertionType)) {
                    sasMechConfig.addIdentityToken((CSSSASIdentityToken)new CSSSASITTPrincipalNameDynamic(null, this.domain));
                    continue;
                }
                if ("ITTX509CertChain".equals(assertionType)) {
                    sasMechConfig.addIdentityToken((CSSSASIdentityToken)new ClientSASITTX509CertChain(null, this.domain));
                    continue;
                }
                if (!"ITTDistinguishedName".equals(assertionType)) continue;
                sasMechConfig.addIdentityToken((CSSSASIdentityToken)new ClientSASITTDistinguishedName());
            }
            sasMechConfig.setTrustedIdentity(trustedIdentity);
            sasMechConfig.setTrustedPassword(trustedPassword);
        }
        return sasMechConfig;
    }
}

