/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.csi;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.apache.yoko.orb.csi.AuthenticationInfo;
import org.apache.yoko.orb.csi.SecurityContextDelegate;
import org.apache.yoko.osgi.ProviderLocator;
import org.apache.yoko.util.PrivilegedActions;

public abstract class SecurityContext {
    private static SecurityContextDelegate delegate;

    public static void setAuthenticatedSubject(Subject subject) {
        SecurityContext.getDelegate().setAuthenticatedSubject(subject);
    }

    private static SecurityContextDelegate getDelegate() {
        if (delegate == null) {
            delegate = SecurityContext.allocateDelegate();
        }
        return delegate;
    }

    private static SecurityContextDelegate allocateDelegate() {
        String className = (String)AccessController.doPrivileged(PrivilegedActions.getSysProp((String)"org.freeorb.csi.SecurityContextClass", (String)"org.freeorb.csi.DefaultSecurityContextDelegate"));
        try {
            Class c = ProviderLocator.loadClass((String)className, SecurityContext.class, (ClassLoader)((ClassLoader)AccessController.doPrivileged(PrivilegedActions.GET_CONTEXT_CLASS_LOADER)));
            return (SecurityContextDelegate)((Constructor)AccessController.doPrivileged(PrivilegedActions.getNoArgConstructor((Class)c))).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new InternalError("unable to attach to SecurityContext", e);
        }
    }

    public static Subject anonymousLogin() throws LoginException {
        return SecurityContext.getDelegate().anonymousLogin();
    }

    public static Subject login(String name, String realm, String password) throws LoginException {
        return SecurityContext.getDelegate().login(name, realm, password);
    }

    public static Subject delegate(String user, String domain) {
        return SecurityContext.getDelegate().delegate(user, domain);
    }

    public static AuthenticationInfo getAuthenticationInfo() {
        return SecurityContext.getDelegate().getAuthenticationInfo();
    }
}

