/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.impl;

import com.ibm.websphere.ras.DataFormatHelper;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.ffdc.IncidentStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class IntrospectionLevelMember {
    private static final String OBJECT_TYPE = "Object type";
    private static final String EQUALS = " = ";
    private static final int EQUALS_LENGTH = " = ".length();
    private static final int EXTRA_SPACE = 5;
    private static final int MAX_ARRAY_LENGTH = 1024;
    private final Object _member;
    private final int _level;
    private final String _name;
    private final String _description;
    private List<IntrospectionLevelMember> _children;
    private final Set<IntrospectionLevelMember> _allKnownMembersInThisTree;

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof IntrospectionLevelMember) {
            IntrospectionLevelMember other = (IntrospectionLevelMember)obj;
            return this._member == other._member;
        }
        return false;
    }

    public int hashCode() {
        if (this._member == null) {
            return 0;
        }
        return System.identityHashCode(this._member);
    }

    public IntrospectionLevelMember(Object member) {
        this(0, OBJECT_TYPE, member.getClass().getName(), member, new HashSet<IntrospectionLevelMember>());
        this._allKnownMembersInThisTree.add(this);
    }

    private IntrospectionLevelMember(int level, String name, String description, Object member, Set<IntrospectionLevelMember> allKnownMembers) {
        this._level = level;
        this._name = name;
        this._description = description;
        this._member = member;
        this._allKnownMembersInThisTree = allKnownMembers;
    }

    public int sizeOfIntrospection() {
        return this._name.length() + this._description.length() + 5 + 2 * this._level;
    }

    public List<IntrospectionLevelMember> getChildren() {
        if (this._children == null) {
            this._children = new ArrayList<IntrospectionLevelMember>();
            if (this._member != null) {
                if (this._member instanceof String) {
                    this.addNewChild("String value", this._member);
                } else if (this._member instanceof FFDCSelfIntrospectable) {
                    this.introspectSelfIntrospectable();
                } else {
                    this.introspectViaReflection();
                }
            }
        }
        return this._children;
    }

    private void introspectViaReflection() {
        block5: {
            block3: {
                Class<?> componentType;
                int length;
                block4: {
                    Class<?> memberClass = this._member.getClass();
                    if (!memberClass.isArray()) break block3;
                    length = Array.getLength(this._member);
                    componentType = memberClass.getComponentType();
                    if (!componentType.isPrimitive()) break block4;
                    this.addNewChild(componentType + "[0.." + (length - 1) + "]", this._member);
                    break block5;
                }
                String simpleName = componentType.getSimpleName();
                for (int i = 0; i < length && i < 1024; ++i) {
                    Object value = Array.get(this._member, i);
                    this.addNewChild(simpleName + "[" + i + "]", value);
                }
                if (length <= 1024) break block5;
                this.addNewChild(simpleName + "[...]", "/* array length = " + length + " */");
                break block5;
            }
            for (Class<?> currentClass = this._member.getClass(); currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
                Field[] fields = this.getFields(currentClass);
                for (int i = 0; i < fields.length && i < 1024; ++i) {
                    Field field = fields[i];
                    Object value = this.getFieldValue(field);
                    this.addNewChild(field.getName(), value);
                }
                if (fields.length <= 1024) continue;
                this.addNewChild("field...", "/* total # of fields = " + fields.length + " */");
            }
        }
    }

    private void introspectSelfIntrospectable() {
        try {
            String[] strings = ((FFDCSelfIntrospectable)this._member).introspectSelf();
            if (strings != null) {
                for (int i = 0; i < strings.length; ++i) {
                    if (strings[i] != null) {
                        int equalsLoc = strings[i].indexOf(EQUALS);
                        if (equalsLoc > 0 && equalsLoc < strings[i].length() - EQUALS_LENGTH) {
                            this.addNewChild(strings[i].substring(0, equalsLoc), strings[i].substring(equalsLoc + EQUALS_LENGTH));
                            continue;
                        }
                        if (equalsLoc > 0) {
                            this.addNewChild(strings[i].substring(0, equalsLoc), "");
                            continue;
                        }
                        this.addNewChild("strings[" + i + "]", strings[i]);
                        continue;
                    }
                    this.addNewChild("strings[" + i + "]", null);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private void addNewChild(String name, Object value) {
        IntrospectionLevelMember prospectiveMember = new IntrospectionLevelMember(this._level + 1, name, this.makeDescription(value), this.makeMember(value), this._allKnownMembersInThisTree);
        if (this.makeMember(value) != null) {
            if (this._allKnownMembersInThisTree.contains(prospectiveMember)) {
                prospectiveMember = new IntrospectionLevelMember(this._level + 1, name, this.makeDescription(value), null, this._allKnownMembersInThisTree);
            } else {
                this._allKnownMembersInThisTree.add(prospectiveMember);
            }
        }
        this._children.add(prospectiveMember);
    }

    private Object getFieldValue(final Field field) {
        Object field_value = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    boolean sensitive;
                    Object value = field.get(IntrospectionLevelMember.this._member);
                    boolean bl = sensitive = IntrospectionLevelMember.this._member.getClass().isAnnotationPresent(Sensitive.class) || field.isAnnotationPresent(Sensitive.class);
                    if (value != null && sensitive) {
                        value = DataFormatHelper.sensitiveToString(value);
                    }
                    return value;
                }
                catch (IllegalAccessException e) {
                    return "/* Could not access " + field.getName() + " */";
                }
            }
        });
        return field_value;
    }

    private Field[] getFields(final Class<?> currentClass) {
        Field[] objectFields = AccessController.doPrivileged(new PrivilegedAction<Field[]>(){

            @Override
            public Field[] run() {
                try {
                    AccessibleObject[] tempObjectFields = currentClass.getDeclaredFields();
                    if (tempObjectFields.length != 0) {
                        try {
                            Class<?> moduleClass = Class.forName("java.lang.Module");
                            Method getModule = Class.class.getMethod("getModule", new Class[0]);
                            Object module = getModule.invoke((Object)currentClass, new Object[0]);
                            Class[] paramString = new Class[]{String.class};
                            Method isOpen = moduleClass.getMethod("isOpen", paramString);
                            Package currentPackage = currentClass.getPackage();
                            String packageName = currentPackage.getName();
                            boolean isOpenCheck = (Boolean)isOpen.invoke(module, packageName);
                            if (isOpenCheck) {
                                AccessibleObject.setAccessible(tempObjectFields, true);
                            }
                        }
                        catch (Exception e) {
                            AccessibleObject.setAccessible(tempObjectFields, true);
                        }
                    }
                    return tempObjectFields;
                }
                catch (Throwable t) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    t.printStackTrace(pw);
                    IntrospectionLevelMember.this.addNewChild("Failed to resolve fields for " + currentClass.getName(), sw.toString());
                    return new Field[0];
                }
            }
        });
        return objectFields;
    }

    private String makeDescription(Object value) {
        Class<?> objClass;
        String answer = value == null ? "null" : (value instanceof String ? "\"" + value + "\"" : ((objClass = value.getClass()) == Boolean.class || objClass == Character.class || objClass == Byte.class || objClass == Short.class || objClass == Integer.class || objClass == Long.class || objClass == Float.class || objClass == Double.class ? value.toString() : (objClass.isArray() ? (objClass.getComponentType().isPrimitive() ? this.convertSimpleArrayToString(value) : objClass.getComponentType() + "[" + Array.getLength(value) + "]") : value.getClass().toString() + "@" + Integer.toHexString(System.identityHashCode(value)))));
        return answer;
    }

    private String convertSimpleArrayToString(Object value) {
        int length = Array.getLength(value);
        StringBuffer temp = new StringBuffer("{");
        for (int i = 0; i < length && i < 1024; ++i) {
            Object element = Array.get(value, i);
            if (i > 0 && !(element instanceof Character)) {
                temp.append(",");
            }
            temp.append(element);
        }
        if (length > 1024) {
            if (!(Array.get(value, 0) instanceof Character)) {
                temp.append(",");
            }
            temp.append("...");
        }
        temp.append("} /* array length = ");
        temp.append(Integer.toString(Array.getLength(value)));
        temp.append(" */");
        String answer = temp.toString();
        return answer;
    }

    private Object makeMember(Object value) {
        Object answer = null;
        if (value != null) {
            Class<?> objClass = value.getClass();
            if (objClass.isArray()) {
                if (Array.getLength(value) > 0 && !objClass.getComponentType().isPrimitive()) {
                    answer = value;
                }
            } else if (objClass != String.class && objClass != Boolean.class && objClass != Character.class && objClass != Byte.class && objClass != Short.class && objClass != Integer.class && objClass != Long.class && objClass != Float.class && objClass != Double.class && objClass != String.class) {
                answer = value;
            }
        }
        return answer;
    }

    public void print(IncidentStream is, int maxDepth) {
        StringBuffer fullName = new StringBuffer();
        for (int i = 0; i < this._level; ++i) {
            fullName.append("  ");
        }
        fullName.append(this._name);
        is.writeLine(fullName.toString(), this._description);
        if (this._level < maxDepth) {
            List<IntrospectionLevelMember> children = this.getChildren();
            for (IntrospectionLevelMember ilm : children) {
                ilm.print(is, maxDepth);
            }
        }
    }
}

