/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.sib.utils.PasswordSuppressingHashMap;
import com.ibm.ws.sib.utils.PasswordUtils;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JsMsgMap
extends AbstractMap<String, Object>
implements FFDCSelfIntrospectable {
    private static TraceComponent tc = SibTr.register(JsMsgMap.class, (String)"SIBMfp", (String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private Collection keyList;
    private Collection valueList;
    private Map<String, Object> backingMap;
    private boolean changed = false;
    private boolean fluffed;

    JsMsgMap(List<String> keyList, List<Object> valueList) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{keyList, this.traceableValueList(keyList, valueList)});
        }
        if (keyList != null) {
            this.keyList = keyList;
            this.valueList = valueList;
            this.backingMap = new ListMap();
            this.fluffed = false;
        } else {
            this.backingMap = new PasswordSuppressingHashMap();
            this.keyList = new KeyList();
            this.valueList = new ValueList();
            this.fluffed = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public boolean isChanged() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isChanged");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isChanged", (Object)this.changed);
        }
        return this.changed;
    }

    public void setUnChanged() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setUnChanged");
        }
        this.changed = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setUnChanged");
        }
    }

    public void setChanged() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setChanged");
        }
        this.changed = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setChanged");
        }
    }

    public Collection getKeyList() {
        return this.keyList;
    }

    public Collection getValueList() {
        return this.valueList;
    }

    private Map<String, Object> copyMap() {
        if (!this.fluffed) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"copyMap making copy => fluffed");
            }
            this.backingMap = new HashMap<String, Object>(this.backingMap);
            this.keyList = new KeyList();
            this.valueList = new ValueList();
            this.fluffed = true;
        }
        return this.backingMap;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.backingMap.entrySet();
    }

    @Override
    public Object put(String key, Object value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"put", (Object)new Object[]{key, PasswordUtils.replaceValueIfKeyIsPassword((String)key, (Object)value)});
        }
        if (!this.changed && value != null) {
            Object old = this.get(key);
            if (value.equals(old)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"put", (Object)"unchanged");
                }
                return old;
            }
            this.changed = true;
            Object result = this.copyMap().put(key, value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"put", (Object)PasswordUtils.replaceValueIfKeyIsPassword((String)key, (Object)result));
            }
            return result;
        }
        this.changed = true;
        Object result = this.copyMap().put(key, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"put", (Object)PasswordUtils.replaceValueIfKeyIsPassword((String)key, (Object)result));
        }
        return result;
    }

    public Object remove(String key) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"remove", (Object)key);
        }
        this.changed = true;
        Object result = this.copyMap().remove(key);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"remove", (Object)PasswordUtils.replaceValueIfKeyIsPassword((String)key, (Object)result));
        }
        return result;
    }

    @Override
    public void clear() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"clear");
        }
        this.changed = true;
        this.copyMap().clear();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"clear");
        }
    }

    public String[] introspectSelf() {
        return new String[]{"keyList = " + this.keyList, "valueList = " + this.traceableValueList(this.keyList, this.valueList), "backingMap = " + this.backingMap, "changed = " + this.changed, "fluffed = " + this.fluffed};
    }

    private List<Object> traceableValueList(Collection keyList, Collection valueList) {
        ArrayList<String> traceableValueList = null;
        if (keyList != null) {
            traceableValueList = new ArrayList<String>(valueList.size());
            Iterator kit = keyList.iterator();
            Iterator vit = valueList.iterator();
            while (kit.hasNext()) {
                Object k = kit.next();
                Object v = vit.next();
                String ks = k instanceof String ? (String)k : "";
                traceableValueList.add(PasswordUtils.replaceValueIfKeyIsPassword((String)ks, v));
            }
        }
        return traceableValueList;
    }

    private class ListMap
    extends AbstractMap<String, Object> {
        Set<Map.Entry<String, Object>> entries = new ListSet();

        private ListMap() {
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return this.entries;
        }

        private class ListSet
        extends AbstractSet<Map.Entry<String, Object>> {
            private ListSet() {
            }

            @Override
            public int size() {
                return JsMsgMap.this.keyList.size();
            }

            @Override
            public Iterator<Map.Entry<String, Object>> iterator() {
                return new ListIterator();
            }

            private class ListIterator
            implements Iterator<Map.Entry<String, Object>> {
                int index = 0;

                private ListIterator() {
                }

                @Override
                public boolean hasNext() {
                    return this.index != JsMsgMap.this.keyList.size();
                }

                @Override
                public Map.Entry<String, Object> next() {
                    return new ListEntry(this.index++);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            }

            private class ListEntry
            implements Map.Entry<String, Object> {
                int index;

                public ListEntry(int index) {
                    this.index = index;
                }

                @Override
                public String getKey() {
                    return (String)((List)JsMsgMap.this.keyList).get(this.index);
                }

                @Override
                public Object getValue() {
                    return ((List)JsMsgMap.this.valueList).get(this.index);
                }

                @Override
                public Object setValue(Object value) {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }

    private class KeyList
    extends MapList<String> {
        private KeyList() {
        }

        @Override
        public Iterator<String> iterator() {
            return new MapList.KeyIterator();
        }
    }

    private class ValueList
    extends MapList<Object>
    implements FFDCSelfIntrospectable {
        private ValueList() {
        }

        @Override
        public Iterator<Object> iterator() {
            return new MapList.ValueIterator();
        }

        @Override
        public String toString() {
            return "[/* ValueList of size " + this.size() + "*/]";
        }

        public String[] introspectSelf() {
            return new String[]{this.toString()};
        }
    }

    private class BackingMap
    extends HashMap<String, Object>
    implements FFDCSelfIntrospectable {
        private BackingMap() {
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            boolean first = true;
            for (Map.Entry e : this.entrySet()) {
                if (!first) {
                    sb.append(", ");
                    first = false;
                }
                sb.append((String)e.getKey() + "=" + PasswordUtils.replaceValueIfKeyIsPassword((String)((String)e.getKey()), e.getValue()));
            }
            sb.append("}");
            return sb.toString();
        }

        public String[] introspectSelf() {
            return new String[]{this.toString()};
        }
    }

    private abstract class MapList<T>
    extends AbstractCollection<T> {
        Set<Map.Entry<String, Object>> entries;

        private MapList() {
            this.entries = JsMsgMap.this.backingMap.entrySet();
        }

        @Override
        public int size() {
            return this.entries.size();
        }

        class ValueIterator
        extends MapIterator<Object>
        implements FFDCSelfIntrospectable {
            ValueIterator() {
            }

            @Override
            public Object next() {
                return ((Map.Entry)this.iter.next()).getValue();
            }

            public String toString() {
                return "[/* valueIterator of size " + MapList.this.size() + "*/]";
            }

            public String[] introspectSelf() {
                return new String[]{this.toString()};
            }
        }

        class KeyIterator
        extends MapIterator<String> {
            KeyIterator() {
            }

            @Override
            public String next() {
                return (String)((Map.Entry)this.iter.next()).getKey();
            }
        }

        abstract class MapIterator<U>
        implements Iterator<U> {
            Iterator<Map.Entry<String, Object>> iter;

            MapIterator() {
                this.iter = MapList.this.entries.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

