/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.utils.collections.linkedlist;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.utils.collections.linkedlist.LinkedList;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;

public class Link {
    private static final String HEAD = "Head";
    private static final String LINKED = "Linked";
    private static final String LOGICALLY_UNLINKED = "LogicallyUnlinked";
    private static final String PHYSICALLY_UNLINKED = "PhysicallyUnlinked";
    private static final String TAIL = "Tail";
    private static TraceComponent tc = SibTr.register(Link.class, "SIBUtils", "com.ibm.ws.sib.utils.CWSIUMessages");
    private int _cursorCount = 0;
    private Link _nextLink;
    private LinkedList _parent;
    private Link _previousLink;
    private String _state = "PhysicallyUnlinked";

    final Link _getNextLink() {
        return this._nextLink;
    }

    final Link _getPreviousLink() {
        return this._previousLink;
    }

    final void _link(Link prev, Link next, LinkedList list) {
        if (PHYSICALLY_UNLINKED != this._state) {
            throw new RuntimeException(this._state);
        }
        this._nextLink = next;
        this._previousLink = prev;
        this._parent = list;
        this._state = LINKED;
    }

    final String _positionString() {
        Link link;
        StringBuffer buf = new StringBuffer();
        this._shortDebugString(buf);
        buf.append(" Forward:");
        int limit = 10;
        for (link = this._getNextLink(); null != link && 0 < limit--; link = link._getNextLink()) {
            buf.append(" ");
            link._shortDebugString(buf);
        }
        buf.append("; Backward:");
        limit = 10;
        for (link = this._getPreviousLink(); null != link && 0 < limit--; link = link._getPreviousLink()) {
            buf.append(" ");
            link._shortDebugString(buf);
        }
        return buf.toString();
    }

    final void _setAsHead(LinkedList parent, Link tail) {
        this._nextLink = tail;
        this._parent = parent;
        this._state = HEAD;
    }

    final void _setAsTail(LinkedList parent, Link head) {
        this._previousLink = head;
        this._parent = parent;
        this._state = TAIL;
    }

    final void _setNextLink(Link link) {
        this._nextLink = link;
    }

    final void _setPreviousLink(Link link) {
        this._previousLink = link;
    }

    final void _shortDebugString(StringBuffer buf) {
        long s = this.getSequence();
        if (-1L != s) {
            buf.append(s);
        }
        buf.append("(");
        buf.append(this._state);
        buf.append(")");
    }

    private final void _tryUnlink() {
        if (0 >= this._cursorCount && this._state == LOGICALLY_UNLINKED) {
            this._previousLink._nextLink = this._nextLink;
            this._nextLink._previousLink = this._previousLink;
            this._previousLink = null;
            this._nextLink = null;
            this._state = PHYSICALLY_UNLINKED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void cursorRemoved() {
        LinkedList parent;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "cursorRemoved");
        }
        if (null != (parent = this._parent)) {
            LinkedList linkedList = parent;
            synchronized (linkedList) {
                if (LINKED == this._state || LOGICALLY_UNLINKED == this._state) {
                    --this._cursorCount;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "cursorCount decrement to " + this._cursorCount);
                    }
                    this._tryUnlink();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "cursorRemoved");
        }
    }

    final void decrementCursorCount() {
        --this._cursorCount;
        this._tryUnlink();
    }

    public final int getCursorCount() {
        return this._cursorCount;
    }

    public final Link getNextLink() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getNextLink", this._positionString());
        }
        Link nextLink = null;
        LinkedList parent = this._parent;
        if (null != parent) {
            nextLink = this._parent.getNextLink(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getNextLink", nextLink);
        }
        return nextLink;
    }

    public final Link getNextPhysicalLink() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getNextPhysicalLink", this._positionString());
        }
        Link nextLink = this._nextLink;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getNextPhysicalLink", nextLink);
        }
        return nextLink;
    }

    public final LinkedList getOwningList() {
        return this._parent;
    }

    public long getSequence() {
        return -1L;
    }

    final void incrementCursorCount() {
        ++this._cursorCount;
    }

    public final boolean isLinked() {
        return LINKED == this._state;
    }

    public final boolean isLogicallyUnlinked() {
        return LOGICALLY_UNLINKED == this._state;
    }

    public final boolean isPhysicallyUnlinked() {
        return PHYSICALLY_UNLINKED == this._state;
    }

    public final boolean isTail() {
        return TAIL == this._state;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        Link link = this._previousLink;
        if (null != link) {
            link._shortDebugString(buf);
            buf.append("?<-");
        }
        this._shortDebugString(buf);
        link = this._nextLink;
        if (null != link) {
            buf.append("?->");
            link._shortDebugString(buf);
        }
        buf.append("]");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean unlink() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "unlink", this._positionString());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug(this, tc, "cursor count = " + this._cursorCount);
        }
        boolean unlinked = false;
        LinkedList parent = this._parent;
        if (null != parent) {
            LinkedList linkedList = parent;
            synchronized (linkedList) {
                if (LINKED == this._state) {
                    this._state = LOGICALLY_UNLINKED;
                    this._tryUnlink();
                    unlinked = true;
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "unlink while " + this._state);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "unlink", new Object[]{unlinked, this._positionString()});
        }
        return unlinked;
    }

    protected void xmlWriteAttributesOn(FormattedWriter writer) throws IOException {
        writer.write(" linkState=\"");
        writer.write(this._state);
        writer.write("\" cursorCount=\"");
        writer.write(Integer.toString(this._cursorCount));
        writer.write("\" sihc=\"");
        writer.write(Integer.toHexString(System.identityHashCode(this)));
        writer.write("\" ");
    }

    public void xmlWriteOn(FormattedWriter writer) throws IOException {
        String name = "link";
        writer.write("<");
        writer.write(name);
        this.xmlWriteAttributesOn(writer);
        writer.write(" />");
    }
}

