/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.netty.pipeline.http2;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.h2internal.Constants;
import com.ibm.ws.http.channel.internal.HttpChannelConfig;
import com.ibm.ws.http.netty.NettyHttpConstants;
import com.ibm.ws.http.netty.pipeline.http2.LibertyInboundHttp2ToHttpAdapter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.CleartextHttp2ServerUpgradeHandler;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2LocalFlowController;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandler;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapterBuilder;
import io.netty.util.AsciiString;
import io.netty.util.ReferenceCountUtil;
import io.openliberty.http.netty.quiesce.QuiesceStrategy;
import io.openliberty.http.netty.timeout.TimeoutHandler;
import io.openliberty.netty.internal.impl.QuiesceHandler;
import java.util.Collection;
import java.util.Collections;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LibertyUpgradeCodec
implements HttpServerUpgradeHandler.UpgradeCodecFactory {
    private static final TraceComponent tc = Tr.register(LibertyUpgradeCodec.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private final HttpChannelConfig httpConfig;
    private final Channel channel;
    static final long serialVersionUID = 7790931519133371204L;

    public static CleartextHttp2ServerUpgradeHandler createCleartextUpgradeHandler(HttpChannelConfig httpConfig, Channel channel) {
        HttpServerCodec sourceCodec = new HttpServerCodec(8192, httpConfig.getIncomingBodyBufferSize(), httpConfig.getLimitOfFieldSize(), httpConfig.getLimitOnNumberOfHeaders());
        LibertyUpgradeCodec codec = new LibertyUpgradeCodec(httpConfig, channel);
        int maxContentlength = httpConfig.getMessageSizeLimit() >= Integer.MAX_VALUE || httpConfig.getMessageSizeLimit() < 0L ? Integer.MAX_VALUE : (int)httpConfig.getMessageSizeLimit();
        HttpServerUpgradeHandler upgradeHandler = new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)sourceCodec, (HttpServerUpgradeHandler.UpgradeCodecFactory)codec, maxContentlength);
        return new CleartextHttp2ServerUpgradeHandler(sourceCodec, upgradeHandler, (ChannelHandler)codec.buildHttp2ConnectionHandler(httpConfig, channel));
    }

    public LibertyUpgradeCodec(HttpChannelConfig httpConfig, Channel channel) {
        this.httpConfig = httpConfig;
        this.channel = channel;
    }

    public HttpServerUpgradeHandler.UpgradeCodec newUpgradeCodec(CharSequence protocol) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("New upgrade codec called for protocol " + protocol), (Object[])new Object[0]);
        }
        if (AsciiString.contentEquals((CharSequence)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, (CharSequence)protocol)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Valid h2c protocol, setting up http2 clear text " + protocol), (Object[])new Object[0]);
            }
            final HttpToHttp2ConnectionHandler handler = this.buildHttp2ConnectionHandler(this.httpConfig, this.channel);
            return new Http2ServerUpgradeCodec((Http2ConnectionHandler)handler){
                static final long serialVersionUID = -4386777030779211410L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - void declaration
                 */
                public void upgradeTo(ChannelHandlerContext ctx, FullHttpRequest request) {
                    ctx.channel().attr(NettyHttpConstants.PROTOCOL).set((Object)"HTTP2");
                    ((TimeoutHandler)ctx.pipeline().get(TimeoutHandler.class)).markProtocol(ctx.pipeline(), NettyHttpConstants.ProtocolName.HTTP2);
                    super.upgradeTo(ctx, request);
                    request.headers().set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), (Object)1);
                    if (Constants.SPEC_INITIAL_WINDOW_SIZE != LibertyUpgradeCodec.this.httpConfig.getH2ConnectionWindowSize()) {
                        int updateSize = LibertyUpgradeCodec.this.httpConfig.getH2ConnectionWindowSize() - Constants.SPEC_INITIAL_WINDOW_SIZE;
                        try {
                            ((DefaultHttp2LocalFlowController)handler.decoder().flowController()).incrementWindowSize(handler.decoder().connection().connectionStream(), updateSize);
                        }
                        catch (Http2Exception http2Exception) {
                            void e;
                            FFDCFilter.processException((Throwable)http2Exception, (String)"com.ibm.ws.http.netty.pipeline.http2.LibertyUpgradeCodec$1", (String)"107", (Object)((Object)this), (Object[])new Object[]{ctx, request});
                            ctx.fireExceptionCaught((Throwable)e);
                        }
                    }
                    ctx.flush();
                    ctx.fireChannelRead(ReferenceCountUtil.retain((Object)request));
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.netty.pipeline.http2.LibertyUpgradeCodec$1", 1.class, null, null);
                }
            };
        }
        if (AsciiString.contentEqualsIgnoreCase((CharSequence)"websocket", (CharSequence)protocol)) {
            return new HttpServerUpgradeHandler.UpgradeCodec(){
                static final long serialVersionUID = -3366734691940993480L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public void upgradeTo(ChannelHandlerContext ctx, FullHttpRequest request) {
                    ctx.fireChannelRead(ReferenceCountUtil.retain((Object)request));
                    QuiesceHandler quiesceHandler = (QuiesceHandler)ctx.pipeline().get(QuiesceHandler.class);
                    if (quiesceHandler != null) {
                        quiesceHandler.setQuiesceTask(QuiesceStrategy.WEBSOCKET_CLOSE.getTask());
                    }
                    ctx.channel().attr(NettyHttpConstants.PROTOCOL).set((Object)NettyHttpConstants.ProtocolName.WEBSOCKET.name());
                }

                public boolean prepareUpgradeResponse(ChannelHandlerContext ctx, FullHttpRequest upgradeRequest, HttpHeaders upgradeHeaders) {
                    return false;
                }

                public Collection<CharSequence> requiredUpgradeHeaders() {
                    return Collections.emptyList();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.netty.pipeline.http2.LibertyUpgradeCodec$2", 2.class, null, null);
                }
            };
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Returning null since no valid protocol was found: " + protocol), (Object[])new Object[0]);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    HttpToHttp2ConnectionHandler buildHttp2ConnectionHandler(HttpChannelConfig httpConfig, Channel channel) {
        DefaultHttp2Connection connection = new DefaultHttp2Connection(true);
        int maxContentlength = httpConfig.getMessageSizeLimit() >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)httpConfig.getMessageSizeLimit();
        InboundHttp2ToHttpAdapterBuilder builder = new InboundHttp2ToHttpAdapterBuilder((Http2Connection)connection).propagateSettings(false).validateHttpHeaders(false);
        if (maxContentlength > 0) {
            builder.maxContentLength(maxContentlength);
        }
        Http2Settings initialSettings = new Http2Settings().maxConcurrentStreams((long)httpConfig.getH2MaxConcurrentStreams()).maxFrameSize(httpConfig.getH2MaxFrameSize());
        if (httpConfig.getH2SettingsInitialWindowSize() != Constants.SPEC_INITIAL_WINDOW_SIZE) {
            initialSettings.initialWindowSize(httpConfig.getH2SettingsInitialWindowSize());
        }
        int frameWindowSize = httpConfig.getH2ResetFramesWindow() / 1000;
        builder = new InboundHttp2ToHttpAdapterBuilder((Http2Connection)connection).propagateSettings(false).maxContentLength(Integer.MAX_VALUE).validateHttpHeaders(false);
        HttpToHttp2ConnectionHandler handler = ((HttpToHttp2ConnectionHandlerBuilder)((HttpToHttp2ConnectionHandlerBuilder)((HttpToHttp2ConnectionHandlerBuilder)new HttpToHttp2ConnectionHandlerBuilder().frameListener((Http2FrameListener)new LibertyInboundHttp2ToHttpAdapter((Http2Connection)connection, Integer.MAX_VALUE, false, false, channel)).connection((Http2Connection)connection).initialSettings(initialSettings).encoderIgnoreMaxHeaderListSize(true).decoderEnforceMaxRstFramesPerWindow(httpConfig.getH2MaxResetFrames(), frameWindowSize).encoderEnforceMaxRstFramesPerWindow(httpConfig.getH2MaxResetFrames(), frameWindowSize).limitFieldSize(httpConfig.getLimitOfFieldSize())).limitNumHeaders(httpConfig.getLimitOnNumberOfHeaders())).maxHeaderBlockSize(httpConfig.getH2MaxHeaderBlockSize())).build();
        if (!httpConfig.getH2LimitWindowUpdateFrames()) {
            ((DefaultHttp2LocalFlowController)handler.decoder().flowController()).windowUpdateRatio(0.99999f);
            try {
                ((DefaultHttp2LocalFlowController)handler.decoder().flowController()).windowUpdateRatio(connection.connectionStream(), 0.9999f);
            }
            catch (Http2Exception http2Exception) {
                void e;
                FFDCFilter.processException((Throwable)http2Exception, (String)"com.ibm.ws.http.netty.pipeline.http2.LibertyUpgradeCodec", (String)"173", (Object)this, (Object[])new Object[]{httpConfig, channel});
                e.printStackTrace();
            }
        }
        return handler;
    }
}

