/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logstash.collector.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.collector.Client;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.lumberjack.LumberjackClient;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.ssl.SSLSupport;
import java.io.IOException;
import java.util.List;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LogstashClient
implements Client {
    private static final TraceComponent tc = Tr.register(LogstashClient.class, (String)"logstashCollector", (String)"com.ibm.ws.logstash.collector.internal.resources.LoggingMessages");
    private final LumberjackClient lumberjackClient;
    private volatile boolean connectionRetry;
    private volatile boolean connectionInitialized;
    private final int CONNECTION_RETRY_WAIT_TIME = 5000;
    static final long serialVersionUID = 5854421688811714658L;

    public LogstashClient(String sslConfig, SSLSupport sslSupport) throws SSLException {
        this.lumberjackClient = new LumberjackClient(sslConfig, sslSupport);
        this.connectionRetry = false;
        this.connectionInitialized = false;
    }

    @FFDCIgnore(value={IOException.class, InterruptedException.class})
    public void connect(String hostName, int port) throws IOException {
        try {
            boolean refreshingConnection = false;
            if (this.lumberjackClient.isSocketAvailable() && this.lumberjackClient.isConnectionStale()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Connection has timed out - will reconnect before trying to use it", (Object[])new Object[0]);
                }
                this.lumberjackClient.close();
                refreshingConnection = true;
                this.connectionInitialized = false;
            }
            if (this.connectionRetry) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.lumberjackClient.connect(hostName, port);
            if (!this.connectionInitialized) {
                if (!refreshingConnection) {
                    Tr.info((TraceComponent)tc, (String)"LOGSTASH_CONNECTION_ESTABLISHED", (Object[])new Object[]{hostName, String.valueOf(port)});
                }
                this.connectionInitialized = true;
            }
            this.connectionRetry = false;
        }
        catch (IOException e) {
            if (!this.connectionRetry) {
                this.connectionRetry = true;
                Tr.warning((TraceComponent)tc, (String)"LOGSTASH_CONNECTION_FAILED", (Object[])new Object[]{hostName, String.valueOf(port)});
            }
            throw e;
        }
    }

    public void close() throws IOException {
        try {
            this.lumberjackClient.close();
        }
        finally {
            if (this.connectionInitialized && !this.connectionRetry) {
                Tr.info((TraceComponent)tc, (String)"LOGSTASH_CONNECTION_CLOSED", (Object[])new Object[0]);
            }
            this.connectionInitialized = false;
        }
    }

    @FFDCIgnore(value={IOException.class})
    public void sendData(List<Object> dataObjects) throws IOException {
        try {
            int numObjects = dataObjects.size();
            long frameStartTime = System.nanoTime();
            this.lumberjackClient.writeWindowFrame(numObjects);
            byte[] dataFrames = this.lumberjackClient.createDataFrames(dataObjects);
            byte[] compressedFrame = this.lumberjackClient.createCompressedFrame(dataFrames);
            this.lumberjackClient.writeFrame(compressedFrame);
            LogstashClient.traceTime(tc, frameStartTime, "FramingSending " + numObjects + " events ");
            long ackStartTime = System.nanoTime();
            this.lumberjackClient.readAckFrame();
            LogstashClient.traceTime(tc, ackStartTime, "readAck " + numObjects + " events ");
        }
        catch (IOException e) {
            this.connectionRetry = true;
            Tr.warning((TraceComponent)tc, (String)"LOGSTASH_CONNECTION_NOT_AVAILABLE", (Object[])new Object[0]);
            throw e;
        }
    }

    private static void traceTime(TraceComponent tc, long startTime, String label) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            long endTime = System.nanoTime();
            String s = String.format(label + ": %10.3f ms", Float.valueOf((float)(endTime - startTime) / 1000000.0f));
            Tr.event((TraceComponent)tc, (String)s, (Object[])new Object[0]);
        }
    }
}

