/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.common.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.common.crypto.CryptoUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.utils.JavaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public final class KeyUtils {
    private static final Logger LOG;
    private static final int MAX_SYMMETRIC_KEY_SIZE = 1024;
    private static final Map<String, Integer> DEFAULT_DERIVED_KEY_LENGTHS;
    public static final String RSA_ECB_OAEPWITH_SHA1_AND_MGF1_PADDING = "RSA/ECB/OAEPWithSHA1AndMGF1Padding";
    private static MessageDigest digest;
    static final long serialVersionUID = -7839039305681826502L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private KeyUtils() {
    }

    public static int getKeyLength(String algorithm) throws WSSecurityException {
        if (algorithm == null) {
            return 0;
        }
        int size = JCEMapper.getKeyLengthFromURI((String)algorithm);
        if (size == 0 && DEFAULT_DERIVED_KEY_LENGTHS.containsKey(algorithm)) {
            size = DEFAULT_DERIVED_KEY_LENGTHS.get(algorithm);
        }
        return size / 8;
    }

    /*
     * WARNING - void declaration
     */
    public static SecretKey prepareSecretKey(String algorithm, byte[] rawKey) {
        int size = 0;
        try {
            size = JCEMapper.getKeyLengthFromURI((String)algorithm) / 8;
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"org.apache.wss4j.common.util.KeyUtils", (String)"97", null, (Object[])new Object[]{algorithm, rawKey});
            LOG.debug(e.getMessage());
        }
        String keyAlgorithm = JCEMapper.getJCEKeyAlgorithmFromURI((String)algorithm);
        SecretKeySpec keySpec = size > 0 && !algorithm.endsWith("gcm") && !algorithm.contains("hmac-") ? new SecretKeySpec(rawKey, 0, rawKey.length > size ? size : rawKey.length, keyAlgorithm) : (rawKey.length > 1024 ? new SecretKeySpec(rawKey, 0, 1024, keyAlgorithm) : new SecretKeySpec(rawKey, keyAlgorithm));
        return keySpec;
    }

    /*
     * WARNING - void declaration
     */
    public static KeyGenerator getKeyGenerator(String algorithm) throws WSSecurityException {
        try {
            String keyAlgorithm = JCEMapper.getJCEKeyAlgorithmFromURI((String)algorithm);
            if (keyAlgorithm == null || keyAlgorithm.length() == 0) {
                keyAlgorithm = JCEMapper.translateURItoJCEID((String)algorithm);
            }
            KeyGenerator keyGen = KeyGenerator.getInstance(keyAlgorithm);
            if (algorithm.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes128-cbc") || algorithm.equalsIgnoreCase("http://www.w3.org/2009/xmlenc11#aes128-gcm")) {
                keyGen.init(128);
            } else if (algorithm.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes192-cbc") || algorithm.equalsIgnoreCase("http://www.w3.org/2009/xmlenc11#aes192-gcm")) {
                keyGen.init(192);
            } else if (algorithm.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes256-cbc") || algorithm.equalsIgnoreCase("http://www.w3.org/2009/xmlenc11#aes256-gcm")) {
                keyGen.init(256);
            }
            return keyGen;
        }
        catch (NoSuchAlgorithmException keyAlgorithm) {
            void e;
            FFDCFilter.processException((Throwable)keyAlgorithm, (String)"org.apache.wss4j.common.util.KeyUtils", (String)"141", null, (Object[])new Object[]{algorithm});
            throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_ALGORITHM, (Exception)e);
        }
    }

    public static Cipher getCipherInstance(String cipherAlgo) throws WSSecurityException {
        return KeyUtils.getCipherInstance(cipherAlgo, null);
    }

    /*
     * WARNING - void declaration
     */
    public static Cipher getCipherInstance(String cipherAlgo, String provider) throws WSSecurityException {
        String keyAlgorithm = JCEMapper.translateURItoJCEID((String)cipherAlgo);
        if (keyAlgorithm == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_ALGORITHM, "unsupportedKeyTransp", new Object[]{"No such algorithm: \"" + cipherAlgo + "\""});
        }
        if (provider == null) {
            provider = JCEMapper.getProviderId();
        } else {
            JavaUtils.checkRegisterPermission();
        }
        try {
            if (provider == null) {
                return Cipher.getInstance(keyAlgorithm);
            }
            return Cipher.getInstance(keyAlgorithm, provider);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException generalSecurityException) {
            void e;
            FFDCFilter.processException((Throwable)generalSecurityException, (String)"org.apache.wss4j.common.util.KeyUtils", (String)"187", null, (Object[])new Object[]{cipherAlgo, provider});
            if ("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p".equals(cipherAlgo)) {
                try {
                    if (provider == null) {
                        return Cipher.getInstance(RSA_ECB_OAEPWITH_SHA1_AND_MGF1_PADDING);
                    }
                    return Cipher.getInstance(RSA_ECB_OAEPWITH_SHA1_AND_MGF1_PADDING, provider);
                }
                catch (NoSuchProviderException noSuchProviderException) {
                    void ex1;
                    FFDCFilter.processException((Throwable)noSuchProviderException, (String)"org.apache.wss4j.common.util.KeyUtils", (String)"197", null, (Object[])new Object[]{cipherAlgo, provider});
                    throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_ALGORITHM, (Exception)ex1, "unsupportedKeyTransp", new Object[]{"No such provider \"" + JCEMapper.getProviderId() + "\" for \"" + RSA_ECB_OAEPWITH_SHA1_AND_MGF1_PADDING + "\""});
                }
                catch (NoSuchPaddingException ex1) {
                    FFDCFilter.processException((Throwable)ex1, (String)"org.apache.wss4j.common.util.KeyUtils", (String)"204", null, (Object[])new Object[]{cipherAlgo, provider});
                    throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_ALGORITHM, (Exception)e, "unsupportedKeyTransp", new Object[]{"No such padding: \"RSA/ECB/OAEPWithSHA1AndMGF1Padding\""});
                }
                catch (NoSuchAlgorithmException ex1) {
                    FFDCFilter.processException((Throwable)ex1, (String)"org.apache.wss4j.common.util.KeyUtils", (String)"208", null, (Object[])new Object[]{cipherAlgo, provider});
                    throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_ALGORITHM, (Exception)e, "unsupportedKeyTransp", new Object[]{"No such algorithm: \"RSA/ECB/OAEPWithSHA1AndMGF1Padding\""});
                }
            }
            if (e instanceof NoSuchAlgorithmException) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_ALGORITHM, (Exception)e, "unsupportedKeyTransp", new Object[]{"No such algorithm: \"" + keyAlgorithm + "\""});
            }
            throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_ALGORITHM, (Exception)e, "unsupportedKeyTransp", new Object[]{"No such padding: \"" + keyAlgorithm + "\""});
        }
        catch (NoSuchProviderException e) {
            void ex;
            FFDCFilter.processException((Throwable)e, (String)"org.apache.wss4j.common.util.KeyUtils", (String)"224", null, (Object[])new Object[]{cipherAlgo, provider});
            throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_ALGORITHM, (Exception)ex, "unsupportedKeyTransp", new Object[]{"No such provider \"" + JCEMapper.getProviderId() + "\" for \"" + keyAlgorithm + "\""});
        }
    }

    /*
     * WARNING - void declaration
     */
    public static synchronized byte[] generateDigest(byte[] inputBytes) throws WSSecurityException {
        try {
            if (digest == null) {
                digest = CryptoUtils.isFips140_3Enabled() ? MessageDigest.getInstance("SHA-256") : MessageDigest.getInstance("SHA-1");
            }
            return digest.digest(inputBytes);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"org.apache.wss4j.common.util.KeyUtils", (String)"248", null, (Object[])new Object[]{inputBytes});
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, (Exception)e, "empty", new Object[]{"Error in generating digest"});
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.apache.wss4j.common.util.KeyUtils", KeyUtils.class, null, null);
        LOG = LoggerFactory.getLogger(KeyUtils.class);
        DEFAULT_DERIVED_KEY_LENGTHS = new HashMap<String, Integer>();
        DEFAULT_DERIVED_KEY_LENGTHS.put("http://www.w3.org/2001/04/xmldsig-more#hmac-md5", 128);
        DEFAULT_DERIVED_KEY_LENGTHS.put("http://www.w3.org/2001/04/xmldsig-more#hmac-ripemd160", 160);
        DEFAULT_DERIVED_KEY_LENGTHS.put("http://www.w3.org/2000/09/xmldsig#hmac-sha1", 160);
        DEFAULT_DERIVED_KEY_LENGTHS.put("http://www.w3.org/2001/04/xmldsig-more#hmac-sha224", 224);
        DEFAULT_DERIVED_KEY_LENGTHS.put("http://www.w3.org/2001/04/xmldsig-more#hmac-sha256", 256);
        DEFAULT_DERIVED_KEY_LENGTHS.put("http://www.w3.org/2001/04/xmldsig-more#hmac-sha384", 384);
        DEFAULT_DERIVED_KEY_LENGTHS.put("http://www.w3.org/2001/04/xmldsig-more#hmac-sha512", 512);
    }
}

