/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.common.cache;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.function.Supplier;
import org.apache.wss4j.common.cache.EHCacheValue;
import org.ehcache.expiry.ExpiryPolicy;

public class EHCacheExpiry
implements ExpiryPolicy<String, EHCacheValue> {
    public static long defaultTTL = 3600L;
    public long maxTTL = defaultTTL * 12L;

    public Duration getExpiryForCreation(String s, EHCacheValue ehCacheValue) {
        Instant expiry = ehCacheValue.getExpiry();
        Instant now = Instant.now();
        if (expiry == null || expiry.isBefore(now) || expiry.isAfter(now.plusSeconds(this.maxTTL))) {
            return Duration.of(defaultTTL, ChronoUnit.SECONDS);
        }
        return Duration.of(expiry.toEpochMilli() - now.toEpochMilli(), ChronoUnit.MILLIS);
    }

    public Duration getExpiryForAccess(String s, Supplier<? extends EHCacheValue> supplier) {
        return null;
    }

    public Duration getExpiryForUpdate(String s, Supplier<? extends EHCacheValue> supplier, EHCacheValue ehCacheValue) {
        return null;
    }

    public void setDefaultTTL(long ttl) {
        defaultTTL = ttl;
    }

    public void setMaxTTL(long ttl) {
        this.maxTTL = ttl;
    }
}

