/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.components.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Properties;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.Loader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CryptoFactory.class);

    public Crypto getInstance() throws WSSecurityException {
        return org.apache.wss4j.common.crypto.CryptoFactory.getInstance();
    }

    public static Crypto getInstance(Properties properties) throws WSSecurityException {
        if (properties == null) {
            LOG.debug("Cannot load Crypto instance as properties object is null");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "empty", new Object[]{"Cannot load Crypto instance as properties object is null"});
        }
        return org.apache.wss4j.common.crypto.CryptoFactory.getInstance(properties);
    }

    public static Crypto getInstance(Class<? extends Crypto> cryptoClass, Map<Object, Object> map) throws WSSecurityException {
        return CryptoFactory.loadClass(cryptoClass, map, Loader.getClassLoader(CryptoFactory.class));
    }

    public static Crypto getInstance(String propFilename) throws WSSecurityException {
        return org.apache.wss4j.common.crypto.CryptoFactory.getInstance(propFilename, Loader.getClassLoader(CryptoFactory.class));
    }

    public static Crypto getInstance(String propFilename, ClassLoader customClassLoader) throws WSSecurityException {
        Properties properties = CryptoFactory.getProperties(propFilename, customClassLoader);
        return org.apache.wss4j.common.crypto.CryptoFactory.getInstance(properties, customClassLoader, null);
    }

    private static Crypto loadClass(Class<? extends Crypto> cryptoClass, Map<Object, Object> map, ClassLoader loader) throws WSSecurityException {
        LOG.debug("Using Crypto Engine [{}]", cryptoClass);
        try {
            Constructor<? extends Crypto> c = null;
            try {
                Class[] classes = new Class[]{Map.class, ClassLoader.class};
                c = cryptoClass.getConstructor(classes);
                return c.newInstance(map, loader);
            }
            catch (NoSuchMethodException ex) {
                LOG.debug("Unable to instantiate: " + cryptoClass.getName(), (Throwable)ex);
            }
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unable to instantiate: " + cryptoClass.getName(), (Throwable)e);
            }
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, e, "empty", new Object[]{cryptoClass + " cannot create instance"});
        }
        return null;
    }

    private static Crypto loadClass(Class<? extends Crypto> cryptoClass, Properties map, ClassLoader loader) throws WSSecurityException {
        LOG.debug("Using Crypto Engine [{}]", cryptoClass);
        try {
            Constructor<? extends Crypto> c = null;
            try {
                Class[] classes = new Class[]{Properties.class, ClassLoader.class};
                c = cryptoClass.getConstructor(classes);
                return c.newInstance(map, loader);
            }
            catch (NoSuchMethodException ex) {
                LOG.debug("Unable to instantiate: " + cryptoClass.getName(), (Throwable)ex);
            }
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unable to instantiate: " + cryptoClass.getName(), (Throwable)e);
            }
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, e, "empty", new Object[]{cryptoClass + " cannot create instance"});
        }
        return null;
    }

    public static Properties getProperties(String propFilename, ClassLoader loader) throws WSSecurityException {
        Properties properties = new Properties();
        try {
            InputStream is = Loader.loadInputStream(loader, propFilename);
            if (is == null) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "resourceNotFound", new Object[]{propFilename});
            }
            properties.load(is);
            is.close();
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot find resource: " + propFilename, (Throwable)e);
            }
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, e, "resourceNotFound", new Object[]{propFilename});
        }
        return properties;
    }
}

