/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.arquillian.support;

import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.ffdc.FFDC;
import com.ibm.wsspi.logging.IncidentForwarder;
import io.openliberty.arquillian.support.IncidentListener;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@WebListener
public class Initializer
implements ServletContextListener {
    public static final String INCIDENT_LISTENER_ATTRIBUTE = "incident-listener";
    public static final String BUNDLE_CONTEXT_ATTRIBUTE = "osgi-bundlecontext";
    private ServiceRegistration<ApplicationStateListener> appStateListenerRegistration;

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext context = sce.getServletContext();
        IncidentListener listener = new IncidentListener();
        context.setAttribute(INCIDENT_LISTENER_ATTRIBUTE, (Object)listener);
        FFDC.registerIncidentForwarder((IncidentForwarder)listener);
        BundleContext bContext = (BundleContext)context.getAttribute(BUNDLE_CONTEXT_ATTRIBUTE);
        Hashtable<String, Integer> properties = new Hashtable<String, Integer>();
        ((Dictionary)properties).put("service.ranking", 5000);
        this.appStateListenerRegistration = bContext.registerService(ApplicationStateListener.class, (Object)listener, properties);
    }

    public void contextDestroyed(ServletContextEvent sce) {
        ServletContext context = sce.getServletContext();
        IncidentListener listener = (IncidentListener)context.getAttribute(INCIDENT_LISTENER_ATTRIBUTE);
        FFDC.deregisterIncidentForwarder((IncidentForwarder)listener);
        this.appStateListenerRegistration.unregister();
    }
}

