/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.audit.source.rest;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.security.audit.AuditEvent;
import com.ibm.websphere.security.audit.context.AuditManager;
import com.ibm.ws.security.audit.source.utils.AuditUtils;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.security.wim.model.Entity;
import com.ibm.wsspi.security.wim.model.Root;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;

public class MemberManagementEvent
extends AuditEvent {
    private static final TraceComponent tc = Tr.register(MemberManagementEvent.class);
    public static final String REALM_NOT_MATCHED = "realm not matched";
    public static final String REPO_NOT_MATCHED = "repository not matched";

    public MemberManagementEvent() {
        this.set("eventName", "SECURITY_MEMBER_MGMT");
        this.setInitiator((Map)AuditEvent.STD_INITIATOR.clone());
        this.setObserver((Map)AuditEvent.STD_OBSERVER.clone());
        this.setTarget((Map)AuditEvent.STD_TARGET.clone());
    }

    public MemberManagementEvent(Object request, String action, String repositoryId, String uniqueName, String realmName, Object rootObj, Integer statusCode) {
        this(request, action, repositoryId, uniqueName, realmName, rootObj, statusCode, "vmmservice");
    }

    public MemberManagementEvent(Object request, String action, String repositoryId, String uniqueName, String realmName, Object rootObj, Integer statusCode, String serviceType) {
        block65: {
            this();
            try {
                Entity entity;
                List entities;
                String httpType = "HTTPS";
                RESTRequest req = (RESTRequest)request;
                Root root = (Root)rootObj;
                this.set("target.appname", AuditUtils.getJ2EEComponentName());
                if (req != null) {
                    String agent;
                    if (req.getRemoteAddr() != null) {
                        this.set("initiator.host.address", req.getRemoteAddr());
                    }
                    if ((agent = req.getHeader("User-Agent")) != null) {
                        this.set("initiator.host.agent", agent);
                    }
                    this.set("target.name", req.getURI());
                    if (req.getQueryString() != null) {
                        String str = URLDecoder.decode(req.getQueryString(), "UTF-8");
                        str = AuditUtils.hidePassword((String)str);
                        this.set("target.params", str);
                    }
                    this.set("target.host.address", req.getRemoteAddr() + ":" + req.getRemotePort());
                    if (req.getUserPrincipal() != null && req.getUserPrincipal().getName() != null) {
                        this.set("target.credential.token", req.getUserPrincipal().getName());
                        this.set("target.credential.type", "BASIC");
                    }
                    if (req.getSessionId() != null) {
                        this.set("target.session", req.getSessionId());
                    }
                    this.set("target.method", req.getMethod());
                } else {
                    if ("create".equals(action)) {
                        this.set("target.method", "POST");
                    } else if ("update".equals(action)) {
                        this.set("target.method", "PUT");
                    } else if ("delete".equals(action)) {
                        this.set("target.method", "DELETE");
                    } else if ("search".equals(action)) {
                        this.set("target.method", "GET");
                    } else if ("get".equals(action)) {
                        this.set("target.method", "GET");
                    } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Unknown action code: " + action), (Object[])new Object[0]);
                    }
                    AuditManager auditManager = new AuditManager();
                    this.set("target.credential.token", auditManager.getCredentialUser());
                    this.set("target.credential.type", auditManager.getCredentialType());
                    if (auditManager.getRemoteAddr() != null) {
                        this.set("initiator.host.address", auditManager.getRemoteAddr());
                    }
                    if (auditManager.getAgent() != null) {
                        this.set("initiator.host.agent", auditManager.getAgent());
                    }
                    if (auditManager.getLocalAddr() != null && auditManager.getLocalPort() != null) {
                        this.set("target.host.address", auditManager.getLocalAddr() + ":" + auditManager.getLocalPort());
                    }
                    if (auditManager.getSessionId() != null) {
                        this.set("target.session", auditManager.getSessionId());
                    }
                    if (auditManager.getHttpType() != null) {
                        httpType = auditManager.getHttpType();
                    }
                }
                this.set("target.typeURI", "service/vmmservice/" + action);
                if (repositoryId != null) {
                    this.set("target.repositoryId", repositoryId);
                } else {
                    this.set("target.repositoryId", REPO_NOT_MATCHED);
                }
                if (uniqueName != null) {
                    this.set("target.uniqueName", uniqueName);
                }
                if (realmName != null) {
                    this.set("target.realm", realmName);
                } else {
                    this.set("target.realm", REALM_NOT_MATCHED);
                }
                if (action != null) {
                    this.set("target.action", action);
                }
                String qualifiedEntityType = null;
                if (root != null && (entities = root.getEntities()) != null && !entities.isEmpty() && (entity = (Entity)entities.get(0)) != null) {
                    qualifiedEntityType = entity.getTypeName();
                }
                if (qualifiedEntityType == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"No entity type provided, defaulting to Entity", (Object[])new Object[0]);
                    }
                    qualifiedEntityType = "Entity";
                }
                this.set("target.entityType", qualifiedEntityType);
                if (this.get("target.name") == null) {
                    String actionType = "Entity";
                    if (qualifiedEntityType.equals("PersonAccount")) {
                        actionType = "Users";
                    } else if (qualifiedEntityType.equals("Group")) {
                        actionType = "Group";
                    }
                    this.set("target.name", "/ibm/api/" + serviceType + "/" + action + "/" + actionType);
                }
                if (statusCode != null) {
                    this.set("reason.reasonCode", statusCode);
                    if (statusCode == 200) {
                        this.setOutcome("success");
                        this.set("reason.reasonType", httpType);
                    } else {
                        this.setOutcome("failure");
                        switch (statusCode) {
                            case 201: {
                                this.set("reason.reasonType", "Missing entity data object");
                                break;
                            }
                            case 202: {
                                this.set("reason.reasonType", "Multiple entities specified");
                                break;
                            }
                            case 203: {
                                this.set("reason.reasonType", "Entity identifier not specified");
                                break;
                            }
                            case 204: {
                                this.set("reason.reasonType", "Entity not in the scope of the realm");
                                break;
                            }
                            case 205: {
                                this.set("reason.reasonType", "Invalid parent uniqueId");
                                break;
                            }
                            case 206: {
                                this.set("reason.reasonType", "Default parent not found");
                                break;
                            }
                            case 207: {
                                this.set("reason.reasonType", "Repository for groups is missing or indicates groups are in cross repositories");
                                break;
                            }
                            case 208: {
                                this.set("reason.reasonType", "Entity type not supported");
                                break;
                            }
                            case 209: {
                                this.set("reason.reasonType", "Cannot write to read only repository");
                                break;
                            }
                            case 210: {
                                this.set("reason.reasonType", "External name control not found");
                                break;
                            }
                            case 211: {
                                this.set("reason.reasonType", "Invalid identifier");
                                break;
                            }
                            case 212: {
                                this.set("reason.reasonType", "Entity not found");
                                break;
                            }
                            case 213: {
                                this.set("reason.reasonType", "Missing sort key");
                                break;
                            }
                            case 214: {
                                this.set("reason.reasonType", "Missing search control");
                                break;
                            }
                            case 215: {
                                this.set("reason.reasonType", "Incorrect search limit");
                                break;
                            }
                            case 216: {
                                this.set("reason.reasonType", "Cannot specify count limit");
                                break;
                            }
                            case 217: {
                                this.set("reason.reasonType", "Missing search expression");
                                break;
                            }
                            case 218: {
                                this.set("reason.reasonType", "Search expression error");
                                break;
                            }
                            case 219: {
                                this.set("reason.reasonType", "Invalid search expression");
                                break;
                            }
                            case 220: {
                                this.set("reason.reasonType", "Exceeding max total search limit");
                                break;
                            }
                            case 221: {
                                this.set("reason.reasonType", "Entity search failed");
                                break;
                            }
                            default: {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Unknown statusCode: " + statusCode), (Object[])new Object[0]);
                                }
                                this.set("reason.reasonType", "Unknown:" + statusCode);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block65;
                Tr.debug((TraceComponent)tc, (String)"Internal error creating MemberManagementEvent", (Object[])new Object[]{e});
            }
        }
    }
}

