/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.faces.fat.selenium.util.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.faces.fat.selenium.util.internal.ExtendedWebDriver;
import java.time.Duration;
import java.util.List;
import java.util.function.Function;
import org.openqa.selenium.By;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WebPage {
    public static final Duration STD_TIMEOUT;
    public static final Duration LONG_TIMEOUT;
    protected ExtendedWebDriver webDriver;
    static final long serialVersionUID = 4563623182722147971L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public WebPage(ExtendedWebDriver webDriver) {
        this.webDriver = webDriver;
    }

    public WebDriver getWebDriver() {
        return this.webDriver;
    }

    public void setWebDriver(ExtendedWebDriver webDriver) {
        this.webDriver = webDriver;
    }

    public void get(String url) {
        this.webDriver.get(url);
    }

    public String getTitle() {
        return this.webDriver.getTitle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> void waitForCondition(Function<? super WebDriver, V> isTrue, Duration timeout) {
        ExtendedWebDriver extendedWebDriver = this.webDriver;
        synchronized (extendedWebDriver) {
            WebDriverWait wait = new WebDriverWait((WebDriver)this.webDriver, timeout);
            wait.until(isTrue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> void waitForCondition(Function<? super WebDriver, V> isTrue) {
        ExtendedWebDriver extendedWebDriver = this.webDriver;
        synchronized (extendedWebDriver) {
            WebDriverWait wait = new WebDriverWait((WebDriver)this.webDriver, LONG_TIMEOUT);
            wait.until(isTrue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void wait(Duration timeout) {
        ExtendedWebDriver extendedWebDriver = this.webDriver;
        synchronized (extendedWebDriver) {
            try {
                this.webDriver.wait(timeout.toMillis());
            }
            catch (InterruptedException interruptedException) {
                void e;
                FFDCFilter.processException((Throwable)interruptedException, (String)"io.openliberty.faces.fat.selenium.util.internal.WebPage", (String)"98", (Object)this, (Object[])new Object[]{timeout});
                throw new RuntimeException((Throwable)e);
            }
        }
    }

    public void waitReqJs() {
        this.wait(STD_TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForPageToLoad(Duration timeOut) {
        ExpectedCondition expectation = driver -> this.webDriver.getRemoteWebDriver().executeScript("return document.readyState", new Object[0]).equals("complete");
        ExtendedWebDriver extendedWebDriver = this.webDriver;
        synchronized (extendedWebDriver) {
            WebDriverWait wait = new WebDriverWait((WebDriver)this.webDriver, timeOut);
            wait.until((Function)expectation);
        }
    }

    public void waitForPageToLoad() {
        this.waitForPageToLoad(STD_TIMEOUT);
    }

    public boolean isInPageText(String text) {
        try {
            String values = this.getInputValues();
            this.waitForCondition(webDriver1 -> (this.webDriver.getPageText() + values).contains(text), STD_TIMEOUT);
            return true;
        }
        catch (TimeoutException values) {
            FFDCFilter.processException((Throwable)values, (String)"io.openliberty.faces.fat.selenium.util.internal.WebPage", (String)"149", (Object)this, (Object[])new Object[]{text});
            return false;
        }
    }

    public boolean isInPageTextReduced(String text) {
        try {
            String values = this.getInputValues();
            this.waitForCondition(webDriver1 -> (this.webDriver.getPageTextReduced() + values.replaceAll("\\s+", " ")).contains(text), STD_TIMEOUT);
            return true;
        }
        catch (TimeoutException values) {
            FFDCFilter.processException((Throwable)values, (String)"io.openliberty.faces.fat.selenium.util.internal.WebPage", (String)"160", (Object)this, (Object[])new Object[]{text});
            return false;
        }
    }

    public boolean matchesPageText(String regexp) {
        try {
            this.waitForCondition(webDriver1 -> this.webDriver.getPageText().matches(regexp), STD_TIMEOUT);
            return true;
        }
        catch (TimeoutException timeoutException) {
            FFDCFilter.processException((Throwable)timeoutException, (String)"io.openliberty.faces.fat.selenium.util.internal.WebPage", (String)"170", (Object)this, (Object[])new Object[]{regexp});
            return false;
        }
    }

    public boolean matchesPageTextReduced(String regexp) {
        try {
            this.waitForCondition(webDriver1 -> this.webDriver.getPageTextReduced().matches(regexp), STD_TIMEOUT);
            return true;
        }
        catch (TimeoutException timeoutException) {
            FFDCFilter.processException((Throwable)timeoutException, (String)"io.openliberty.faces.fat.selenium.util.internal.WebPage", (String)"186", (Object)this, (Object[])new Object[]{regexp});
            return false;
        }
    }

    public boolean isNotInPageText(String text) {
        try {
            String values = this.getInputValues();
            this.waitForCondition(webDriver1 -> !(this.webDriver.getPageText() + values).contains(text), STD_TIMEOUT);
            return true;
        }
        catch (TimeoutException values) {
            FFDCFilter.processException((Throwable)values, (String)"io.openliberty.faces.fat.selenium.util.internal.WebPage", (String)"204", (Object)this, (Object[])new Object[]{text});
            return false;
        }
    }

    public boolean isInPage(String text) {
        try {
            String values = this.getInputValues();
            this.waitForCondition(webDriver1 -> (this.webDriver.getPageSource() + values).contains(text), STD_TIMEOUT);
            return true;
        }
        catch (TimeoutException values) {
            FFDCFilter.processException((Throwable)values, (String)"io.openliberty.faces.fat.selenium.util.internal.WebPage", (String)"222", (Object)this, (Object[])new Object[]{text});
            return false;
        }
    }

    public boolean isNotInPage(String text) {
        try {
            String values = this.getInputValues();
            this.waitForCondition(webDriver1 -> !(this.webDriver.getPageSource() + values).contains(text), STD_TIMEOUT);
            return true;
        }
        catch (TimeoutException values) {
            FFDCFilter.processException((Throwable)values, (String)"io.openliberty.faces.fat.selenium.util.internal.WebPage", (String)"242", (Object)this, (Object[])new Object[]{text});
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean isInPage(String text, boolean allowExceptions) {
        try {
            String values = this.getInputValues();
            this.waitForCondition(webDriver1 -> (this.webDriver.getPageSource() + values).contains(text), STD_TIMEOUT);
            return true;
        }
        catch (TimeoutException values) {
            void exception;
            FFDCFilter.processException((Throwable)values, (String)"io.openliberty.faces.fat.selenium.util.internal.WebPage", (String)"262", (Object)this, (Object[])new Object[]{text, allowExceptions});
            if (allowExceptions) {
                throw exception;
            }
            exception.printStackTrace();
            return false;
        }
    }

    public WebElement findElement(By by) {
        return this.webDriver.findElement(by);
    }

    public List<WebElement> findElements(By by) {
        return this.webDriver.findElements(by);
    }

    public String getPageSource() {
        return this.webDriver.getPageSource();
    }

    public List<WebElement> getAnchors() {
        return this.webDriver.findElements(By.cssSelector((String)"a[href]"));
    }

    private String getInputValues() {
        int maxAttempts = 3;
        for (int currentAttempt = 0; currentAttempt < maxAttempts; ++currentAttempt) {
            try {
                return this.webDriver.findElements(By.cssSelector((String)"input, textarea, select")).stream().map(webElement -> webElement.getAttribute("value")).reduce("", (str1, str2) -> str1 + " " + str2);
            }
            catch (StaleElementReferenceException staleElementReferenceException) {
                FFDCFilter.processException((Throwable)staleElementReferenceException, (String)"io.openliberty.faces.fat.selenium.util.internal.WebPage", (String)"301", (Object)this, (Object[])new Object[0]);
                continue;
            }
        }
        throw new IllegalStateException("StaleElementReferenceException occurred more than 3 times!");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.faces.fat.selenium.util.internal.WebPage", WebPage.class, null, null);
        STD_TIMEOUT = Duration.ofMillis(8000L);
        LONG_TIMEOUT = Duration.ofMillis(16000L);
    }
}

