/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.subsystem;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.subsystem.Subsystem;
import org.osgi.service.subsystem.SubsystemPermissionCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SubsystemPermission
extends BasicPermission {
    static final long serialVersionUID = 307051004521261705L;
    public static final String EXECUTE = "execute";
    public static final String LIFECYCLE = "lifecycle";
    public static final String METADATA = "metadata";
    public static final String CONTEXT = "context";
    private static final int ACTION_EXECUTE = 1;
    private static final int ACTION_LIFECYCLE = 2;
    private static final int ACTION_METADATA = 4;
    private static final int ACTION_CONTEXT = 8;
    private static final int ACTION_ALL = 15;
    static final int ACTION_NONE = 0;
    private volatile String actions = null;
    transient int action_mask;
    transient Filter filter;
    final transient Subsystem subsystem;
    private volatile transient Map<String, Object> properties;
    private static final ThreadLocal<Subsystem> recurse = new ThreadLocal();

    public SubsystemPermission(String filter, String actions) {
        this(SubsystemPermission.parseFilter(filter), SubsystemPermission.parseActions(actions));
    }

    public SubsystemPermission(Subsystem subsystem, String actions) {
        super(SubsystemPermission.createName(subsystem));
        this.setTransients(null, SubsystemPermission.parseActions(actions));
        this.subsystem = subsystem;
    }

    private static String createName(Subsystem subsystem) {
        if (subsystem == null) {
            throw new IllegalArgumentException("subsystem must not be null");
        }
        StringBuffer sb = new StringBuffer("(id=");
        sb.append(subsystem.getSubsystemId());
        sb.append(")");
        return sb.toString();
    }

    SubsystemPermission(Filter filter, int mask) {
        super(filter == null ? "*" : filter.toString());
        this.setTransients(filter, mask);
        this.subsystem = null;
    }

    private void setTransients(Filter filter, int mask) {
        this.filter = filter;
        if (mask == 0 || (mask & 0xF) != mask) {
            throw new IllegalArgumentException("invalid action string");
        }
        this.action_mask = mask;
    }

    private static int parseActions(String actions) {
        boolean seencomma = false;
        int mask = 0;
        if (actions == null) {
            return mask;
        }
        char[] a = actions.toCharArray();
        int i = a.length - 1;
        if (i < 0) {
            return mask;
        }
        while (i != -1) {
            int matchlen;
            char c;
            while (i != -1 && ((c = a[i]) == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t')) {
                --i;
            }
            if (!(i < 6 || a[i - 6] != 'e' && a[i - 6] != 'E' || a[i - 5] != 'x' && a[i - 5] != 'X' || a[i - 4] != 'e' && a[i - 4] != 'E' || a[i - 3] != 'c' && a[i - 3] != 'C' || a[i - 2] != 'u' && a[i - 2] != 'U' || a[i - 1] != 't' && a[i - 1] != 'T' || a[i] != 'e' && a[i] != 'E')) {
                matchlen = 7;
                mask |= 1;
            } else if (!(i < 8 || a[i - 8] != 'l' && a[i - 8] != 'L' || a[i - 7] != 'i' && a[i - 7] != 'I' || a[i - 6] != 'f' && a[i - 6] != 'F' || a[i - 5] != 'e' && a[i - 5] != 'E' || a[i - 4] != 'c' && a[i - 4] != 'C' || a[i - 3] != 'y' && a[i - 3] != 'Y' || a[i - 2] != 'c' && a[i - 2] != 'C' || a[i - 1] != 'l' && a[i - 1] != 'L' || a[i] != 'e' && a[i] != 'E')) {
                matchlen = 9;
                mask |= 2;
            } else if (!(i < 7 || a[i - 7] != 'm' && a[i - 7] != 'M' || a[i - 6] != 'e' && a[i - 6] != 'E' || a[i - 5] != 't' && a[i - 5] != 'T' || a[i - 4] != 'a' && a[i - 4] != 'A' || a[i - 3] != 'd' && a[i - 3] != 'D' || a[i - 2] != 'a' && a[i - 2] != 'A' || a[i - 1] != 't' && a[i - 1] != 'T' || a[i] != 'a' && a[i] != 'A')) {
                matchlen = 8;
                mask |= 4;
            } else if (!(i < 6 || a[i - 6] != 'c' && a[i - 6] != 'C' || a[i - 5] != 'o' && a[i - 5] != 'O' || a[i - 4] != 'n' && a[i - 4] != 'N' || a[i - 3] != 't' && a[i - 3] != 'T' || a[i - 2] != 'e' && a[i - 2] != 'E' || a[i - 1] != 'x' && a[i - 1] != 'X' || a[i] != 't' && a[i] != 'T')) {
                matchlen = 7;
                mask |= 8;
            } else {
                throw new IllegalArgumentException("invalid permission: " + actions);
            }
            seencomma = false;
            while (i >= matchlen && !seencomma) {
                switch (a[i - matchlen]) {
                    case ',': {
                        seencomma = true;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid permission: " + actions);
                    }
                }
                --i;
            }
            i -= matchlen;
        }
        if (seencomma) {
            throw new IllegalArgumentException("invalid permission: " + actions);
        }
        return mask;
    }

    private static Filter parseFilter(String filterString) {
        if ((filterString = filterString.trim()).equals("*")) {
            return null;
        }
        try {
            return FrameworkUtil.createFilter((String)filterString);
        }
        catch (InvalidSyntaxException e) {
            IllegalArgumentException iae = new IllegalArgumentException("invalid filter");
            iae.initCause(e);
            throw iae;
        }
    }

    @Override
    public boolean implies(Permission p) {
        if (!(p instanceof SubsystemPermission)) {
            return false;
        }
        SubsystemPermission requested = (SubsystemPermission)p;
        if (this.subsystem != null) {
            return false;
        }
        if (requested.filter != null) {
            return false;
        }
        return this.implies0(requested, 0);
    }

    boolean implies0(SubsystemPermission requested, int effective) {
        int desired = requested.action_mask;
        if (((effective |= this.action_mask) & desired) != desired) {
            return false;
        }
        Filter f = this.filter;
        if (f == null) {
            return true;
        }
        if (requested.subsystem == null) {
            return false;
        }
        Map<String, Object> requestedProperties = requested.getProperties();
        if (requestedProperties == null) {
            return true;
        }
        return f.matches(requestedProperties);
    }

    @Override
    public String getActions() {
        String result = this.actions;
        if (result == null) {
            StringBuffer sb = new StringBuffer();
            int mask = this.action_mask;
            if ((mask & 1) == 1) {
                sb.append(EXECUTE);
                sb.append(',');
            }
            if ((mask & 2) == 2) {
                sb.append(LIFECYCLE);
                sb.append(',');
            }
            if ((mask & 4) == 4) {
                sb.append(METADATA);
                sb.append(',');
            }
            if ((mask & 8) == 8) {
                sb.append(CONTEXT);
                sb.append(',');
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
            }
            this.actions = result = sb.toString();
        }
        return result;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new SubsystemPermissionCollection();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SubsystemPermission)) {
            return false;
        }
        SubsystemPermission sp = (SubsystemPermission)obj;
        return this.action_mask == sp.action_mask && (this.subsystem == sp.subsystem || this.subsystem != null && this.subsystem.equals(sp.subsystem)) && (this.filter == null ? sp.filter == null : this.filter.equals((Object)sp.filter));
    }

    @Override
    public int hashCode() {
        int h = 527 + this.getName().hashCode();
        h = 31 * h + this.getActions().hashCode();
        if (this.subsystem != null) {
            h = 31 * h + this.subsystem.hashCode();
        }
        return h;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        if (this.subsystem != null) {
            throw new NotSerializableException("cannot serialize");
        }
        if (this.actions == null) {
            this.getActions();
        }
        s.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.setTransients(SubsystemPermission.parseFilter(this.getName()), SubsystemPermission.parseActions(this.actions));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> getProperties() {
        Map<String, Object> result = this.properties;
        if (result != null) {
            return result;
        }
        Subsystem mark = recurse.get();
        if (mark == this.subsystem) {
            return null;
        }
        recurse.set(this.subsystem);
        try {
            final HashMap<String, Object> map = new HashMap<String, Object>(4);
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    map.put("id", new Long(SubsystemPermission.this.subsystem.getSubsystemId()));
                    map.put("location", SubsystemPermission.this.subsystem.getLocation());
                    map.put("name", SubsystemPermission.this.subsystem.getSymbolicName());
                    return null;
                }
            });
            this.properties = map;
            HashMap<String, Object> hashMap = this.properties;
            return hashMap;
        }
        finally {
            recurse.set(null);
        }
    }
}

