/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.internal;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Description;
import org.jmock.api.Action;
import org.jmock.api.Imposteriser;
import org.jmock.api.Invocation;
import org.jmock.lib.JavaReflectionImposteriser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReturnDefaultValueAction
implements Action {
    private final Map<Class<?>, Object> resultValuesByType = new HashMap();
    private Imposteriser imposteriser;

    public ReturnDefaultValueAction(Imposteriser imposteriser) {
        this.imposteriser = imposteriser;
        this.createDefaultResults();
    }

    public ReturnDefaultValueAction() {
        this(new JavaReflectionImposteriser());
    }

    public void setImposteriser(Imposteriser newImposteriser) {
        this.imposteriser = newImposteriser;
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("returns a default value");
    }

    public void addResult(Class<?> resultType, Object resultValue) {
        this.resultValuesByType.put(resultType, resultValue);
    }

    @Override
    public Object invoke(Invocation invocation) throws Throwable {
        Class<?> returnType = invocation.getInvokedMethod().getReturnType();
        if (this.resultValuesByType.containsKey(returnType)) {
            return this.resultValuesByType.get(returnType);
        }
        if (returnType.isArray()) {
            return Array.newInstance(returnType.getComponentType(), 0);
        }
        if (this.imposteriser.canImposterise(returnType)) {
            return this.imposteriser.imposterise(this, returnType, new Class[0]);
        }
        return null;
    }

    protected void createDefaultResults() {
        this.addResult(Boolean.TYPE, Boolean.FALSE);
        this.addResult(Void.TYPE, null);
        this.addResult(Byte.TYPE, new Byte(0));
        this.addResult(Short.TYPE, new Short(0));
        this.addResult(Integer.TYPE, new Integer(0));
        this.addResult(Long.TYPE, new Long(0L));
        this.addResult(Character.TYPE, new Character('\u0000'));
        this.addResult(Float.TYPE, new Float(0.0f));
        this.addResult(Double.TYPE, new Double(0.0));
        this.addResult(Boolean.class, Boolean.FALSE);
        this.addResult(Byte.class, new Byte(0));
        this.addResult(Short.class, new Short(0));
        this.addResult(Integer.class, new Integer(0));
        this.addResult(Long.class, new Long(0L));
        this.addResult(Character.class, new Character('\u0000'));
        this.addResult(Float.class, new Float(0.0f));
        this.addResult(Double.class, new Double(0.0));
        this.addResult(String.class, "");
        this.addResult(Object.class, new Object());
    }
}

