/*
 * Decompiled with CFR 0.152.
 */
package componenttest.matchers;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public final class Matchers {
    public static <T> Matcher<T> does(Matcher<T> matcher) {
        return matcher;
    }

    public static Matcher<String> containString(String subString) {
        return org.hamcrest.Matchers.containsString(subString);
    }

    public static <T> Matcher<Iterable<? super T>> haveItem(T element) {
        return org.hamcrest.Matchers.hasItem(element);
    }

    public static final <T> Matcher<Iterable<T>> hasSubsequence(T ... items) {
        return new DoesCollectionHaveSubsequence<T>(Arrays.asList(items));
    }

    public static final <T> Positional<T> item(T item) {
        return new Positional<T>(item);
    }

    public static final Matcher<String> containsPattern(Pattern pattern) {
        return new ContainsPattern(pattern);
    }

    public static final Matcher<String> containsPattern(String regex) {
        return new ContainsPattern(Pattern.compile(regex));
    }

    private Matchers() {
    }

    public static final class DoesCollectionHaveSubsequence<T>
    extends TypeSafeMatcher<Iterable<T>> {
        private final List<T> elements;

        public DoesCollectionHaveSubsequence(List<T> elements) {
            this.elements = elements;
        }

        private static <T> boolean findInOrder(Iterable<T> iterToSearch, Iterator<T> itemsToFind) {
            if (itemsToFind.hasNext()) {
                T itemToFind = itemsToFind.next();
                for (T candidate : iterToSearch) {
                    if (!candidate.equals(itemToFind)) continue;
                    if (itemsToFind.hasNext()) {
                        itemToFind = itemsToFind.next();
                        continue;
                    }
                    return true;
                }
            } else {
                return true;
            }
            return false;
        }

        @Override
        public void describeTo(Description description) {
            description.appendText("a collection containing, in order (ignoring extra entries): " + this.elements.toString());
        }

        @Override
        public boolean matchesSafely(Iterable<T> item) {
            return DoesCollectionHaveSubsequence.findInOrder(item, this.elements.iterator());
        }
    }

    public static final class Positional<T> {
        private final T item1;

        public Positional(T item1) {
            this.item1 = item1;
        }

        public Matcher<Iterable<T>> isBefore(T item2) {
            return Matchers.hasSubsequence(this.item1, item2);
        }

        public Matcher<Iterable<T>> isAfter(T item2) {
            return Matchers.hasSubsequence(item2, this.item1);
        }
    }

    public static final class ContainsPattern
    extends TypeSafeMatcher<String> {
        private final Pattern pattern;

        public ContainsPattern(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        protected boolean matchesSafely(String item) {
            return this.pattern.matcher(item).find();
        }

        @Override
        public void describeTo(Description description) {
            description.appendText("String containing text matching ").appendValue(this.pattern);
        }
    }
}

