/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.opentracing;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.jaxrs20.providers.api.JaxRsProviderRegister;
import com.ibm.ws.opentracing.OpentracingClientFilter;
import com.ibm.ws.opentracing.OpentracingContainerFilter;
import com.ibm.ws.opentracing.OpentracingFilterHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.List;
import java.util.Set;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(immediate=true, service={JaxRsProviderRegister.class})
public class OpentracingJaxRsProviderRegister
implements JaxRsProviderRegister {
    private static final TraceComponent tc = Tr.register(OpentracingJaxRsProviderRegister.class, (String)"OPENTRACING", (String)"io.openliberty.opentracing.internal.resources.Opentracing");
    private OpentracingContainerFilter containerFilter;
    private OpentracingClientFilter clientFilter;
    private OpentracingFilterHelper helper;
    static final long serialVersionUID = 6444963081972415476L;

    protected synchronized void activate(ComponentContext context) {
        this.setContainerFilter();
        this.setClientFilter();
    }

    protected void deactivate(ComponentContext context) {
        this.clearContainerFilter();
        this.clearClientFilter();
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected synchronized void setOpentracingFilterHelper(OpentracingFilterHelper helper) {
        this.helper = helper;
        if (this.containerFilter != null) {
            this.containerFilter.setFilterHelper(helper);
        }
        if (this.clientFilter != null) {
            this.clientFilter.setFilterHelper(helper);
        }
    }

    protected void unsetOpentracingFilterHelper(OpentracingFilterHelper helper) {
        this.helper = null;
        if (this.containerFilter != null) {
            this.containerFilter.setFilterHelper(null);
        }
        if (this.clientFilter != null) {
            this.clientFilter.setFilterHelper(null);
        }
    }

    @Trivial
    protected void setContainerFilter() {
        this.containerFilter = new OpentracingContainerFilter(this.helper);
    }

    @Trivial
    protected void clearContainerFilter() {
        this.containerFilter = null;
    }

    @Trivial
    protected OpentracingContainerFilter getContainerFilter() {
        return this.containerFilter;
    }

    @Trivial
    protected void setClientFilter() {
        this.clientFilter = new OpentracingClientFilter(this.helper);
    }

    @Trivial
    protected void clearClientFilter() {
        this.clientFilter = null;
    }

    @Trivial
    protected OpentracingClientFilter getClientFilter() {
        return this.clientFilter;
    }

    @Trivial
    public void installProvider(boolean clientSide, List<Object> providers, Set<String> features) {
        String methodName = "installProvider";
        if (clientSide) {
            OpentracingClientFilter useClientFilter = this.getClientFilter();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"Client Filter", useClientFilter});
            }
            if (useClientFilter != null) {
                providers.add(useClientFilter);
            }
        } else {
            OpentracingContainerFilter useContainerFilter = this.getContainerFilter();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"Container Filter", useContainerFilter});
            }
            if (useContainerFilter != null) {
                providers.add(useContainerFilter);
            }
        }
    }
}

