/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.connections;

import com.ibm.ws.repository.connections.RepositoryConnection;
import com.ibm.ws.repository.connections.RestRepositoryConnectionProxy;
import com.ibm.ws.repository.connections.internal.AbstractRepositoryConnection;
import com.ibm.ws.repository.transport.client.ClientLoginInfo;
import com.ibm.ws.repository.transport.client.RepositoryReadableClient;
import com.ibm.ws.repository.transport.client.RestClient;

public class RestRepositoryConnection
extends AbstractRepositoryConnection
implements RepositoryConnection {
    private String repositoryUrl;
    private String userId;
    private String password;
    private String apiKey;
    private String softlayerUserId;
    private String softlayerPassword;
    private String attachmentBasicAuthUserId;
    private String attachmentBasicAuthPassword;
    private String userAgent;
    private RestRepositoryConnectionProxy proxy;

    public RestRepositoryConnection(String repositoryUrl) {
        this(null, null, null, repositoryUrl);
    }

    public RestRepositoryConnection(String userId, String password, String apiKey, String repositoryUrl) {
        this(userId, password, apiKey, repositoryUrl, null, null, null, null);
    }

    public RestRepositoryConnection(String userId, String password, String apiKey, String repositoryUrl, String softlayerUserId, String softlayerPassword) {
        this(userId, password, apiKey, repositoryUrl, softlayerUserId, softlayerPassword, null, null);
    }

    public RestRepositoryConnection(String userId, String password, String apiKey, String repositoryUrl, String softlayerUserId, String softlayerPassword, String attachmentBasicAuthUserId, String gsaPassword) {
        this.userId = userId;
        this.password = password;
        this.apiKey = apiKey;
        this.repositoryUrl = repositoryUrl;
        this.softlayerUserId = softlayerUserId;
        this.softlayerPassword = softlayerPassword;
        this.attachmentBasicAuthUserId = attachmentBasicAuthUserId;
        this.attachmentBasicAuthPassword = gsaPassword;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public void setRepositoryUrl(String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
    }

    public String getSoftlayerUserId() {
        return this.softlayerUserId;
    }

    public void setSoftlayerUserId(String softlayerUserId) {
        this.softlayerUserId = softlayerUserId;
    }

    public String getSoftlayerPassword() {
        return this.softlayerPassword;
    }

    public void setSoftlayerPassword(String softlayerPassword) {
        this.softlayerPassword = softlayerPassword;
    }

    public String getAttachmentBasicAuthUserId() {
        return this.attachmentBasicAuthUserId;
    }

    public void setAttachmentBasicAuthUserId(String attachmentBasicAuthUserId) {
        this.attachmentBasicAuthUserId = attachmentBasicAuthUserId;
    }

    public String getAttachmentBasicAuthPassword() {
        return this.attachmentBasicAuthPassword;
    }

    public void setAttachmentBasicAuthPassword(String attachmentBasicAuthPassword) {
        this.attachmentBasicAuthPassword = attachmentBasicAuthPassword;
    }

    public ClientLoginInfo getClientLoginInfo() {
        ClientLoginInfo clientLogin = new ClientLoginInfo(this.userId, this.password, this.apiKey, this.repositoryUrl, this.softlayerUserId, this.softlayerPassword, this.attachmentBasicAuthUserId, this.attachmentBasicAuthPassword, this.userAgent);
        if (this.proxy != null) {
            clientLogin.setProxy(this.proxy.getLoginInfoClientProxy());
        }
        return clientLogin;
    }

    public void setProxy(RestRepositoryConnectionProxy proxy) {
        this.proxy = proxy;
    }

    public RestRepositoryConnectionProxy getProxy() {
        return this.proxy;
    }

    public String getAssetURL(String id) {
        String url = this.getRepositoryUrl() + "/assets/" + id + "?";
        if (this.getUserId() != null) {
            url = url + "userId=" + this.getUserId();
        }
        if (this.getUserId() != null && this.getPassword() != null) {
            url = url + "&password=" + this.getPassword();
        }
        if (this.getApiKey() != null) {
            url = url + "&apiKey=" + this.getApiKey();
        }
        return url;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    @Override
    public String getRepositoryLocation() {
        return this.getRepositoryUrl();
    }

    @Override
    public RepositoryReadableClient createClient() {
        return new RestClient(this.getClientLoginInfo());
    }
}

