/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.http.netty.cookie;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.genericbnf.internal.GenericUtils;
import com.ibm.ws.http.channel.internal.cookies.CookieHeaderByteParser;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.http.HttpCookie;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import java.util.Collections;
import java.util.List;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CookieDecoder {
    static final long serialVersionUID = 6034370243800855991L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private CookieDecoder() {
    }

    public static List<HttpCookie> decode(String cookieString, HttpHeaderKeys header) {
        if (cookieString == null || cookieString.isEmpty()) {
            return Collections.emptyList();
        }
        byte[] bytes = GenericUtils.getEnglishBytes(cookieString);
        return CookieDecoder.decode(bytes, header);
    }

    public static List<HttpCookie> decode(byte[] cookieBytes, HttpHeaderKeys header) {
        if (cookieBytes == null || cookieBytes.length == 0) {
            return Collections.emptyList();
        }
        CookieHeaderByteParser parser = new CookieHeaderByteParser();
        return parser.parse(cookieBytes, (HeaderKeys)header);
    }

    public static List<HttpCookie> decodeServerCookies(String cookieString) {
        return CookieDecoder.decode(cookieString, HttpHeaderKeys.HDR_COOKIE);
    }

    public static List<HttpCookie> decodeServerCookies2(String cookieString) {
        return CookieDecoder.decode(cookieString, HttpHeaderKeys.HDR_COOKIE2);
    }

    public static List<HttpCookie> decodeSetCookieHeader(String cookieString) {
        return CookieDecoder.decode(cookieString, HttpHeaderKeys.HDR_SET_COOKIE);
    }

    public static List<HttpCookie> decodeSetCookie2Header(String cookieString) {
        return CookieDecoder.decode(cookieString, HttpHeaderKeys.HDR_SET_COOKIE2);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.http.netty.cookie.CookieDecoder", CookieDecoder.class, null, null);
    }
}

