/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http2.test;

import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import java.math.BigInteger;

public class utils {
    public static final int IO_DEFAULT_TIMEOUT = 28000;
    public static final int IO_DEFAULT_BUFFER_SIZE = 4090;
    public static final byte FRAME_TYPE_DATA = 0;
    public static final byte FRAME_TYPE_HEADERS = 1;
    public static final byte FRAME_TYPE_PRIORITY = 2;
    public static final byte FRAME_TYPE_RST_STREAM = 3;
    public static final byte FRAME_TYPE_SETTINGS = 4;
    public static final byte FRAME_TYPE_PUSH_PROMISE = 5;
    public static final byte FRAME_TYPE_PING = 6;
    public static final byte FRAME_TYPE_GOAWAY = 7;
    public static final byte FRAME_TYPE_WINDOW_UPDATE = 8;
    public static final byte FRAME_TYPE_CONTINUATION = 9;
    public static final int ZERO_STREAM_ID = 0;
    public static final byte FRAME_TYPE_INDEX = 3;
    public static final byte FRAME_FLAGS_INDEX = 4;
    public static final byte FRAME_STREAM_START_INDEX = 5;
    public static final int FRAME_STREAM_START_INDEX_INT = 5;
    public static final byte[] CLIENT_PREFACE_STRING_IN_BYTES = new BigInteger("505249202a20485454502f322e300d0a0d0a534d0d0a0d0a", 16).toByteArray();
    public static final String h1_1UpgradeHeader = "HTTP/1.1 101 Switching Protocols<CR>\n<LF>Connection: Upgrade<CR>\n<LF>Upgrade: h2c<CR>\n<LF><CR>\n<LF>";

    public static void Move8BitstoByteArray(int in, byte[] out, int offset) {
        out[offset] = (byte)(in & 0xFF);
    }

    public static void Move16BitstoByteArray(int in, byte[] out, int offset) {
        out[offset] = (byte)(in >> 8 & 0xFF);
        out[++offset] = (byte)(in & 0xFF);
    }

    public static void Move24BitstoByteArray(int in, byte[] out, int offset) {
        out[offset] = (byte)(in >> 16 & 0xFF);
        out[++offset] = (byte)(in >> 8 & 0xFF);
        out[++offset] = (byte)(in & 0xFF);
    }

    public static void Move31BitstoByteArray(int in, byte[] out, int offset) {
        out[offset] = (byte)(in >>> 24 & 0x7F);
        out[++offset] = (byte)(in >> 16 & 0xFF);
        out[++offset] = (byte)(in >> 8 & 0xFF);
        out[++offset] = (byte)(in & 0xFF);
    }

    public static void Move32BitstoByteArray(int in, byte[] out, int offset) {
        out[offset] = (byte)(in >>> 24 & 0xFF);
        out[++offset] = (byte)(in >> 16 & 0xFF);
        out[++offset] = (byte)(in >> 8 & 0xFF);
        out[++offset] = (byte)(in & 0xFF);
    }

    public static long getIntFromByteArray(byte[] out, int offset) {
        int firstByte = 0;
        int secondByte = 0;
        int thirdByte = 0;
        int fourthByte = 0;
        firstByte = 0xFF & out[offset];
        secondByte = 0xFF & out[++offset];
        thirdByte = 0xFF & out[++offset];
        fourthByte = 0xFF & out[++offset];
        return (long)(firstByte << 24 | secondByte << 16 | thirdByte << 8 | fourthByte) & 0xFFFFFFFFL;
    }

    public static long getIntFromByteBuffer(WsByteBuffer out) {
        int firstByte = 0;
        int secondByte = 0;
        int thirdByte = 0;
        int fourthByte = 0;
        firstByte = 0xFF & out.get();
        secondByte = 0xFF & out.get();
        thirdByte = 0xFF & out.get();
        fourthByte = 0xFF & out.get();
        return (long)(firstByte << 24 | secondByte << 16 | thirdByte << 8) | (long)fourthByte & 0xFFFFFFFFL;
    }

    public static char getShortFromByteArray(byte[] out, int offset) {
        int firstByte = 0;
        int secondByte = 0;
        firstByte = 0xFF & out[offset];
        secondByte = 0xFF & out[++offset];
        ++offset;
        return (char)(firstByte << 8 | secondByte);
    }

    public static char getShortFromByteBuffer(WsByteBuffer out) {
        int firstByte = 0;
        int secondByte = 0;
        firstByte = 0xFF & out.get();
        secondByte = 0xFF & out.get();
        return (char)(firstByte << 8 | secondByte);
    }

    public static byte getIndexNumber(String x) {
        if (x == null) {
            return -1;
        }
        if (x.compareToIgnoreCase(":authority") == 0) {
            return 1;
        }
        if (x.compareToIgnoreCase(":method-GET") == 0) {
            return 2;
        }
        if (x.compareToIgnoreCase(":method-POST") == 0) {
            return 3;
        }
        if (x.compareToIgnoreCase(":path-/") == 0) {
            return 4;
        }
        if (x.compareToIgnoreCase(":path-/index.html") == 0) {
            return 5;
        }
        if (x.compareToIgnoreCase(":scheme-http") == 0) {
            return 6;
        }
        if (x.compareToIgnoreCase(":scheme-https") == 0) {
            return 7;
        }
        if (x.compareToIgnoreCase(":status-200") == 0) {
            return 8;
        }
        if (x.compareToIgnoreCase(":status-204") == 0) {
            return 9;
        }
        if (x.compareToIgnoreCase(":status-206") == 0) {
            return 10;
        }
        if (x.compareToIgnoreCase(":status-304") == 0) {
            return 11;
        }
        if (x.compareToIgnoreCase(":status-400") == 0) {
            return 12;
        }
        if (x.compareToIgnoreCase(":status-404") == 0) {
            return 13;
        }
        if (x.compareToIgnoreCase(":status-500") == 0) {
            return 14;
        }
        if (x.compareToIgnoreCase("accept-charset") == 0) {
            return 15;
        }
        if (x.compareToIgnoreCase("accept-encoding-gzip") == 0) {
            return 16;
        }
        if (x.compareToIgnoreCase("accept-encoding-deflate") == 0) {
            return 16;
        }
        if (x.compareToIgnoreCase("accept-language") == 0) {
            return 17;
        }
        if (x.compareToIgnoreCase("accept-ranges") == 0) {
            return 18;
        }
        if (x.compareToIgnoreCase("accept") == 0) {
            return 19;
        }
        if (x.compareToIgnoreCase("access-control-allow-origin") == 0) {
            return 20;
        }
        if (x.compareToIgnoreCase("age") == 0) {
            return 21;
        }
        if (x.compareToIgnoreCase("allow") == 0) {
            return 22;
        }
        if (x.compareToIgnoreCase("authorization") == 0) {
            return 23;
        }
        if (x.compareToIgnoreCase("cache-control") == 0) {
            return 24;
        }
        if (x.compareToIgnoreCase("content-disposition") == 0) {
            return 25;
        }
        if (x.compareToIgnoreCase("content-encoding") == 0) {
            return 26;
        }
        if (x.compareToIgnoreCase("content-language") == 0) {
            return 27;
        }
        if (x.compareToIgnoreCase("content-length") == 0) {
            return 28;
        }
        if (x.compareToIgnoreCase("content-location") == 0) {
            return 29;
        }
        if (x.compareToIgnoreCase("content-range") == 0) {
            return 30;
        }
        if (x.compareToIgnoreCase("content-type") == 0) {
            return 31;
        }
        if (x.compareToIgnoreCase("cookie") == 0) {
            return 32;
        }
        if (x.compareToIgnoreCase("date") == 0) {
            return 33;
        }
        if (x.compareToIgnoreCase("etag") == 0) {
            return 34;
        }
        if (x.compareToIgnoreCase("expect") == 0) {
            return 35;
        }
        if (x.compareToIgnoreCase("expires") == 0) {
            return 36;
        }
        if (x.compareToIgnoreCase("from") == 0) {
            return 37;
        }
        if (x.compareToIgnoreCase("host") == 0) {
            return 38;
        }
        if (x.compareToIgnoreCase("if-match") == 0) {
            return 39;
        }
        if (x.compareToIgnoreCase("if-modified-since") == 0) {
            return 40;
        }
        if (x.compareToIgnoreCase("if-none-match") == 0) {
            return 41;
        }
        if (x.compareToIgnoreCase("if-range") == 0) {
            return 42;
        }
        if (x.compareToIgnoreCase("if-unmodified-since") == 0) {
            return 43;
        }
        if (x.compareToIgnoreCase("last-modified") == 0) {
            return 44;
        }
        if (x.compareToIgnoreCase("link") == 0) {
            return 45;
        }
        if (x.compareToIgnoreCase("location") == 0) {
            return 46;
        }
        if (x.compareToIgnoreCase("max-forwards") == 0) {
            return 47;
        }
        if (x.compareToIgnoreCase("proxy-authenticate") == 0) {
            return 48;
        }
        if (x.compareToIgnoreCase("proxy-authorization") == 0) {
            return 49;
        }
        if (x.compareToIgnoreCase("range") == 0) {
            return 50;
        }
        if (x.compareToIgnoreCase("referer") == 0) {
            return 51;
        }
        if (x.compareToIgnoreCase("refresh") == 0) {
            return 52;
        }
        if (x.compareToIgnoreCase("retry-after") == 0) {
            return 53;
        }
        if (x.compareToIgnoreCase("server") == 0) {
            return 54;
        }
        if (x.compareToIgnoreCase("set-cookie") == 0) {
            return 55;
        }
        if (x.compareToIgnoreCase("strict-transport-security") == 0) {
            return 56;
        }
        if (x.compareToIgnoreCase("transfer-encoding") == 0) {
            return 57;
        }
        if (x.compareToIgnoreCase("user-agent") == 0) {
            return 58;
        }
        if (x.compareToIgnoreCase("vary") == 0) {
            return 59;
        }
        if (x.compareToIgnoreCase("via") == 0) {
            return 60;
        }
        if (x.compareToIgnoreCase("www-authenticate") == 0) {
            return 61;
        }
        return -1;
    }

    public static void printArray(byte[] x) {
        for (int i = 1; i <= x.length; ++i) {
            if (i % 16 == 0) {
                System.out.println(String.format("0x%02X", x[i - 1]) + " ");
                continue;
            }
            System.out.print(String.format("0x%02X", x[i - 1]) + " ");
        }
    }

    public static void printCharArrayWithHex(char[] x, int length) {
        int count = 0;
        for (int i = 0; i < length; ++i) {
            char c = x[i];
            byte b = (byte)c;
            if (++count % 64 == 0 && b != 10) {
                if (b == 13) {
                    System.out.println("<CR>");
                    count = 0;
                    continue;
                }
                if (b > 0 && b < 127) {
                    System.out.println(c);
                    count = 0;
                    continue;
                }
                System.out.println(String.format("<0x%02X>", b) + " ");
                count = 0;
                continue;
            }
            if (b == 10) {
                System.out.print("\n<LF>");
                count = 0;
                continue;
            }
            if (b == 13) {
                System.out.print("<CR>");
                continue;
            }
            if (b > 0 && b < 127) {
                System.out.print(c);
                continue;
            }
            System.out.print(String.format("<0x%02X>", b) + " ");
        }
    }

    public static String printByteArrayWithHex(byte[] x, int length) {
        StringBuilder response = new StringBuilder();
        int count = 0;
        for (int i = 0; i < length; ++i) {
            char c;
            byte b = x[i];
            if (++count % 64 == 0 && b != 10) {
                if (b == 13) {
                    response.append("<CR>");
                } else if (b > 0 && b < 127) {
                    c = (char)b;
                    response.append(c);
                }
                count = 0;
                continue;
            }
            if (b == 10) {
                response.append("\n<LF>");
                count = 0;
                continue;
            }
            if (b == 13) {
                response.append("<CR>");
                continue;
            }
            if (b <= 0 || b >= 127) continue;
            c = (char)b;
            response.append(c);
        }
        return response.toString();
    }
}

