/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http2.test.frames;

import com.ibm.ws.http.channel.h2internal.frames.FrameSettings;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import io.netty.handler.codec.base64.Base64Dialect;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.util.CharsetUtil;
import io.netty.util.collection.CharObjectMap;
import java.util.Base64;

public class FrameSettingsClient
extends FrameSettings {
    private final Base64.Encoder urlEncoder;
    private final WsByteBuffer frameBuilt = this.buildFrameForWrite();
    private final ByteBuf frame;

    public FrameSettingsClient(int streamId, int headerTableSize, int enablePush, int maxConcurrentStreams, int initialWindowSize, int maxFrameSize, int maxHeaderListSize, boolean reserveBit) {
        super(streamId, headerTableSize, enablePush, maxConcurrentStreams, initialWindowSize, maxFrameSize, maxHeaderListSize, reserveBit);
        this.urlEncoder = java.util.Base64.getUrlEncoder();
        Http2Settings settings = new Http2Settings();
        int payloadLength = 6 * settings.size();
        this.frame = Unpooled.buffer((int)payloadLength);
        for (CharObjectMap.PrimitiveEntry entry : settings.entries()) {
            this.frame.writeChar((int)entry.key());
            this.frame.writeInt(((Long)entry.value()).intValue());
        }
    }

    public String getBase64UrlPayload() {
        return Base64.encode((ByteBuf)this.frame, (Base64Dialect)Base64Dialect.URL_SAFE).toString(CharsetUtil.UTF_8);
    }

    private byte[] payload() {
        return this.frameBuilt.array();
    }
}

