/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http2.test.frames;

import com.ibm.ws.http.channel.h2internal.frames.FramePushPromise;
import com.ibm.ws.http.channel.h2internal.hpack.H2HeaderField;
import com.ibm.ws.http2.test.helpers.HeaderEntry;
import java.util.ArrayList;
import java.util.List;

public class FramePushPromiseClient
extends FramePushPromise {
    private List<HeaderEntry> headerEntries = new ArrayList<HeaderEntry>();
    private List<H2HeaderField> headerFields = new ArrayList<H2HeaderField>();

    public FramePushPromiseClient(int streamId, byte[] headerBlockFragment, int promisedStream, int paddingLength, boolean endHeaders, boolean padded, boolean reserveBit) {
        super(streamId, headerBlockFragment, promisedStream, paddingLength, endHeaders, padded, reserveBit);
    }

    public List<HeaderEntry> getHeaderEntries() {
        return this.headerEntries;
    }

    public void setHeaderEntries(List<HeaderEntry> headerEntries) {
        this.headerEntries = headerEntries;
        this.headerFields = new ArrayList<H2HeaderField>();
        for (HeaderEntry headerEntry : headerEntries) {
            this.headerFields.add(headerEntry.getH2HeaderField());
        }
    }

    public void setHeaderFields(List<H2HeaderField> headerFields) {
        this.headerFields = headerFields;
    }

    public List<H2HeaderField> getHeaderFields() {
        return this.headerFields;
    }

    @Override
    public boolean equals(Object receivedFrame) {
        if (receivedFrame instanceof FramePushPromiseClient) {
            FramePushPromiseClient frameToCompare = (FramePushPromiseClient)receivedFrame;
            if (this.flagEndHeadersSet() != frameToCompare.flagEndHeadersSet()) {
                System.out.println("this.flagEndHeadersSet() = " + this.flagEndHeadersSet() + " frameToCompare.flagEndHeadersSet() = " + frameToCompare.flagEndHeadersSet());
                return false;
            }
            if (this.flagPaddedSet() != frameToCompare.flagPaddedSet()) {
                System.out.println("this.flagPaddedSet() = " + this.flagPaddedSet() + " frameToCompare.flagPaddedSet() = " + frameToCompare.flagPaddedSet());
                return false;
            }
            if (this.getFrameType() != frameToCompare.getFrameType()) {
                System.out.println("getFrameType is false");
                return false;
            }
            if (this.getFrameReserveBit() != frameToCompare.getFrameReserveBit()) {
                System.out.println("getFrameReserveBit is false");
                return false;
            }
            if (this.getStreamId() != frameToCompare.getStreamId()) {
                System.out.println("getStreamId is false");
                return false;
            }
            List<H2HeaderField> receivedHeaderFields = frameToCompare.getHeaderFields();
            for (H2HeaderField headerField : this.getHeaderFields()) {
                if (receivedHeaderFields.contains(headerField)) continue;
                System.out.println("headerField mismatch. headerField: " + headerField);
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder toString = new StringBuilder(super.toString());
        toString.append('\n');
        toString.append("Header fields: ").append('\n');
        for (H2HeaderField headerField : this.getHeaderFields()) {
            toString.append(" ").append(headerField).append('\n');
        }
        return toString.toString();
    }
}

