/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http2.test.frames;

import com.ibm.ws.http.channel.h2internal.frames.FrameGoAway;

public class FrameGoAwayClient
extends FrameGoAway {
    int[] expectedErrorCodes;
    int[] expectedStreamIds;

    public FrameGoAwayClient(int streamId, byte[] debugData, int[] errorCodes, int[] lastStreamIds) {
        super(streamId, debugData, errorCodes[0], lastStreamIds[0], false);
        this.expectedErrorCodes = errorCodes;
        this.expectedStreamIds = lastStreamIds;
    }

    private boolean isExpectedErrorCode(int code) {
        for (int i : this.expectedErrorCodes) {
            if (i != code) continue;
            return true;
        }
        return false;
    }

    private boolean isExpectedLastStreamId(int id) {
        for (int i : this.expectedStreamIds) {
            if (i != id) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object receivedFrame) {
        if (!(receivedFrame instanceof FrameGoAwayClient) || !(receivedFrame instanceof FrameGoAway)) {
            return false;
        }
        FrameGoAwayClient frameToCompare = (FrameGoAwayClient)receivedFrame;
        if (this.getFrameType() != frameToCompare.getFrameType()) {
            return false;
        }
        if (this.getFrameReserveBit() != frameToCompare.getFrameReserveBit()) {
            return false;
        }
        if (this.getStreamId() != frameToCompare.getStreamId()) {
            return false;
        }
        if (!this.isExpectedLastStreamId(frameToCompare.getLastStreamId())) {
            return false;
        }
        return this.isExpectedErrorCode(frameToCompare.getErrorCode());
    }
}

