/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http2.test.connection;

import com.ibm.ws.http.channel.h2internal.FrameReadProcessor;
import com.ibm.ws.http.channel.h2internal.FrameState;
import com.ibm.ws.http.channel.h2internal.FrameTypes;
import com.ibm.ws.http.channel.h2internal.H2ConnectionSettings;
import com.ibm.ws.http.channel.h2internal.exceptions.CompressionException;
import com.ibm.ws.http.channel.h2internal.exceptions.Http2Exception;
import com.ibm.ws.http.channel.h2internal.frames.Frame;
import com.ibm.ws.http.channel.h2internal.frames.FrameContinuation;
import com.ibm.ws.http.channel.h2internal.frames.FrameData;
import com.ibm.ws.http.channel.h2internal.frames.FrameGoAway;
import com.ibm.ws.http.channel.h2internal.frames.FrameHeaders;
import com.ibm.ws.http.channel.h2internal.frames.FramePing;
import com.ibm.ws.http.channel.h2internal.frames.FramePriority;
import com.ibm.ws.http.channel.h2internal.frames.FramePushPromise;
import com.ibm.ws.http.channel.h2internal.frames.FrameSettings;
import com.ibm.ws.http.channel.h2internal.frames.FrameWindowUpdate;
import com.ibm.ws.http2.test.CFWManager;
import com.ibm.ws.http2.test.H2StreamResult;
import com.ibm.ws.http2.test.H2StreamResultManager;
import com.ibm.ws.http2.test.connection.H2TCPReadCallback;
import com.ibm.ws.http2.test.exceptions.ConnectionNotClosedAfterGoAwayException;
import com.ibm.ws.http2.test.exceptions.ExpectedPushPromiseDoesNotIncludeLinkHeaderException;
import com.ibm.ws.http2.test.exceptions.ReceivedFrameAfterEndOfStream;
import com.ibm.ws.http2.test.exceptions.ReceivedHeadersFrameAfterEndOfHeaders;
import com.ibm.ws.http2.test.exceptions.ReceivedUnexpectedGoAwayExcetion;
import com.ibm.ws.http2.test.exceptions.UnexpectedUpgradeHeader;
import com.ibm.ws.http2.test.frames.FrameContinuationClient;
import com.ibm.ws.http2.test.frames.FrameDataClient;
import com.ibm.ws.http2.test.frames.FrameGoAwayClient;
import com.ibm.ws.http2.test.frames.FrameHeadersClient;
import com.ibm.ws.http2.test.frames.FramePushPromiseClient;
import com.ibm.ws.http2.test.helpers.H2HeadersUtils;
import com.ibm.ws.http2.test.listeners.FramesListener;
import com.ibm.ws.http2.test.utils;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.bytebuffer.WsByteBufferPoolManager;
import com.ibm.wsspi.bytebuffer.WsByteBufferUtils;
import com.ibm.wsspi.channelfw.OutboundVirtualConnection;
import com.ibm.wsspi.tcpchannel.TCPConnectRequestContext;
import com.ibm.wsspi.tcpchannel.TCPConnectRequestContextFactory;
import com.ibm.wsspi.tcpchannel.TCPConnectionContext;
import com.ibm.wsspi.tcpchannel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPReadRequestContext;
import com.ibm.wsspi.tcpchannel.TCPWriteRequestContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class H2Connection {
    private static CFWManager cfwManager = null;
    private WsByteBufferPoolManager bufferMgr = null;
    private TCPConnectRequestContextFactory tcpConnectFactory = null;
    private OutboundVirtualConnection outConn1 = null;
    private TCPConnectRequestContext outReqContext1 = null;
    private TCPConnectionContext outContext1 = null;
    private TCPReadRequestContext readConn = null;
    private TCPWriteRequestContext writeConn = null;
    private HTTP1_1Helper h1_1Helper = null;
    private H2TCPReadCallback h2TcpReadCallback = null;
    private FrameReadProcessor frameReadProcessor = null;
    private final H2StreamResultManager streamResultManager;
    private final H2HeadersUtils headerUtils = new H2HeadersUtils();
    private WsByteBuffer readBuffer = null;
    private WsByteBuffer slicedBuffer = null;
    private boolean server101ResponseReceived = false;
    private boolean serverFirstConnectReceived = false;
    private boolean prefaceSent = false;
    private boolean firstConnectSent = false;
    private final List<Exception> reportedExceptions = Collections.synchronizedList(new ArrayList());
    private int pendingBufferStop;
    private int pendingBufferStart;
    private WsByteBuffer[] myPendingBuffers = new WsByteBuffer[10];
    private final int PENDING_BUFFER_MIN_GROWTH_SIZE = 4;
    private final AtomicBoolean waitingForACK = new AtomicBoolean(false);
    private final FrameSettings ackSettingsFrame;
    private final AtomicBoolean closeCalled = new AtomicBoolean(false);
    private static String sendBackPriority1 = "SEND.BACK.PRIORITY.1";
    private static String sendBackWinUpdate1 = "SEND.BACK.WINDOW.UPDATE.1";
    private static String sendBackPing1 = "SEND.BACK.PING.1";
    private static final String CLASS_NAME = H2Connection.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME);

    public H2Connection(String hostName, int httpDefaultPort, FramesListener framesListener, CountDownLatch blockUntilConnectionIsDone) {
        cfwManager = new CFWManager();
        this.bufferMgr = CFWManager.getWsByteBufferPoolManager();
        this.tcpConnectFactory = cfwManager.getTCPConnectRequestContextFactory();
        this.h1_1Helper = new HTTP1_1Helper();
        this.outConn1 = cfwManager.createOutboundVirtualConnection();
        this.outReqContext1 = this.tcpConnectFactory.createTCPConnectRequestContext(hostName, httpDefaultPort, 28000);
        this.outContext1 = cfwManager.connectTCPOutbound(this.outConn1, this.outReqContext1);
        this.readConn = this.outContext1.getReadInterface();
        this.writeConn = this.outContext1.getWriteInterface();
        this.readBuffer = this.bufferMgr.allocate(4090);
        this.readConn.setBuffer(this.readBuffer);
        this.h2TcpReadCallback = new H2TCPReadCallback(this);
        this.frameReadProcessor = new FrameReadProcessor(null);
        this.frameReadProcessor.setFrameState(FrameState.INIT);
        this.streamResultManager = new H2StreamResultManager(this);
        this.streamResultManager.setFramesListener(framesListener);
        this.ackSettingsFrame = new FrameSettings();
        this.ackSettingsFrame.setAckFlag();
    }

    public synchronized long sendBytesSync(WsByteBuffer[] toSend) {
        return this.sendBytes(toSend);
    }

    private long sendBytes(WsByteBuffer[] toSend) {
        this.writeConn.setBuffers(toSend);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLASS_NAME, "sendBytes(WsByteBuffer[])", "Sending " + toSend.length + " buffers synchronously through connection " + this + ".");
        }
        long bytesWritten = 0L;
        try {
            bytesWritten = this.writeConn.write(-1L, 28000);
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.logp(Level.SEVERE, CLASS_NAME, "sendBytes(WsByteBuffer[])", "Unable to send bytes: ", e);
            }
            this.reportedExceptions.add(e);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLASS_NAME, "sendBytes(WsByteBuffer[])", bytesWritten + " bytes sent synchronously.");
        }
        this.writeConn.clearBuffers();
        return bytesWritten;
    }

    public synchronized long sendBytesSync(WsByteBuffer toSend) {
        return this.sendBytes(toSend);
    }

    private long sendBytes(WsByteBuffer toSend) {
        this.writeConn.setBuffer(toSend);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLASS_NAME, "sendBytes(WsByteBuffer)", "Sending " + toSend.limit() + " bytes synchronously through connection " + this + ".");
        }
        long bytesWritten = 0L;
        try {
            bytesWritten = this.writeConn.write(-1L, 28000);
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.logp(Level.SEVERE, CLASS_NAME, "sendBytes(WsByteBuffer)", "Unable to send bytes: ", e);
            }
            this.reportedExceptions.add(e);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLASS_NAME, "sendBytes(WsByteBuffer)", bytesWritten + " bytes sent synchronously.");
        }
        this.writeConn.clearBuffers();
        return bytesWritten;
    }

    public synchronized long sendBytesSync(byte[] toSend) {
        return this.sendBytes(toSend);
    }

    private long sendBytes(byte[] toSend) {
        WsByteBuffer writeBuffer = this.bufferMgr.allocate(toSend.length);
        writeBuffer.put(toSend);
        writeBuffer.position(0);
        writeBuffer.limit(toSend.length);
        this.writeConn.setBuffer(writeBuffer);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLASS_NAME, "sendBytes", "Sending " + toSend.length + " bytes synchronously through connection " + this + ".");
        }
        long bytesWritten = 0L;
        try {
            bytesWritten = this.writeConn.write(-1L, 28000);
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.logp(Level.SEVERE, CLASS_NAME, "sendBytes", "Unable to send bytes: ", e);
            }
            this.reportedExceptions.add(e);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLASS_NAME, "sendBytes", bytesWritten + " bytes sent synchronously.");
        }
        this.writeConn.clearBuffers();
        return bytesWritten;
    }

    public synchronized long sendFrame(Frame writableFrame) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLASS_NAME, "sendFrame", "Sending frame: (connection: " + this + ")");
            LOGGER.logp(Level.FINEST, CLASS_NAME, "sendFrame", ":Next Frame: :Writing Out: " + (Object)((Object)writableFrame.getFrameType()) + " H2Conn hc: " + this.hashCode() + " " + writableFrame.toString());
        }
        this.processFrame(writableFrame);
        try {
            writableFrame = this.streamResultManager.processFrame(writableFrame, true, false);
        }
        catch (CompressionException | IOException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.logp(Level.SEVERE, CLASS_NAME, "sendFrame", "Exception: ", e);
            }
            this.reportedExceptions.add(e);
        }
        if (this.wasServer101ResponseReceived() && this.wasServerFirstConnectReceived()) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.logp(Level.FINEST, CLASS_NAME, "sendFrame", "Writing frame synchronously.");
            }
            if (writableFrame instanceof FrameData || writableFrame instanceof FrameDataClient) {
                WsByteBuffer[] bufferArray = ((FrameData)writableFrame).buildFrameArrayForWrite();
                this.addToPendingByteBuffer(bufferArray, bufferArray.length);
            } else {
                this.addToPendingByteBuffer(writableFrame.buildFrameForWrite(), 1);
            }
            this.syncWrite();
            return -1L;
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLASS_NAME, "sendFrame", "Writing frame synchronously.");
        }
        return this.sendBytes(writableFrame.buildFrameForWrite());
    }

    public WsByteBuffer[] frameBytesToWsByteBuffer(byte[] frame) {
        WsByteBuffer[] frameByteBuffer = new WsByteBuffer[]{this.bufferMgr.allocate(frame.length)};
        WsByteBufferUtils.putByteArrayValue((WsByteBuffer[])frameByteBuffer, (byte[])frame, (boolean)true);
        return frameByteBuffer;
    }

    public long processRead(int timeout) {
        WsByteBuffer readBuffer = this.bufferMgr.allocate(4090);
        this.readConn.setBuffer(readBuffer);
        long bytesRead = 0L;
        try {
            bytesRead = this.readConn.read(1L, timeout);
        }
        catch (IOException e) {
            bytesRead = -1L;
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLASS_NAME, "processRead", "Reading synchronously. Bytes read: " + bytesRead);
        }
        return bytesRead;
    }

    public long processRead() {
        return this.processRead(28000);
    }

    public void startAsyncRead() {
        if (this.closeCalled.get()) {
            return;
        }
        if (this.slicedBuffer == null) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.logp(Level.FINEST, CLASS_NAME, "startAsyncRead", "Allocating a new buffer for and calling TCPChannel read");
            }
            WsByteBuffer readBuffer = this.bufferMgr.allocate(4090);
            this.readConn.setBuffer(readBuffer);
            this.readConn.read(1L, (TCPReadCompletedCallback)this.h2TcpReadCallback, true, 28000);
        } else {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.logp(Level.FINEST, CLASS_NAME, "startAsyncRead", "Using slice buffer and calling complete on the callback in connection " + this + ".");
            }
            this.slicedBuffer.position(this.slicedBuffer.limit());
            this.readConn.setBuffer(this.slicedBuffer);
            this.slicedBuffer = null;
            this.h2TcpReadCallback.complete(null, this.readConn);
        }
    }

    public synchronized void syncWrite() {
        WsByteBuffer[] writeBuffers = this.getBuffList();
        if (null != writeBuffers) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.logp(Level.FINEST, CLASS_NAME, "syncWrite", "Writing (sync) " + writeBuffers.length + " buffers in connection " + this + ".");
            }
            this.writeConn.setBuffers(writeBuffers);
            try {
                this.writeConn.write(-1L, 28000);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected WsByteBuffer[] getBuffList() {
        int size = this.pendingBufferStop - this.pendingBufferStart;
        if (0 == size) {
            return null;
        }
        WsByteBuffer[] list = new WsByteBuffer[size];
        System.arraycopy(this.myPendingBuffers, this.pendingBufferStart, list, 0, size);
        this.clearPendingByteBuffers();
        return list;
    }

    private void addToPendingByteBuffer(WsByteBuffer[] list, int length) {
        int newsize = this.pendingBufferStop + length;
        if (newsize >= this.myPendingBuffers.length) {
            if (length < 4) {
                newsize = this.myPendingBuffers.length + 4;
            }
            this.growPendingArray(newsize);
        }
        System.arraycopy(list, 0, this.myPendingBuffers, this.pendingBufferStop, length);
        this.pendingBufferStop += length;
    }

    private void addToPendingByteBuffer(WsByteBuffer buf, int length) {
        int newsize = this.pendingBufferStop + length;
        if (newsize >= this.myPendingBuffers.length) {
            if (length < 4) {
                newsize = this.myPendingBuffers.length + 4;
            }
            this.growPendingArray(newsize);
        }
        this.myPendingBuffers[this.pendingBufferStop] = buf;
        this.pendingBufferStop += length;
    }

    private void growPendingArray(int size) {
        WsByteBuffer[] tempNew = new WsByteBuffer[size];
        System.arraycopy(this.myPendingBuffers, 0, tempNew, 0, this.pendingBufferStop);
        this.myPendingBuffers = tempNew;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLASS_NAME, "growPendingArray", "Increased pending list to " + size);
        }
    }

    private void clearPendingByteBuffers() {
        for (int i = 0; i < this.pendingBufferStop; ++i) {
            this.myPendingBuffers[i] = null;
        }
        this.pendingBufferStart = 0;
        this.pendingBufferStop = 0;
    }

    public void processData() {
        this.processData(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processData(boolean readAfter) {
        WsByteBuffer currentBuffer = this.readConn.getBuffer();
        currentBuffer.flip();
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLASS_NAME, "processData", "There are " + currentBuffer.limit() + " bytes in this buffer (connection " + this + ").");
        }
        int frameReadStatus = 0;
        boolean server101ResponseReceived = this.wasServer101ResponseReceived();
        try {
            if (server101ResponseReceived) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.logp(Level.FINEST, CLASS_NAME, "processData", "currentBuffer hc: " + currentBuffer.hashCode() + " position: " + currentBuffer.position() + " limit: " + currentBuffer.limit());
                }
                frameReadStatus = this.processFrameAfter101Received(currentBuffer);
            } else {
                this.h1_1Helper.storeH1Response(currentBuffer);
            }
        }
        catch (Http2Exception | ReceivedFrameAfterEndOfStream | ReceivedHeadersFrameAfterEndOfHeaders | ReceivedUnexpectedGoAwayExcetion | UnexpectedUpgradeHeader | IOException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.logp(Level.SEVERE, CLASS_NAME, "processData", "Exception reported while processing frame: ", e);
            }
            this.reportedExceptions.add(e);
        }
        finally {
            if (server101ResponseReceived && frameReadStatus != -2) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.logp(Level.FINEST, CLASS_NAME, "processData", "Calling frameReadProcessor.reset(true) on frameReadProcessor: " + this.frameReadProcessor);
                }
                this.frameReadProcessor.reset(true);
            }
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLASS_NAME, "processData", "Calling startAsyncRead()");
        }
        if (readAfter) {
            this.startAsyncRead();
        }
    }

    private int processFrameAfter101Received(WsByteBuffer currentBuffer) throws IOException, ReceivedFrameAfterEndOfStream, ReceivedHeadersFrameAfterEndOfHeaders, ReceivedUnexpectedGoAwayExcetion, Http2Exception {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLASS_NAME, "processData", "currentBuffer hc: " + currentBuffer.hashCode() + " position: " + currentBuffer.position() + " limit: " + currentBuffer.limit());
        }
        int frameReadStatus = 0;
        frameReadStatus = this.frameReadProcessor.processNextBuffer(currentBuffer);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLASS_NAME, "processData", "after calling processNextBuffer, frameReadStatus: " + frameReadStatus);
        }
        if (frameReadStatus != -2) {
            Frame currentFrame = this.frameReadProcessor.getCurrentFrame();
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.logp(Level.FINEST, CLASS_NAME, "processData", "Processing frame object: currentFrame hc: " + currentFrame.hashCode() + " CurrentFrame toString: \n" + (Object)((Object)currentFrame.getFrameType()));
            }
            if (!this.wasServerFirstConnectReceived()) {
                if (currentFrame.getFrameType() == FrameTypes.SETTINGS) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.logp(Level.FINEST, CLASS_NAME, "processData", "Settings frame received for the first time.");
                    }
                    this.setServerFirstConnectReceived(true);
                } else {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.logp(Level.SEVERE, CLASS_NAME, "processData", "The first frame sent by the server was not a Settings frame.");
                    }
                    this.reportedExceptions.add(new Exception("The first frame sent by the server was not a Settings frame."));
                }
            }
            currentFrame.processPayload(this.frameReadProcessor);
            currentFrame.validate(new H2ConnectionSettings());
            if (frameReadStatus > 0) {
                this.slicedBuffer = currentBuffer.slice();
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.logp(Level.FINEST, CLASS_NAME, "processData", "Buffer has been sliced, it has " + this.slicedBuffer.limit() + " bytes.");
                }
            }
            this.processFrame(currentFrame);
            this.streamResultManager.addResponseFrame(currentFrame);
            this.testFrameForSendBack(currentFrame);
        }
        return frameReadStatus;
    }

    private void testFrameForSendBack(Frame f) {
        if (f.getFrameType() == FrameTypes.DATA) {
            int streamId;
            FrameData fd = (FrameData)f;
            String s = new String(fd.getData());
            if (s.compareTo(sendBackPriority1) == 0) {
                System.out.println("FOUND: " + sendBackPriority1);
                streamId = fd.getStreamId();
                int streamDep = 0;
                int weight = 64;
                boolean exclusive = false;
                boolean reserveBit = false;
                FramePriority fp = new FramePriority(streamId, streamDep, weight, exclusive, reserveBit);
                this.sendBytes(fp.buildFrameForWrite());
            }
            if (s.contains(sendBackWinUpdate1)) {
                streamId = fd.getStreamId();
                int windowSizeIncrement = 10240;
                boolean reserveBit = false;
                FrameWindowUpdate fw = new FrameWindowUpdate(streamId, windowSizeIncrement, reserveBit);
                LOGGER.logp(Level.FINEST, CLASS_NAME, "testFrameForSendBack", ":Next Frame: :Writing Out: " + (Object)((Object)fw.getFrameType()) + " H2Conn hc: " + this.hashCode() + " " + fw.toString());
                this.sendBytes(fw.buildFrameForWrite());
            }
            if (s.contains(sendBackPing1)) {
                System.out.println("FOUND: " + sendBackPing1);
                streamId = 0;
                FramePing fp = new FramePing(streamId, null, false);
                LOGGER.logp(Level.FINEST, CLASS_NAME, "testFrameForSendBack", ":Next Frame: :Writing Out: " + (Object)((Object)fp.getFrameType()) + " H2Conn hc: " + this.hashCode() + " " + fp.toString());
                this.sendBytes(fp.buildFrameForWrite());
            }
        }
    }

    private void processFrame(Frame frameToProcess) {
        if (frameToProcess.isWriteFrame()) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.logp(Level.FINEST, CLASS_NAME, "processFrame", "Processing sent frame: " + (Object)((Object)frameToProcess.getFrameType()));
            }
            if (frameToProcess.getFrameType() == FrameTypes.GOAWAY && LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.logp(Level.FINEST, CLASS_NAME, "processFrame", "GoAway frame sent.");
            }
        } else if (frameToProcess.getFrameType() == FrameTypes.SETTINGS) {
            if (frameToProcess.flagAckSet()) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.logp(Level.FINEST, CLASS_NAME, "processFrame", "Received a Settings frame with ack flag on.");
                }
            } else {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.logp(Level.FINEST, CLASS_NAME, "processFrame", "Received a Settings frame with ack flag off. Sending ack settings frame.");
                }
                int count = 0;
                while (!this.getFirstConnectSent() && count < 50) {
                    ++count;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {}
                }
                this.sendFrame(this.ackSettingsFrame);
            }
        }
    }

    public Frame frameConverter(Frame frameToConvert) throws CompressionException, IOException {
        return this.frameConverter(frameToConvert, false);
    }

    public Frame frameConverter(Frame frameToConvert, boolean isExpectedFrame) throws CompressionException, IOException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLASS_NAME, "processFrame", "framerToConvert.getClass(): " + frameToConvert.getClass());
        }
        if (!isExpectedFrame) {
            if (frameToConvert.getClass().isAssignableFrom(FrameGoAway.class)) {
                FrameGoAway frameGoawayToConvert = (FrameGoAway)frameToConvert;
                FrameGoAwayClient goAway = new FrameGoAwayClient(frameGoawayToConvert.getStreamId(), frameGoawayToConvert.getDebugData(), new int[]{frameGoawayToConvert.getErrorCode()}, new int[]{frameGoawayToConvert.getLastStreamId()});
                return goAway;
            }
            if (frameToConvert.getClass().isAssignableFrom(FrameHeaders.class)) {
                FrameHeaders frameHeadersToConvert = (FrameHeaders)frameToConvert;
                byte[] headerBlockFragment = frameHeadersToConvert.getHeaderBlockFragment();
                FrameHeadersClient testFrameHeaders = new FrameHeadersClient(frameHeadersToConvert.getStreamId(), headerBlockFragment, frameHeadersToConvert.getStreamDependency(), frameHeadersToConvert.getPaddingLength(), frameHeadersToConvert.getWeight(), frameHeadersToConvert.flagEndStreamSet(), frameHeadersToConvert.flagEndHeadersSet(), frameHeadersToConvert.flagPaddingSet(), frameHeadersToConvert.flagPrioritySet(), frameHeadersToConvert.isExclusive(), frameHeadersToConvert.getFrameReserveBit());
                testFrameHeaders.setHeaderFields(this.getHeadersUtils().decodeHeaders(headerBlockFragment));
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.logp(Level.FINEST, CLASS_NAME, "processFrame", "testFrameHeaders: " + testFrameHeaders);
                }
                return testFrameHeaders;
            }
            if (frameToConvert.getClass().isAssignableFrom(FrameHeadersClient.class)) {
                FrameHeadersClient frameHeadersToConvert = (FrameHeadersClient)frameToConvert;
                byte[] headerBlockFragment = this.getHeadersUtils().encodeHeaders(frameHeadersToConvert.getHeaderEntries());
                FrameHeaders internalFrameHeadersToConvert = new FrameHeaders(frameHeadersToConvert.getStreamId(), headerBlockFragment, frameHeadersToConvert.getStreamDependency(), frameHeadersToConvert.getPaddingLength(), frameHeadersToConvert.getWeight(), frameHeadersToConvert.flagEndStreamSet(), frameHeadersToConvert.flagEndHeadersSet(), frameHeadersToConvert.flagPaddingSet(), frameHeadersToConvert.flagPrioritySet(), frameHeadersToConvert.isExclusive(), frameHeadersToConvert.getFrameReserveBit());
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.logp(Level.FINEST, CLASS_NAME, "processFrame", "internalFrameHeadersToConvert: " + internalFrameHeadersToConvert);
                }
                return internalFrameHeadersToConvert;
            }
            if (frameToConvert.getClass().isAssignableFrom(FrameContinuation.class)) {
                FrameContinuation frameContinuationToConvert = (FrameContinuation)frameToConvert;
                byte[] headerBlockFragment = frameContinuationToConvert.getHeaderBlockFragment();
                FrameContinuationClient testFrameContinuation = new FrameContinuationClient(frameContinuationToConvert.getStreamId(), headerBlockFragment, frameContinuationToConvert.flagEndHeadersSet(), frameContinuationToConvert.flagEndStreamSet(), frameContinuationToConvert.getFrameReserveBit());
                testFrameContinuation.setHeaderFields(this.getHeadersUtils().decodeHeaders(headerBlockFragment));
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.logp(Level.FINEST, CLASS_NAME, "processFrame", "testFrameContinuation: " + testFrameContinuation);
                }
                return testFrameContinuation;
            }
            if (frameToConvert.getClass().isAssignableFrom(FrameContinuationClient.class)) {
                FrameContinuationClient frameContinuationToConvert = (FrameContinuationClient)frameToConvert;
                byte[] headerBlockFragment = this.getHeadersUtils().encodeHeaders(frameContinuationToConvert.getHeaderEntries());
                FrameContinuation internalFrameContinuationToConvert = new FrameContinuation(frameContinuationToConvert.getStreamId(), headerBlockFragment, frameContinuationToConvert.flagEndHeadersSet(), frameContinuationToConvert.flagEndStreamSet(), frameContinuationToConvert.getFrameReserveBit());
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.logp(Level.FINEST, CLASS_NAME, "processFrame", "internalFrameContinuationToConvert: " + internalFrameContinuationToConvert);
                }
                return internalFrameContinuationToConvert;
            }
            if (frameToConvert.getClass().isAssignableFrom(FramePushPromise.class)) {
                FramePushPromise frameContinuationToConvert = (FramePushPromise)frameToConvert;
                byte[] headerBlockFragment = frameContinuationToConvert.getHeaderBlockFragment();
                FramePushPromiseClient testFramePushPromise = new FramePushPromiseClient(frameContinuationToConvert.getStreamId(), headerBlockFragment, frameContinuationToConvert.getPromisedStreamId(), frameContinuationToConvert.getPaddingLength(), frameContinuationToConvert.flagEndHeadersSet(), frameContinuationToConvert.flagPaddedSet(), frameContinuationToConvert.getFrameReserveBit());
                testFramePushPromise.setHeaderFields(this.getHeadersUtils().decodeHeaders(headerBlockFragment));
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.logp(Level.FINEST, CLASS_NAME, "processFrame", "testFramePushPromise: " + testFramePushPromise);
                }
                return testFramePushPromise;
            }
            if (frameToConvert.getClass().isAssignableFrom(FrameData.class)) {
                FrameData frameDataToConvert = (FrameData)frameToConvert;
                FrameDataClient testFrameData = new FrameDataClient(frameDataToConvert.getStreamId(), frameDataToConvert.getData(), frameDataToConvert.getPaddingLength(), frameDataToConvert.flagEndStreamSet(), frameDataToConvert.flagPaddedSet(), frameDataToConvert.getFrameReserveBit());
                if (LOGGER.isLoggable(Level.FINEST)) {
                    FrameDataClient fd;
                    String s;
                    if (testFrameData.getFrameType() == FrameTypes.DATA && (s = new String((fd = testFrameData).getData())).toLowerCase().contains("donotadd")) {
                        LOGGER.logp(Level.FINEST, CLASS_NAME, "processFrame", "testFrameData: DoNotAdd Data Frame");
                        return testFrameData;
                    }
                    LOGGER.logp(Level.FINEST, CLASS_NAME, "processFrame", "testFrameData: " + (Object)((Object)testFrameData.getFrameType()));
                }
                return testFrameData;
            }
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLASS_NAME, "processFrame", "We didn't convert frame: " + (Object)((Object)frameToConvert.getFrameType()));
        }
        return frameToConvert;
    }

    public void close() {
        this.closeCalled.set(true);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLASS_NAME, "processFrame", "Connection close() called in connection " + this + ".");
        }
        this.reportedExceptions.addAll(this.streamResultManager.compareAllStreamResults());
        if (this.processRead(1000) >= 0L) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.logp(Level.FINEST, CLASS_NAME, "processFrame", "Server has not closed the connection yet. Checking again in 2 seconds.");
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.processRead(1000) >= 0L) {
            this.reportedExceptions.add(new ConnectionNotClosedAfterGoAwayException("Connection has not been closed by the server after it sent GOAWAY frame"));
        }
        this.outConn1.close(null);
    }

    public boolean wasServer101ResponseReceived() {
        return this.server101ResponseReceived;
    }

    public void setServer101ResponseReceived(boolean received) {
        this.server101ResponseReceived = received;
    }

    public void setPrefaceSent(boolean x) {
        this.prefaceSent = true;
    }

    public boolean getPrefaceSent() {
        return this.prefaceSent;
    }

    public void setFirstConnectSent(boolean x) {
        this.firstConnectSent = true;
    }

    public boolean getFirstConnectSent() {
        return this.firstConnectSent;
    }

    public boolean wasServerFirstConnectReceived() {
        return this.serverFirstConnectReceived;
    }

    public void setServerFirstConnectReceived(boolean received) {
        this.serverFirstConnectReceived = received;
    }

    public boolean isClosedCalled() {
        return this.closeCalled.get();
    }

    public void addExpectedFrames(ArrayList<Frame> frames) throws CompressionException, IOException, ExpectedPushPromiseDoesNotIncludeLinkHeaderException {
        this.streamResultManager.addExpectedFrames(frames);
    }

    public H2StreamResult addExpectedFrame(Frame frame) throws CompressionException, IOException, ExpectedPushPromiseDoesNotIncludeLinkHeaderException {
        return this.streamResultManager.addExpectedFrame(frame);
    }

    public H2StreamResult addExpectedFrame(FrameTypes type, int stream) throws CompressionException, IOException, ExpectedPushPromiseDoesNotIncludeLinkHeaderException {
        return this.streamResultManager.addExpectedFrame(type, stream);
    }

    public H2HeadersUtils getHeadersUtils() {
        return this.headerUtils;
    }

    public List<Exception> getReportedExceptions() {
        return this.reportedExceptions;
    }

    public boolean didFrameArrive(Frame expectedFrame) {
        return this.streamResultManager.didframeArrive(expectedFrame);
    }

    public boolean receivedAllFrames() {
        return this.streamResultManager.receivedAllFrames();
    }

    public AtomicBoolean getWaitingForACK() {
        return this.waitingForACK;
    }

    private class HTTP1_1Helper {
        StringBuilder response = new StringBuilder();

        private HTTP1_1Helper() {
        }

        public void storeH1Response(WsByteBuffer buffer) throws UnexpectedUpgradeHeader {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.logp(Level.FINEST, CLASS_NAME, "processFrame", "HTTP 1.1 read: " + utils.printByteArrayWithHex(buffer.array(), buffer.limit()));
            }
            this.response.append(utils.printByteArrayWithHex(buffer.array(), buffer.limit()));
            this.checkResponseHeaders(this.response.toString(), buffer);
        }

        private void checkResponseHeaders(String responseHeaders, WsByteBuffer originalBuffer) throws UnexpectedUpgradeHeader {
            boolean additionalDataFound = false;
            if (responseHeaders.contains("<CR>\n<LF><CR>\n<LF>")) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.logp(Level.FINEST, CLASS_NAME, "processFrame", "Original HTTP 1.1 response read: " + responseHeaders);
                }
                additionalDataFound = responseHeaders.split("<CR>\\n<LF><CR>\\n<LF>").length > 1;
                responseHeaders = responseHeaders.substring(0, responseHeaders.indexOf("<CR>\n<LF><CR>\n<LF>") + "<CR>\n<LF><CR>\n<LF>".length());
                String[] headerNamesAndValues = responseHeaders.split("<CR>\n<LF>");
                boolean switchingProtocols = false;
                boolean upgradeH2c = false;
                boolean connectionUpgrade = false;
                for (String header_value : headerNamesAndValues) {
                    if (header_value.equalsIgnoreCase("HTTP/1.1 101 Switching Protocols")) {
                        switchingProtocols = true;
                        continue;
                    }
                    if (header_value.equalsIgnoreCase("Upgrade: h2c")) {
                        upgradeH2c = true;
                        continue;
                    }
                    if (!header_value.equalsIgnoreCase("Connection: Upgrade")) continue;
                    connectionUpgrade = true;
                }
                if (switchingProtocols && upgradeH2c && connectionUpgrade) {
                    H2Connection.this.setServer101ResponseReceived(true);
                    if (additionalDataFound) {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.logp(Level.FINEST, CLASS_NAME, "processFrame", "Additional data read with HTTP 1.1 upgrade response. Handing over to continue H2C processing.");
                        }
                        int lengthRead = responseHeaders.replaceAll("<CR>", " ").replaceAll("<LF>", "").length();
                        byte[] arr = originalBuffer.array();
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.logp(Level.FINEST, CLASS_NAME, "processFrame", "Length read: " + lengthRead);
                            LOGGER.logp(Level.FINEST, CLASS_NAME, "processFrame", "Buffer length: " + originalBuffer.limit());
                        }
                        byte[] leftOverData = new byte[originalBuffer.limit() - lengthRead];
                        int index = 0;
                        while (lengthRead < originalBuffer.limit()) {
                            leftOverData[index] = arr[lengthRead];
                            ++lengthRead;
                            ++index;
                        }
                        WsByteBuffer remainingBuff = H2Connection.this.bufferMgr.wrap(leftOverData);
                        remainingBuff.position(leftOverData.length);
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.logp(Level.FINEST, CLASS_NAME, "processFrame", "Remaining byte array to handle: " + Arrays.toString(remainingBuff.array()));
                        }
                        H2Connection.this.readConn.setBuffer(remainingBuff);
                        if (!H2Connection.this.isClosedCalled()) {
                            H2Connection.this.processData(false);
                        } else if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.logp(Level.FINEST, CLASS_NAME, "processFrame", "Got additional data in buffer while a closed was called. Will not do any further processing.");
                        }
                    }
                } else {
                    throw new UnexpectedUpgradeHeader(responseHeaders);
                }
            }
        }
    }
}

