/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http2.test;

import com.ibm.ws.http.channel.h2internal.FrameTypes;
import com.ibm.ws.http.channel.h2internal.exceptions.CompressionException;
import com.ibm.ws.http.channel.h2internal.frames.Frame;
import com.ibm.ws.http.channel.h2internal.frames.FrameData;
import com.ibm.ws.http.channel.h2internal.frames.FrameGoAway;
import com.ibm.ws.http.channel.h2internal.frames.FrameSettings;
import com.ibm.ws.http2.test.H2StreamResult;
import com.ibm.ws.http2.test.connection.H2Connection;
import com.ibm.ws.http2.test.exceptions.ClientPrefaceTimeoutException;
import com.ibm.ws.http2.test.exceptions.ExpectedPushPromiseDoesNotIncludeLinkHeaderException;
import com.ibm.ws.http2.test.exceptions.FATTimeoutException;
import com.ibm.ws.http2.test.exceptions.ReceivedFrameAfterEndOfStream;
import com.ibm.ws.http2.test.exceptions.StreamDidNotReceivedEndOfStreamException;
import com.ibm.ws.http2.test.exceptions.UnableToSendFrameException;
import com.ibm.ws.http2.test.frames.FramePushPromiseClient;
import com.ibm.ws.http2.test.frames.FrameSettingsClient;
import com.ibm.ws.http2.test.helpers.HTTPUtils;
import com.ibm.ws.http2.test.listeners.FramesListener;
import com.ibm.ws.http2.test.listeners.PushPromiseListener;
import com.ibm.ws.http2.test.utils;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Http2Client {
    private H2Connection h2Connection = null;
    private final String hostName;
    private final int httpDefaultPort;
    private final long defaultTimeOutToSendFrame;
    private final CountDownLatch blockUntilConnectionIsDone;
    private final AtomicBoolean isTestDone = new AtomicBoolean(false);
    private final AtomicBoolean didTimeout = new AtomicBoolean(false);
    static final AtomicBoolean lockWaitFor = new AtomicBoolean(false);
    private boolean allowFramesAfterEndOfStream = false;
    private boolean receivedExpectedGoAway = false;
    private boolean waitForAck = true;
    private static final long DEFAULT_TEST_TIMEOUT = 120000L;
    private final Map<Frame, Frame> sendFrameConditional = new HashMap<Frame, Frame>();
    private final List<AbstractMap.SimpleEntry<Frame, Frame>> sendFrameConditionalList = new LinkedList<AbstractMap.SimpleEntry<Frame, Frame>>();
    private PushPromiseListener pushPromiseListener;
    private static final String CLASS_NAME = Http2Client.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME);

    public Http2Client(String hostName, int httpDefaultPort, CountDownLatch blockUntilConnectionIsDone, long defaultTimeOutToSendFrame, long defaultTestTimeOut) {
        this.hostName = hostName;
        this.httpDefaultPort = httpDefaultPort;
        this.blockUntilConnectionIsDone = blockUntilConnectionIsDone;
        this.defaultTimeOutToSendFrame = defaultTimeOutToSendFrame;
        FATFramesListener framesListener = new FATFramesListener();
        this.h2Connection = new H2Connection(this.hostName, this.httpDefaultPort, framesListener, blockUntilConnectionIsDone);
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.logp(Level.INFO, CLASS_NAME, "constructor", "Client " + this + " bound to connection " + this.h2Connection);
        }
        this.h2Connection.startAsyncRead();
        TimeoutHelper timeoutHelper = new TimeoutHelper(blockUntilConnectionIsDone, defaultTestTimeOut);
        timeoutHelper.setPriority(1);
        timeoutHelper.start();
    }

    public Http2Client(String hostName, int httpDefaultPort, CountDownLatch blockUntilConnectionIsDone, long defaultTimeOutToSendFrame) {
        this(hostName, httpDefaultPort, blockUntilConnectionIsDone, defaultTimeOutToSendFrame, 120000L);
    }

    public Http2Client(String hostName, int httpDefaultPort, CountDownLatch blockUntilConnectionIsDone, long defaultTimeOutToSendFrame, boolean useHttp2WithPriorKnowledge) {
        this(hostName, httpDefaultPort, blockUntilConnectionIsDone, defaultTimeOutToSendFrame);
        if (useHttp2WithPriorKnowledge) {
            this.h2Connection.setServer101ResponseReceived(true);
        }
    }

    public void doNotWaitForAck() {
        this.waitForAck = false;
    }

    public void setPushPromiseListener(PushPromiseListener listener) {
        this.pushPromiseListener = listener;
    }

    public void sendUpgradeHeader(String requestUri) {
        this.sendUpgradeHeader(requestUri, HTTPUtils.HTTPMethod.GET, null);
    }

    public void sendUpgradeHeader(String requestUri, HTTPUtils.HTTPMethod httpMethod) {
        this.sendUpgradeHeader(requestUri, httpMethod, null);
    }

    public void sendUpgradeHeader(String requestUri, HTTPUtils.HTTPMethod httpMethod, String body) {
        this.sendUpgradeHeader(requestUri, httpMethod, body, new FrameSettingsClient(-1, -1, -1, -1, -1, -1, -1, false));
    }

    public void sendUpgradeHeader(String requestUri, HTTPUtils.HTTPMethod httpMethod, String body, FrameSettingsClient settingsFrame) {
        String h1_upgradeHeader = new String(httpMethod.name() + " " + requestUri + " HTTP/1.1\r\nHost: " + this.hostName + ":" + this.httpDefaultPort + "\r\nContent-Length: " + (body == null ? "0" : Integer.valueOf(body.length())) + "\r\nConnection: Upgrade, HTTP2-Settings\r\nUpgrade: h2c\r\nHTTP2-Settings: " + settingsFrame.getBase64UrlPayload() + "\r\n\r\n");
        if (body != null && !body.isEmpty()) {
            h1_upgradeHeader = h1_upgradeHeader + body;
        }
        byte[] toSend = h1_upgradeHeader.getBytes();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.logp(Level.INFO, CLASS_NAME, "sendUpgradeHeader", "Sending upgrade header (size: " + toSend.length + " bytes)= " + h1_upgradeHeader);
        }
        long bytesWritten = 0L;
        bytesWritten = this.h2Connection.sendBytesSync(toSend);
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.logp(Level.INFO, CLASS_NAME, "sendUpgradeHeader", "Bytes sent: " + bytesWritten);
        }
    }

    private void sendClientPreface() {
        long bytesWritten = this.sendClientPreface(utils.CLIENT_PREFACE_STRING_IN_BYTES);
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.logp(Level.INFO, CLASS_NAME, "sendClientPreface", "Sending client preface (size: " + utils.CLIENT_PREFACE_STRING_IN_BYTES.length + " bytes)= " + bytesWritten);
        }
    }

    private long sendClientPreface(byte[] magicString) {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.logp(Level.INFO, CLASS_NAME, "sendClientPreface", ":Next Frame: :Writing Out: Magic Preface H2Conn hc: " + this.h2Connection.hashCode() + " size: " + magicString.length);
        }
        long bytesWritten = this.h2Connection.sendBytesSync(magicString);
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.logp(Level.INFO, CLASS_NAME, "sendClientPreface", "bytes written: " + bytesWritten);
        }
        return bytesWritten;
    }

    public void sendBytes(byte[] bytes) {
        long bytesWritten = this.h2Connection.sendBytesSync(bytes);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLASS_NAME, "sendBytes", "Sending bytes (size: " + bytes.length + " bytes written)= " + bytesWritten);
        }
    }

    public void sendBytes(WsByteBuffer bytes) {
        long bytesWritten = this.h2Connection.sendBytesSync(bytes);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLASS_NAME, "sendBytes", "Sending bytes (size: " + bytes.limit() + " bytes written)= " + bytesWritten);
        }
    }

    public void sendClientPreface(long timeout) throws ClientPrefaceTimeoutException {
        long startTime = System.currentTimeMillis();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.logp(Level.INFO, CLASS_NAME, "sendClientPreface", "Sending client preface with timeout of: " + timeout);
            LOGGER.logp(Level.INFO, CLASS_NAME, "sendClientPreface", "Start time (Millis): " + startTime);
        }
        while (System.currentTimeMillis() - startTime < timeout) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.wasUpgradeHeaderReceived()) {
                this.sendClientPreface();
                this.h2Connection.setPrefaceSent(true);
                return;
            }
            if (!LOGGER.isLoggable(Level.INFO)) continue;
            LOGGER.logp(Level.INFO, CLASS_NAME, "sendClientPreface", "Haven't received upgrade header yet, waiting to send client preface.");
        }
        if (LOGGER.isLoggable(Level.SEVERE)) {
            LOGGER.logp(Level.SEVERE, CLASS_NAME, "sendClientPreface", "Unable to send client preface before timing out. Current time (Millis): " + System.currentTimeMillis());
        }
        throw new ClientPrefaceTimeoutException("Timed out while waiting for 101 Response of the server; therefore the client preface was not sent.");
    }

    public void sendClientPreface(String magicString) throws ClientPrefaceTimeoutException {
        long startTime = System.currentTimeMillis();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.logp(Level.INFO, CLASS_NAME, "sendClientPreface", "Sending client with timeout of: " + this.defaultTimeOutToSendFrame);
            LOGGER.logp(Level.INFO, CLASS_NAME, "sendClientPreface", "Start time (Millis): " + startTime);
        }
        while (System.currentTimeMillis() - startTime < this.defaultTimeOutToSendFrame) {
            if (this.wasUpgradeHeaderReceived()) {
                this.sendClientPreface(magicString.getBytes());
                return;
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        if (LOGGER.isLoggable(Level.SEVERE)) {
            LOGGER.logp(Level.SEVERE, CLASS_NAME, "sendClientPreface", "Unable to send client preface before timing out. Current time (Millis): " + System.currentTimeMillis());
        }
        throw new ClientPrefaceTimeoutException("Timed out while waiting for 101 Response of the server; therefore the client preface was not sent.");
    }

    public void sendClientPrefaceFollowedBySettingsFrame(FrameSettings settingsFrame) throws ClientPrefaceTimeoutException {
        this.sendClientPrefaceFollowedBySettingsFrame(settingsFrame, this.defaultTimeOutToSendFrame);
    }

    public void sendClientPrefaceFollowedBySettingsFrame(FrameSettings settingsFrame, long timeout) throws ClientPrefaceTimeoutException {
        block2: {
            this.sendClientPreface(timeout);
            try {
                this.sendFrame(settingsFrame, 0L, true);
                this.h2Connection.setFirstConnectSent(true);
            }
            catch (UnableToSendFrameException e) {
                if (!LOGGER.isLoggable(Level.INFO)) break block2;
                LOGGER.logp(Level.INFO, CLASS_NAME, "sendClientPreface", "caught exception: " + e);
            }
        }
    }

    public long sendFrame(Frame writableFrame) throws UnableToSendFrameException {
        return this.sendFrame(writableFrame, false);
    }

    public long sendFrame(Frame writableFrame, boolean forced) throws UnableToSendFrameException {
        if (!forced) {
            return this.sendFrame(writableFrame, this.defaultTimeOutToSendFrame, false);
        }
        if (writableFrame instanceof FrameData) {
            WsByteBuffer[] bufferArray = ((FrameData)writableFrame).buildFrameArrayForWrite();
            return this.h2Connection.sendBytesSync(bufferArray);
        }
        return this.h2Connection.sendBytesSync(writableFrame.buildFrameForWrite());
    }

    public void sendClientPrefaceFollowedBySettingsBytes(byte[] bytes, long timeout) throws ClientPrefaceTimeoutException {
        block2: {
            this.sendClientPreface(timeout);
            try {
                this.sendBytesAfterPreface(bytes, timeout, true);
                this.h2Connection.setFirstConnectSent(true);
            }
            catch (UnableToSendFrameException e) {
                if (!LOGGER.isLoggable(Level.INFO)) break block2;
                LOGGER.logp(Level.INFO, CLASS_NAME, "sendClientPreface", "caught exception: " + e);
            }
        }
    }

    public long sendBytesAfterPreface(byte[] bytes) throws UnableToSendFrameException {
        return this.sendBytesAfterPreface(bytes, this.defaultTimeOutToSendFrame, false);
    }

    public long sendBytesAfterPreface(byte[] bytes, long timeout, boolean bypassPreface) throws UnableToSendFrameException {
        long startTime = System.currentTimeMillis();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.logp(Level.INFO, CLASS_NAME, "sendBytesAfterPreface", "Sending bytes with timeout of: " + timeout);
            LOGGER.logp(Level.INFO, CLASS_NAME, "sendBytesAfterPreface", "Start time (Millis): " + startTime);
        }
        do {
            if ((this.wasUpgradeHeaderReceived() && this.wasServerPrefaceReceived() || bypassPreface) && !this.h2Connection.getWaitingForACK().get()) {
                return this.h2Connection.sendBytesSync(bytes);
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (System.currentTimeMillis() - startTime < timeout);
        if (LOGGER.isLoggable(Level.SEVERE)) {
            LOGGER.logp(Level.SEVERE, CLASS_NAME, "sendBytesAfterPreface", "Unable to send bytes before timing out. Current time (Millis): " + System.currentTimeMillis());
            LOGGER.logp(Level.SEVERE, CLASS_NAME, "sendBytesAfterPreface", "wasUpgradeHeaderReceived? " + this.wasUpgradeHeaderReceived());
            LOGGER.logp(Level.SEVERE, CLASS_NAME, "sendBytesAfterPreface", "wasServerPrefaceReceived? " + this.wasServerPrefaceReceived());
        }
        if (this.wasUpgradeHeaderReceived() && this.wasServerPrefaceReceived() && !this.h2Connection.getWaitingForACK().get()) {
            return this.h2Connection.sendBytesSync(bytes);
        }
        throw new UnableToSendFrameException("Unable to send bytes because upgrade header and server preface have not been received yet. wasUpgradeHeaderReceived() = " + this.wasUpgradeHeaderReceived() + " wasServerPrefaceReceived() = " + this.wasServerPrefaceReceived() + " bytes = " + bytes);
    }

    private long sendFrame(Frame writableFrame, long timeout, boolean bypassPreface) throws UnableToSendFrameException {
        long startTime = System.currentTimeMillis();
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLASS_NAME, "sendFrame", "Sending frame with timeout of: " + timeout);
            LOGGER.logp(Level.FINEST, CLASS_NAME, "sendFrame", "Start time (Millis): " + startTime);
        }
        do {
            if ((this.wasUpgradeHeaderReceived() && this.wasServerPrefaceReceived() || bypassPreface) && !this.h2Connection.getWaitingForACK().get()) {
                return this.h2Connection.sendFrame(writableFrame);
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (System.currentTimeMillis() - startTime < timeout);
        if (LOGGER.isLoggable(Level.SEVERE)) {
            LOGGER.logp(Level.SEVERE, CLASS_NAME, "sendFrame", "Unable to send frame before timing out. Current time (Millis): " + System.currentTimeMillis());
            LOGGER.logp(Level.SEVERE, CLASS_NAME, "sendFrame", "wasUpgradeHeaderReceived? " + this.wasUpgradeHeaderReceived());
            LOGGER.logp(Level.SEVERE, CLASS_NAME, "sendFrame", "wasServerPrefaceReceived? " + this.wasServerPrefaceReceived());
            LOGGER.logp(Level.SEVERE, CLASS_NAME, "sendFrame", "bypassPreface? " + bypassPreface);
        }
        if ((this.wasUpgradeHeaderReceived() && this.wasServerPrefaceReceived() || bypassPreface) && !this.h2Connection.getWaitingForACK().get()) {
            return this.h2Connection.sendFrame(writableFrame);
        }
        throw new UnableToSendFrameException("Unable to send frame because upgrade header and server preface have not been received yet. wasUpgradeHeaderReceived() = " + this.wasUpgradeHeaderReceived() + " wasServerPrefaceReceived() = " + this.wasServerPrefaceReceived() + " Frame = " + writableFrame);
    }

    public Http2Client waitFor(Frame expectedFrame) {
        lockWaitFor.set(true);
        do {
            LOGGER.logp(Level.FINEST, CLASS_NAME, "waitFor", "Waiting for frame: " + expectedFrame);
            if (this.h2Connection.didFrameArrive(expectedFrame)) {
                LOGGER.logp(Level.FINEST, CLASS_NAME, "waitFor", "Found matching frame for: " + expectedFrame);
                lockWaitFor.set(false);
                if (this.h2Connection.receivedAllFrames()) {
                    this.isTestDone.set(true);
                }
                return this;
            }
            LOGGER.logp(Level.FINEST, CLASS_NAME, "waitFor", "looping");
            try {
                Thread.sleep(100L);
            }
            catch (Exception x) {
                LOGGER.logp(Level.FINEST, CLASS_NAME, "waitFor", "Caught exception while looping. Finishing");
                x.printStackTrace();
                lockWaitFor.set(false);
            }
        } while (lockWaitFor.get() && !this.didTimeout.get());
        lockWaitFor.set(false);
        return this;
    }

    public synchronized void sendUponArrivalCondition(Frame waitForFrame, Frame frameToSend) throws UnableToSendFrameException {
        LOGGER.logp(Level.FINEST, CLASS_NAME, "sendUponArrivalCondition", "ENTRY");
        try {
            waitForFrame = this.h2Connection.frameConverter(waitForFrame, false);
        }
        catch (CompressionException | IOException e) {
            LOGGER.logp(Level.FINEST, CLASS_NAME, "sendUponArrivalCondition", "caught exception: " + e);
        }
        if (this.h2Connection.didFrameArrive(waitForFrame)) {
            this.sendFrame(frameToSend);
        }
        LOGGER.logp(Level.FINEST, CLASS_NAME, "sendUponArrivalCondition", "waitForFrame.getClass: " + waitForFrame.getClass());
        this.sendFrameConditional.put(waitForFrame, frameToSend);
        this.sendFrameConditionalList.add(new AbstractMap.SimpleEntry<Frame, Frame>(waitForFrame, frameToSend));
        LOGGER.logp(Level.FINEST, CLASS_NAME, "sendUponArrivalCondition", "EXIT");
    }

    public void addExpectedFrames(ArrayList<Frame> frames) throws CompressionException, IOException, ExpectedPushPromiseDoesNotIncludeLinkHeaderException {
        this.h2Connection.addExpectedFrames(frames);
    }

    public H2StreamResult addExpectedFrame(Frame frame) throws CompressionException, IOException, ExpectedPushPromiseDoesNotIncludeLinkHeaderException {
        return this.h2Connection.addExpectedFrame(frame);
    }

    public H2StreamResult addExpectedFrame(FrameTypes type, int stream) throws CompressionException, IOException, ExpectedPushPromiseDoesNotIncludeLinkHeaderException {
        return this.h2Connection.addExpectedFrame(type, stream);
    }

    public void allowFramesAfterEndOfStream() {
        this.allowFramesAfterEndOfStream = true;
    }

    public boolean wasUpgradeHeaderReceived() {
        return this.h2Connection.wasServer101ResponseReceived();
    }

    public boolean wasServerPrefaceReceived() {
        return this.h2Connection.wasServerFirstConnectReceived();
    }

    public List<Exception> getReportedExceptions() {
        return this.h2Connection.getReportedExceptions();
    }

    protected boolean isWaitingForAck() {
        return this.h2Connection.getWaitingForACK().get();
    }

    public class FATFramesListener
    implements FramesListener {
        @Override
        public void receivedLastFrame(boolean sendGoAway) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.logp(Level.INFO, CLASS_NAME + "$FATFramesListener", "receivedLastFrame", "Received last frame");
            }
            if (sendGoAway) {
                block5: {
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.logp(Level.INFO, CLASS_NAME + "$FATFramesListener", "receivedLastFrame", "Sending GoAway");
                    }
                    try {
                        Http2Client.this.sendFrame(new FrameGoAway(0, new byte[]{0, 1}, 0, 1, false));
                    }
                    catch (UnableToSendFrameException e) {
                        if (!LOGGER.isLoggable(Level.INFO)) break block5;
                        LOGGER.logp(Level.INFO, CLASS_NAME + "$FATFramesListener", "receivedLastFrame", "caught exception: " + e);
                    }
                }
                Http2Client.this.isTestDone.set(true);
            }
        }

        @Override
        public void receivedFrameGoAway() {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.logp(Level.INFO, CLASS_NAME + "$FATFramesListener", "receivedFrameGoAway", "Received FrameGoAway from server. Calling blockUntilConnectionIsDone.countDown() and 'closing' connection.");
            }
            Http2Client.this.receivedExpectedGoAway = true;
            Http2Client.this.isTestDone.set(true);
        }

        @Override
        public void receivedSettingsAckFrame() {
            Http2Client.this.h2Connection.getWaitingForACK().set(false);
        }

        @Override
        public void sentSettingsFrame() {
            if (Http2Client.this.waitForAck) {
                Http2Client.this.h2Connection.getWaitingForACK().set(true);
            }
        }

        @Override
        public void receivedFrame(Frame receivedFrame) {
            if (receivedFrame.getFrameType() == FrameTypes.DATA) {
                FrameData fd = (FrameData)receivedFrame;
                String s = new String(fd.getData());
                if (s.toLowerCase().contains("donotadd")) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.logp(Level.FINEST, CLASS_NAME + "$FATFramesListener", "receivedFrame", ":Next Frame: :Read In: " + (Object)((Object)receivedFrame.getFrameType()) + " H2Conn hc: " + Http2Client.this.h2Connection.hashCode() + " DoNotAdd Frame");
                    }
                } else if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.logp(Level.FINEST, CLASS_NAME + "$FATFramesListener", "receivedFrame", ":Next Frame: :Read In: " + (Object)((Object)receivedFrame.getFrameType()) + " H2Conn hc: " + Http2Client.this.h2Connection.hashCode() + " " + receivedFrame);
                }
            } else if (receivedFrame.getFrameType() == FrameTypes.PUSH_PROMISE) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.logp(Level.FINEST, CLASS_NAME + "$FATFramesListener", "receivedFrame", ":Next Frame: :Read In PushPromise: " + (Object)((Object)receivedFrame.getFrameType()) + " H2Conn hc: " + Http2Client.this.h2Connection.hashCode() + " " + receivedFrame);
                }
                if (Http2Client.this.pushPromiseListener != null) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.logp(Level.FINEST, CLASS_NAME + "$FATFramesListener", "receivedFrame", ":Next Frame: :Calling PushPromiseListener: " + Http2Client.this.pushPromiseListener);
                    }
                    Http2Client.this.pushPromiseListener.onPushPromiseReceived((FramePushPromiseClient)receivedFrame);
                }
            } else if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.logp(Level.FINEST, CLASS_NAME + "$FATFramesListener", "receivedFrame", ":Next Frame: :Read In: " + (Object)((Object)receivedFrame.getFrameType()) + " H2Conn hc: " + Http2Client.this.h2Connection.hashCode() + " " + receivedFrame);
            }
            Iterator iterator = Http2Client.this.sendFrameConditionalList.iterator();
            while (iterator.hasNext()) {
                AbstractMap.SimpleEntry entry = (AbstractMap.SimpleEntry)iterator.next();
                if (!entry.equals(entry.getKey())) continue;
                try {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.logp(Level.FINEST, CLASS_NAME + "$FATFramesListener", "receivedFrame", "Received frame was found in sendFrameConditionalList.");
                    }
                    Http2Client.this.sendFrame((Frame)entry.getValue());
                    iterator.remove();
                    return;
                }
                catch (UnableToSendFrameException e) {
                    if (!LOGGER.isLoggable(Level.FINEST)) continue;
                    LOGGER.logp(Level.FINEST, CLASS_NAME + "$FATFramesListener", "receivedFrame", "caught exception: " + e);
                }
            }
        }
    }

    public class TimeoutHelper
    extends Thread {
        private final CountDownLatch countDownLatch;
        private final long timeoutToFinishTest;

        public TimeoutHelper(CountDownLatch countDownLatch, long timeoutToFinishTest) {
            this.countDownLatch = countDownLatch;
            this.timeoutToFinishTest = timeoutToFinishTest;
        }

        @Override
        public void run() {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.logp(Level.INFO, CLASS_NAME + "$TimeoutHelper", "run", "Timeout helper started running!");
            }
            long startTime = System.currentTimeMillis();
            while (System.currentTimeMillis() - startTime < this.timeoutToFinishTest && !Http2Client.this.isTestDone.get()) {
                try {
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.logp(Level.INFO, CLASS_NAME + "$TimeoutHelper", "run", "Timeout helper sleeping!");
                    }
                    Thread.sleep(10L);
                }
                catch (Exception exception) {}
            }
            while (lockWaitFor.get() && System.currentTimeMillis() - startTime < this.timeoutToFinishTest && !Http2Client.this.isTestDone.get()) {
                try {
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.logp(Level.INFO, CLASS_NAME + "$TimeoutHelper", "run", "Waiting for waitFor lock to finish!");
                    }
                    Thread.sleep(10L);
                }
                catch (Exception exception) {}
            }
            Http2Client.this.didTimeout.set(true);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.logp(Level.INFO, CLASS_NAME + "$TimeoutHelper", "run", "Finished looping because timeout: " + (System.currentTimeMillis() - startTime >= this.timeoutToFinishTest) + " isTestDone.get()= " + Http2Client.this.isTestDone.get());
            }
            if (!Http2Client.this.isTestDone.get()) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.logp(Level.SEVERE, CLASS_NAME + "$TimeoutHelper", "run", "Terminating test because the timeout was reached.");
                }
                Http2Client.this.getReportedExceptions().add(new FATTimeoutException("The test didn't finish. Timeout: " + this.timeoutToFinishTest));
            }
            Http2Client.this.h2Connection.close();
            if (Http2Client.this.allowFramesAfterEndOfStream) {
                Http2Client.this.getReportedExceptions().removeIf(e -> e instanceof ReceivedFrameAfterEndOfStream);
            }
            if (Http2Client.this.receivedExpectedGoAway) {
                Http2Client.this.getReportedExceptions().removeIf(e -> e instanceof StreamDidNotReceivedEndOfStreamException);
            }
            this.countDownLatch.countDown();
        }
    }
}

