/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http2.test;

import com.ibm.ws.http.channel.h2internal.FrameTypes;
import com.ibm.ws.http.channel.h2internal.exceptions.CompressionException;
import com.ibm.ws.http.channel.h2internal.frames.Frame;
import com.ibm.ws.http.channel.h2internal.frames.FrameGoAway;
import com.ibm.ws.http2.test.H2StreamResult;
import com.ibm.ws.http2.test.Http2Client;
import com.ibm.ws.http2.test.connection.H2Connection;
import com.ibm.ws.http2.test.exceptions.ExpectedPushPromiseDoesNotIncludeLinkHeaderException;
import com.ibm.ws.http2.test.exceptions.ReceivedFrameAfterEndOfStream;
import com.ibm.ws.http2.test.exceptions.ReceivedHeadersFrameAfterEndOfHeaders;
import com.ibm.ws.http2.test.exceptions.ReceivedUnexpectedGoAwayExcetion;
import com.ibm.ws.http2.test.frames.FramePushPromiseClient;
import com.ibm.ws.http2.test.helpers.HeaderEntry;
import com.ibm.ws.http2.test.listeners.FramesListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class H2StreamResultManager {
    private final ConcurrentHashMap<Integer, H2StreamResult> streamHashtable = new ConcurrentHashMap();
    private final ConcurrentHashMap<FramePushPromiseClient, H2StreamResult> pushPromiseH2StreamResults = new ConcurrentHashMap();
    private FramesListener framesListener;
    private H2Connection h2Connection;
    private boolean receivedExpectedGoAway = false;
    private static final String CLASS_NAME = H2StreamResultManager.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME);

    public H2StreamResultManager() {
    }

    public H2StreamResultManager(H2Connection h2Connection) {
        this();
        this.h2Connection = h2Connection;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLASS_NAME, "constructor", "Adding connection " + h2Connection + " to result manager: " + this);
        }
    }

    public int addResponseFrame(Frame frame) throws CompressionException, IOException, ReceivedFrameAfterEndOfStream, ReceivedHeadersFrameAfterEndOfHeaders, ReceivedUnexpectedGoAwayExcetion {
        H2StreamResult pushPromisedStreamResults;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLASS_NAME, "addResponseFrame", "H2StreamResultmanager.addResponseFrame: entry (object: " + this + ")");
        }
        frame = this.processFrame(frame, false, false);
        this.framesListener.receivedFrame(frame);
        if (frame.getFrameType() == FrameTypes.GOAWAY) {
            if (!this.isGoAwayExpected(frame)) {
                if (((FrameGoAway)frame).getErrorCode() > 0) {
                    throw new ReceivedUnexpectedGoAwayExcetion("The following GoAway frame was not expected and has an error message: " + frame);
                }
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.logp(Level.FINEST, CLASS_NAME, "addResponseFrame", "Calling listener's receivedFrameGoAway()");
                }
                this.framesListener.receivedFrameGoAway();
                return 0;
            }
            this.receivedExpectedGoAway = true;
        } else if (frame.getFrameType() == FrameTypes.PUSH_PROMISE && (pushPromisedStreamResults = this.pushPromiseH2StreamResults.get(frame)) != null) {
            int promisedStreamId = ((FramePushPromiseClient)frame).getPromisedStreamId();
            pushPromisedStreamResults.setStreamId(promisedStreamId);
            this.streamHashtable.put(promisedStreamId, pushPromisedStreamResults);
        }
        H2StreamResult streamResult = this.getStreamResult(frame);
        streamResult.addActualRespone(frame);
        if (this.receivedExpectedGoAway) {
            this.framesListener.receivedFrameGoAway();
        } else if (this.receivedAllFrames()) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.logp(Level.INFO, CLASS_NAME, "addResponseFrame", "Calling listener's receivedLastFrame sendGoAway: " + this.receivedExpectedGoAway);
            }
            this.framesListener.receivedLastFrame(!this.receivedExpectedGoAway);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLASS_NAME, "addResponseFrame", "H2StreamResultmanager.addResponseFrame: exit");
        }
        return 0;
    }

    public int addExpectedFrames(ArrayList<Frame> frames) throws CompressionException, IOException, ExpectedPushPromiseDoesNotIncludeLinkHeaderException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLASS_NAME, "addExpectedFrames", "H2StreamResultManager.addExpectedFrames: entry (object: " + this + ")");
        }
        Frame frame = null;
        for (int i = 0; i < frames.size(); ++i) {
            frame = this.processFrame(frames.get(i), false, true);
            this.addExpectedFrame(frame);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLASS_NAME, "addExpectedFrames", "H2StreamResultManager.addExpectedFrames: exit");
        }
        return 0;
    }

    public H2StreamResult addExpectedFrame(Frame frame) throws CompressionException, IOException, ExpectedPushPromiseDoesNotIncludeLinkHeaderException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLASS_NAME, "addExpectedFrame", "H2StreamResultManager.addExpectedFrame: entry (object: " + this + ")");
        }
        if (frame.getFrameType() == FrameTypes.PUSH_PROMISE) {
            return this.addExpectedPushPromiseFrame((FramePushPromiseClient)frame);
        }
        if (frame.getFrameType() == FrameTypes.GOAWAY) {
            this.getStreamResult(((FrameGoAway)frame).getLastStreamId()).setStreamClosureRequired(false);
        }
        frame = this.processFrame(frame, false, true);
        H2StreamResult streamResult = this.getStreamResult(frame);
        streamResult.addExpectedResponse(frame);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLASS_NAME, "addExpectedFrame", "H2StreamResultManager.addExpectedFrame: exit");
        }
        return null;
    }

    public H2StreamResult addExpectedFrame(FrameTypes type, int stream) throws CompressionException, IOException, ExpectedPushPromiseDoesNotIncludeLinkHeaderException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLASS_NAME, "addExpectedFrame(FrameTypes, int)", "H2StreamResultManager.addExpectedFrame: entry (object: " + this + ")");
        }
        H2StreamResult streamResult = this.getStreamResult(stream);
        streamResult.addExpectedResponse(type);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLASS_NAME, "addExpectedFrame", "H2StreamResultManager.addExpectedFrame: exit");
        }
        return null;
    }

    private H2StreamResult addExpectedPushPromiseFrame(FramePushPromiseClient frame) throws CompressionException, IOException, ExpectedPushPromiseDoesNotIncludeLinkHeaderException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLASS_NAME, "addExpectedPushPromiseFrame", "H2StreamResultManager.addExpectedPushPromiseFrame: entry (object: " + this + ")");
        }
        boolean linkHeaderFound = false;
        for (HeaderEntry headerEntry : frame.getHeaderEntries()) {
            if (!headerEntry.getH2HeaderField().getName().equalsIgnoreCase("link")) continue;
            linkHeaderFound = true;
        }
        if (linkHeaderFound) {
            throw new ExpectedPushPromiseDoesNotIncludeLinkHeaderException("Frame: " + frame);
        }
        frame = (FramePushPromiseClient)this.processFrame(frame, false, true);
        H2StreamResult streamResult = this.getStreamResult(frame);
        streamResult.addExpectedResponse(frame);
        H2StreamResult pushPromiseStreamResult = new H2StreamResult();
        this.pushPromiseH2StreamResults.put(frame, pushPromiseStreamResult);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLASS_NAME, "addExpectedPushPromiseFrame", "H2StreamResultManager.addExpectedPushPromiseFrame: exit");
        }
        return pushPromiseStreamResult;
    }

    private H2StreamResult getStreamResult(Frame frame) {
        return this.getStreamResult(frame.getStreamId());
    }

    private H2StreamResult getStreamResult(Integer streamId) {
        H2StreamResult streamResult;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLASS_NAME, "getStreamResult", "H2StreamResultmanager.getStreamResult: entry (object: " + this + ")");
        }
        if ((streamResult = this.streamHashtable.get(streamId)) == null) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.logp(Level.INFO, CLASS_NAME, "getStreamResult", "Create new streamHashtable entry for id: " + streamId);
            }
            streamResult = new H2StreamResult(streamId);
            this.streamHashtable.put(streamId, streamResult);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLASS_NAME, "getStreamResult", "H2StreamResultmanager.getStreamResult: exit");
        }
        return streamResult;
    }

    private H2StreamResult lookupStreamResult(Integer streamId) {
        H2StreamResult streamResult = this.streamHashtable.get(streamId);
        return streamResult;
    }

    public List<Exception> compareStreamResult(Integer streamId) {
        H2StreamResult streamResult = this.lookupStreamResult(streamId);
        if (streamResult == null) {
            throw new NullPointerException("The H2StreamResult object with streamId " + streamId + " does not exist.");
        }
        return streamResult.checkResult();
    }

    public boolean receivedAllFrames() {
        if (this.h2Connection.getWaitingForACK().get()) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.logp(Level.FINEST, CLASS_NAME, "receivedAllFrames", "All frames not received: still waiting for SETTINGS frame with ACK set");
            }
            return false;
        }
        Set streamIds = this.streamHashtable.keySet();
        for (Integer streamId : streamIds) {
            if (this.lookupStreamResult(streamId).getStreamId() != 0 && !this.lookupStreamResult(streamId).receivedEndOfStreamOrRstStream() && !this.lookupStreamResult(streamId).isContinuationExpected()) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.logp(Level.FINEST, CLASS_NAME, "receivedAllFrames", "StreamID: " + this.lookupStreamResult(streamId).getStreamId() + " has not finished.");
                }
                return false;
            }
            if (this.lookupStreamResult(streamId).getStreamId() == 0) {
                if (!this.lookupStreamResult(streamId).receivedAtLeastExpectedNumberOfFrames()) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.logp(Level.FINEST, CLASS_NAME, "receivedAllFrames", "StreamID: " + this.lookupStreamResult(streamId).getStreamId() + " has not finished.");
                    }
                    return false;
                }
                if (this.lookupStreamResult(streamId).isgoawayExpected() && !this.lookupStreamResult(streamId).goawayReceived()) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.logp(Level.FINEST, CLASS_NAME, "receivedAllFrames", "StreamID: " + this.lookupStreamResult(streamId).getStreamId() + " has not received goaway.");
                    }
                    return false;
                }
            } else if (Http2Client.lockWaitFor.get()) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.logp(Level.FINEST, CLASS_NAME, "receivedAllFrames", "Still waiting on frames for Http2Client. Test has not finished");
                }
                return false;
            }
            if (!LOGGER.isLoggable(Level.FINEST)) continue;
            LOGGER.logp(Level.FINEST, CLASS_NAME, "receivedAllFrames", "StreamID: " + this.lookupStreamResult(streamId).getStreamId() + " has finished.");
        }
        return true;
    }

    public List<Exception> compareAllStreamResults() {
        ArrayList<Exception> exceptionsOnAllStreams = new ArrayList<Exception>();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.logp(Level.INFO, CLASS_NAME, "compareAllStreamResults", "-*-*-*-*-*-*-*-*-*-*-*- Compare Results EyeCatcher *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*");
        }
        Set streamIds = this.streamHashtable.keySet();
        for (Integer streamId : streamIds) {
            exceptionsOnAllStreams.addAll(this.compareStreamResult(streamId));
        }
        return exceptionsOnAllStreams;
    }

    public boolean isGoAwayExpected(Frame goAwayFrame) {
        int streamID = 0;
        H2StreamResult streamResult = this.lookupStreamResult(streamID);
        if (streamResult == null) {
            throw new NullPointerException("The H2StreamResult object with streamId " + streamID + " does not exist.");
        }
        return streamResult.isExpectedFrameType(goAwayFrame);
    }

    public boolean didframeArrive(Frame expectedFrame) {
        H2StreamResult streamResult = this.lookupStreamResult(expectedFrame.getStreamId());
        return streamResult != null && streamResult.didFrameArrive(expectedFrame);
    }

    public Frame processFrame(Frame frame, boolean modifyConnectionIfNeeded, boolean isExpected) throws CompressionException, IOException {
        int streamId;
        if (modifyConnectionIfNeeded && frame.getFrameType() == FrameTypes.SETTINGS) {
            this.framesListener.sentSettingsFrame();
            return frame;
        }
        if (frame.getFrameType() == FrameTypes.SETTINGS && frame.flagAckSet()) {
            this.framesListener.receivedSettingsAckFrame();
        }
        if (this.streamHashtable.get(streamId = frame.getStreamId()) == null || this.getStreamResult(frame.getStreamId()).shouldConvertFrame()) {
            return this.h2Connection.frameConverter(frame, isExpected);
        }
        return frame;
    }

    public void setFramesListener(FramesListener framesListener) {
        this.framesListener = framesListener;
    }
}

