/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http2.test;

import com.ibm.ws.http.channel.h2internal.FrameTypes;
import com.ibm.ws.http.channel.h2internal.frames.Frame;
import com.ibm.ws.http.channel.h2internal.frames.FrameData;
import com.ibm.ws.http.channel.h2internal.frames.FrameSettings;
import com.ibm.ws.http2.test.exceptions.MissingExpectedFramesException;
import com.ibm.ws.http2.test.exceptions.ReceivedFrameAfterEndOfStream;
import com.ibm.ws.http2.test.exceptions.ReceivedHeadersFrameAfterEndOfHeaders;
import com.ibm.ws.http2.test.exceptions.StreamDidNotReceivedEndOfStreamException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class H2StreamResult {
    private int streamId;
    private final ArrayList<Frame> expectedResponse;
    private final ArrayList<Frame> actualResponse;
    private final ArrayList<FrameTypes> actualResponseTypes;
    private final ArrayList<FrameTypes> expectedResponseTypes;
    private boolean endOfStreamFlagReceived = false;
    private boolean endOfHeadersFlagReceived = false;
    private boolean frameHasEndOfStreamFlag = false;
    private boolean rstStreamReceived = false;
    private boolean goawayReceived = false;
    private final boolean removalOfEmptyDataFrameNeeded = true;
    private final FrameData eosDataFrame;
    private final FrameSettings ackSettingsFrame;
    private final int eosDataFrameIndex = 0;
    private boolean streamClosureRequired = true;
    private boolean onlyCheckFrameTypes = false;
    private static final String CLASS_NAME = H2StreamResult.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME);
    private boolean continuationExpected = false;
    private boolean goawayExpected = false;

    public H2StreamResult() {
        this(-1);
    }

    public H2StreamResult(int streamId) {
        this.streamId = streamId;
        this.expectedResponse = new ArrayList();
        this.actualResponse = new ArrayList();
        this.expectedResponseTypes = new ArrayList();
        this.actualResponseTypes = new ArrayList();
        this.eosDataFrame = new FrameData(streamId, new byte[0], 0, true, false, false);
        this.ackSettingsFrame = new FrameSettings();
        this.ackSettingsFrame.setAckFlag();
    }

    public H2StreamResult(int streamId, Frame[] expectedResponse) {
        this(streamId);
        for (int i = 0; i < expectedResponse.length; ++i) {
            this.addExpectedResponse(expectedResponse[i]);
        }
    }

    protected boolean isContinuationExpected() {
        return this.continuationExpected;
    }

    protected boolean isgoawayExpected() {
        return this.goawayExpected;
    }

    public void addActualRespone(Frame frame) throws ReceivedFrameAfterEndOfStream, ReceivedHeadersFrameAfterEndOfHeaders {
        FrameData fd;
        String s;
        if (frame.getFrameType() != FrameTypes.PRIORITY) {
            if (this.rstStreamReceived || this.endOfStreamFlagReceived && !this.continuationExpected) {
                throw new ReceivedFrameAfterEndOfStream("The following frame was received on streamId = " + this.streamId + " after an end of stream flag was received: " + frame);
            }
            if (this.endOfHeadersFlagReceived && frame.getFrameType() == FrameTypes.HEADERS) {
                throw new ReceivedHeadersFrameAfterEndOfHeaders("The following frame was received on streamId = " + this.streamId + " after an end of headers flag was received: " + frame);
            }
        }
        if (frame.flagEndStreamSet()) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.logp(Level.FINEST, CLASS_NAME, "addActualRespone", "Frame = " + (Object)((Object)frame.getFrameType()) + " has end of stream flag on.");
            }
            this.endOfStreamFlagReceived = true;
            if (this.streamId != 0 && frame.getPayloadLength() == 0) {
                this.expectedResponse.add(this.eosDataFrame);
            }
        }
        if ((frame.getFrameType() == FrameTypes.HEADERS || frame.getFrameType() == FrameTypes.CONTINUATION) && frame.flagEndHeadersSet()) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.logp(Level.INFO, CLASS_NAME, "addActualRespone", "Frame = " + (Object)((Object)frame.getFrameType()) + " has end of headers flag on.");
            }
            this.endOfHeadersFlagReceived = true;
            this.continuationExpected = false;
        } else if (frame.getFrameType() == FrameTypes.HEADERS && this.endOfStreamFlagReceived) {
            this.continuationExpected = true;
        }
        if (frame.getFrameType() == FrameTypes.RST_STREAM) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.logp(Level.INFO, CLASS_NAME, "addActualRespone", "Received RST_FRAME on streamID: " + this.streamId);
            }
            this.rstStreamReceived = true;
        }
        if (frame.getFrameType() == FrameTypes.GOAWAY) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.logp(Level.INFO, CLASS_NAME, "addActualRespone", "Received GOAWAY on streamID: " + this.streamId);
            }
            this.goawayReceived = true;
        }
        if (frame.getFrameType() == FrameTypes.SETTINGS && frame.flagAckSet()) {
            this.expectedResponse.add(this.ackSettingsFrame);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLASS_NAME, "addActualRespone", "adding frame to actualResponse Frame Type: " + (Object)((Object)frame.getFrameType()) + " stream-id: " + frame.getStreamId());
        }
        if (frame.getFrameType() == FrameTypes.DATA && (s = new String((fd = (FrameData)frame).getData())).toLowerCase().contains("donotadd")) {
            return;
        }
        this.actualResponse.add(frame);
        this.actualResponseTypes.add(frame.getFrameType());
    }

    public void addExpectedResponse(Frame frame) {
        if (frame.flagEndStreamSet()) {
            this.frameHasEndOfStreamFlag = true;
        }
        this.expectedResponse.add(frame);
        this.expectedResponseTypes.add(frame.getFrameType());
        if (frame.getFrameType().equals((Object)FrameTypes.GOAWAY)) {
            this.goawayExpected = true;
        }
    }

    public void addExpectedResponse(FrameTypes type) {
        this.onlyCheckFrameTypes = true;
        this.expectedResponseTypes.add(type);
        if (type.equals((Object)FrameTypes.GOAWAY)) {
            this.goawayExpected = true;
        }
    }

    public boolean shouldConvertFrame() {
        return !this.onlyCheckFrameTypes;
    }

    public int getStreamId() {
        return this.streamId;
    }

    public void setStreamId(int streamId) {
        this.streamId = streamId;
    }

    public boolean receivedExpectedNumberOfFrames() {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLASS_NAME, "receivedExpectedNumberOfFrames", "receivedExpectedNumberOfFrames: actualResponse.size() = " + this.actualResponse.size() + " expectedResponse.size() = " + this.expectedResponse.size());
        }
        if (this.onlyCheckFrameTypes) {
            return this.actualResponseTypes.size() == this.expectedResponseTypes.size();
        }
        return this.actualResponse.size() == this.expectedResponse.size();
    }

    public boolean receivedAtLeastExpectedNumberOfFrames() {
        if (!this.onlyCheckFrameTypes) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.logp(Level.FINEST, CLASS_NAME, "receivedAtLeastExpectedNumberOfFrames", "receivedExpectedNumberOfFrames: actualResponse.size() = " + this.actualResponse.size() + " expectedResponse.size() = " + this.expectedResponse.size());
            }
        } else if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLASS_NAME, "receivedAtLeastExpectedNumberOfFrames", "receivedExpectedNumberOfFrames: actualResponseTypes.size() = " + this.actualResponseTypes.size() + " expectedResponseTypes.size() = " + this.expectedResponseTypes.size());
        }
        if (this.onlyCheckFrameTypes) {
            return this.actualResponseTypes.size() >= this.expectedResponseTypes.size();
        }
        return this.actualResponse.size() >= this.expectedResponse.size();
    }

    public boolean receivedEndOfStreamOrRstStream() {
        return this.endOfStreamFlagReceived || this.rstStreamReceived;
    }

    public boolean goawayReceived() {
        return this.goawayReceived;
    }

    public List<Exception> checkResult() {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.logp(Level.INFO, CLASS_NAME, "checkResult", "Comparing frames of streamId: " + this.streamId);
        }
        ArrayList<Exception> exceptionsOfStream = new ArrayList<Exception>();
        if (this.onlyCheckFrameTypes) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.logp(Level.INFO, CLASS_NAME, "checkResult", "Comparing frame types of streamId: " + this.streamId);
            }
            for (FrameTypes type : this.expectedResponseTypes) {
                if (this.actualResponseTypes.contains((Object)type)) continue;
                exceptionsOfStream.add(new MissingExpectedFramesException("Expected Frame Type(s) not found: \n" + type.toString()));
            }
            if (0 == exceptionsOfStream.size() && LOGGER.isLoggable(Level.INFO)) {
                LOGGER.logp(Level.INFO, CLASS_NAME, "checkResult", "All frame types present for streamId: " + this.streamId);
            }
            return exceptionsOfStream;
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.logp(Level.INFO, CLASS_NAME, "checkResult", "List of received frames for streamId " + this.streamId + ": \n");
            Object[] oa = this.actualResponse.toArray();
            int len = oa.length;
            if (len > 10) {
                len = 10;
            }
            for (int i = 0; i < len; ++i) {
                LOGGER.logp(Level.INFO, CLASS_NAME, "checkResult", "Frame: " + (i + 1) + oa[i].toString());
            }
            if (oa.length > 10) {
                LOGGER.logp(Level.INFO, CLASS_NAME, "checkResult", "Last Frame: " + oa.length + oa[oa.length - 1].toString());
            }
        }
        if (this.expectedResponse == null && this.actualResponse != null) {
            throw new NullPointerException("Expected response for stream " + this.streamId + " is null, while actual response is not");
        }
        if (this.expectedResponse != null && this.actualResponse == null) {
            throw new NullPointerException("Actual response for stream " + this.streamId + " is null, while expected response is not");
        }
        if (this.expectedResponse == null && this.actualResponse == null) {
            throw new NullPointerException("Both expected response and actual responses for stream " + this.streamId + " are null");
        }
        if (this.streamId != 0 && this.streamClosureRequired && !this.endOfStreamFlagReceived && !this.rstStreamReceived) {
            exceptionsOfStream.add(new StreamDidNotReceivedEndOfStreamException("StreamId: " + this.streamId + " did not receive the end of stream flag on any of the received frames or an RST_STREAM. endOfStreamFlagReceived = " + this.endOfStreamFlagReceived + " rstStreamReceived = " + this.rstStreamReceived));
        } else {
            Frame expectedFrame = null;
            Frame actualFrame = null;
            StringBuilder expectedFrameNotFound = new StringBuilder();
            for (int i = 0; i < this.expectedResponse.size(); ++i) {
                expectedFrame = this.expectedResponse.get(i);
                if (i < 10) {
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.logp(Level.INFO, CLASS_NAME, "checkResult", "***expectedFrame[" + i + "] = " + expectedFrame);
                    }
                } else if (i == this.expectedResponse.size() - 1 && LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.logp(Level.INFO, CLASS_NAME, "checkResult", "***last expectedFrame[" + i + "] = " + expectedFrame);
                }
                boolean expectedFrameFound = false;
                for (int j = 0; j < this.actualResponse.size(); ++j) {
                    actualFrame = this.actualResponse.get(j);
                    if (!expectedFrame.equals(actualFrame)) continue;
                    expectedFrameFound = true;
                    this.actualResponse.remove(j--);
                    break;
                }
                if (expectedFrameFound) continue;
                System.out.println("***expectedframe not found!: " + expectedFrame);
                expectedFrameNotFound.append(expectedFrame).append("\n");
            }
            if (expectedFrameNotFound.length() != 0) {
                exceptionsOfStream.add(new MissingExpectedFramesException("Expected frame(s) not found: \n" + expectedFrameNotFound.toString()));
            }
        }
        return exceptionsOfStream;
    }

    public boolean isExpectedFrameType(Frame frame) {
        int i;
        FrameTypes x = frame.getFrameType();
        for (i = 0; i < this.expectedResponse.size(); ++i) {
            if (x != this.expectedResponse.get(i).getFrameType()) continue;
            return true;
        }
        for (i = 0; i < this.expectedResponseTypes.size(); ++i) {
            if (x != this.expectedResponseTypes.get(i)) continue;
            return true;
        }
        return false;
    }

    public boolean isExpectedFrame(Frame frame) {
        return this.expectedResponse.contains(frame);
    }

    public void setStreamClosureRequired(boolean streamClosureRequired) {
        this.streamClosureRequired = streamClosureRequired;
    }

    public boolean didFrameArrive(Frame frame) {
        return this.actualResponse.contains(frame);
    }
}

