/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http2.test;

import com.ibm.websphere.channelfw.FlowType;
import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.wsspi.bytebuffer.WsByteBufferPoolManager;
import com.ibm.wsspi.channelfw.ChannelFramework;
import com.ibm.wsspi.channelfw.OutboundVirtualConnection;
import com.ibm.wsspi.channelfw.exception.InvalidChainNameException;
import com.ibm.wsspi.channelfw.exception.InvalidChannelNameException;
import com.ibm.wsspi.tcpchannel.TCPConnectRequestContext;
import com.ibm.wsspi.tcpchannel.TCPConnectRequestContextFactory;
import com.ibm.wsspi.tcpchannel.TCPConnectionContext;
import java.util.Map;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(service={CFWManager.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class CFWManager {
    private static CHFWBundle m_chfw = null;
    private static ChannelFramework cfw = null;
    private static WsByteBufferPoolManager wbbpMgr = null;
    private static TCPConnectRequestContextFactory tcpConnectFactory = null;
    private static CFWManager singletonCfwManager = null;
    private final boolean chainCreated = false;

    public static CFWManager getInstance() {
        if (singletonCfwManager == null) {
            singletonCfwManager = new CFWManager();
        }
        return singletonCfwManager;
    }

    @Reference(name="chfwBundle")
    protected void setChfwBundle(CHFWBundle bundle) {
        System.out.println("setChfwBundle");
        m_chfw = bundle;
    }

    protected void unsetChfwBundle(CHFWBundle bundle) {
        System.out.println("unsetChfwBundle");
        m_chfw = null;
    }

    protected CHFWBundle getChfwBundle() {
        return m_chfw;
    }

    @Activate
    public void activate(Map<String, Object> properties) {
        System.out.println("activate");
        this.createTCPChannelChain("TCPChannel1", "TCPChainA", this.getChannelFramework());
    }

    @Deactivate
    protected void deactivate(ComponentContext ctx, int reason) {
        System.out.println("deactivate");
    }

    @Modified
    protected void modified(Map<String, Object> config) {
        System.out.println("modified");
    }

    public synchronized TCPConnectRequestContextFactory getTCPConnectRequestContextFactory() {
        if (tcpConnectFactory == null) {
            try {
                tcpConnectFactory = TCPConnectRequestContextFactory.getRef();
            }
            catch (Exception x) {
                System.out.println("CFWManager.getTCPConnectRequestContextFactory(): " + x);
            }
        }
        return tcpConnectFactory;
    }

    public static synchronized WsByteBufferPoolManager getWsByteBufferPoolManager() {
        if (wbbpMgr == null) {
            wbbpMgr = m_chfw.getBufferManager();
        }
        return wbbpMgr;
    }

    public synchronized ChannelFramework getChannelFramework() {
        if (cfw == null) {
            cfw = m_chfw.getFramework();
        }
        return cfw;
    }

    public void createTCPChannelChain(String tcpChannelName, String chainName, ChannelFramework cfw) {
        try {
            cfw.addChannel(tcpChannelName, cfw.lookupFactory("TCPChannel"), null);
            String[] chanList = new String[]{tcpChannelName};
            System.out.println("successfully add ChainData of: " + cfw.addChain(chainName, FlowType.OUTBOUND, chanList));
        }
        catch (InvalidChannelNameException e) {
            System.out.println("Channel name already registered!: " + (Object)((Object)e));
        }
        catch (InvalidChainNameException e) {
            System.out.println("Chain name already registered!: " + (Object)((Object)e));
        }
        catch (Exception e) {
            System.err.println("CFWManager.createChannelChain(...) exception(): " + e);
        }
    }

    public OutboundVirtualConnection createOutboundVirtualConnection() {
        return this.createOutboundVirtualConnection("TCPChainA");
    }

    public OutboundVirtualConnection createOutboundVirtualConnection(String chainName) {
        OutboundVirtualConnection ovc = null;
        try {
            ovc = (OutboundVirtualConnection)this.getChannelFramework().getOutboundVCFactory(chainName).createConnection();
        }
        catch (Exception e) {
            System.out.println("CFWManager..createOutboundVirtualConnection(...) exception(): " + e);
            e.printStackTrace(System.err);
        }
        return ovc;
    }

    public TCPConnectionContext connectTCPOutbound(OutboundVirtualConnection ovc, TCPConnectRequestContext outbound) {
        TCPConnectionContext tcc = null;
        try {
            ovc.connect((Object)outbound);
            tcc = (TCPConnectionContext)ovc.getChannelAccessor();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.out.println("CFWManager.connectOutbound(...) exception(): " + e);
        }
        return tcc;
    }
}

