/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.netty.message;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.http.channel.internal.HttpChannelConfig;
import com.ibm.ws.http.channel.internal.HttpTrailersImpl;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundServiceContextImpl;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.ws.http.netty.message.NettyBaseMessage;
import com.ibm.ws.http.netty.message.NettyHeader;
import com.ibm.ws.http.netty.message.NettyTrailers;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.genericbnf.GenericKeys;
import com.ibm.wsspi.genericbnf.HeaderField;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.genericbnf.exception.UnsupportedProtocolVersionException;
import com.ibm.wsspi.http.HttpCookie;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import com.ibm.wsspi.http.channel.HttpTrailers;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import com.ibm.wsspi.http.channel.values.ConnectionValues;
import com.ibm.wsspi.http.channel.values.ContentEncodingValues;
import com.ibm.wsspi.http.channel.values.ExpectValues;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import com.ibm.wsspi.http.channel.values.StatusCodes;
import com.ibm.wsspi.http.channel.values.TransferEncodingValues;
import com.ibm.wsspi.http.channel.values.VersionValues;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.openliberty.http.netty.channel.utils.HeaderValidator;
import io.openliberty.http.netty.cookie.CookieEncoder;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class NettyResponseMessage
extends NettyBaseMessage
implements HttpResponseMessage {
    private static final TraceComponent tc = Tr.register(NettyResponseMessage.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    HttpResponse nettyResponse;
    HttpHeaders headers;
    HttpHeaders trailers;
    NettyTrailers nettyTrailerWrapper;
    HttpInboundServiceContext context;
    HttpChannelConfig config;
    static final long serialVersionUID = -607423594026661550L;

    public NettyResponseMessage(HttpResponse response, HttpInboundServiceContext isc, HttpRequest request) {
        Objects.requireNonNull(isc);
        Objects.requireNonNull(response);
        this.context = isc;
        this.nettyResponse = response;
        this.headers = this.nettyResponse.headers();
        this.trailers = new DefaultHttpHeaders().clear();
        this.nettyTrailerWrapper = new NettyTrailers(this.trailers);
        if (request.headers().contains((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text())) {
            String streamId = request.headers().get((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text());
            this.nettyResponse.headers().set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), (Object)streamId);
        }
        if (isc instanceof HttpInboundServiceContextImpl) {
            this.incoming(((HttpInboundServiceContextImpl)isc).isInboundConnection());
            this.config = ((HttpInboundServiceContextImpl)isc).getHttpConfig();
        }
        super.init((HttpMessage)response, (HttpServiceContext)this.context, this.config);
        this.setMessageType(NettyBaseMessage.MessageType.RESPONSE);
    }

    public void update(HttpResponse response) {
        this.nettyResponse = response;
        this.headers = response.headers();
    }

    @Override
    public void clear() {
        super.clear();
        this.setStatusCode(HttpResponseStatus.OK.code());
        this.nettyResponse.setProtocolVersion(HttpVersion.HTTP_1_1);
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    public boolean isBodyExpected() {
        if (VersionValues.V10.equals((GenericKeys)this.getVersionValue())) {
            return this.isBodyAllowed();
        }
        if (HttpMethod.HEAD.toString().equals(this.getServiceContext().getRequest().getMethod())) {
            return false;
        }
        boolean bodyExpected = super.isBodyExpected();
        if (!bodyExpected) {
            bodyExpected = this.containsHeader(HttpHeaderNames.CONTENT_ENCODING.array()) || this.containsHeader(HttpHeaderNames.CONTENT_RANGE.array());
        }
        return bodyExpected && this.isBodyAllowedForStatusCode();
    }

    @Override
    public boolean isBodyAllowed() {
        if (super.isBodyAllowed()) {
            if (HttpMethod.HEAD.toString().equals(this.getServiceContext().getRequest().getMethod())) {
                return false;
            }
            return this.isBodyAllowedForStatusCode();
        }
        return false;
    }

    @Override
    public void setConnection(ConnectionValues value) {
        if (value.getName().equalsIgnoreCase(HttpHeaderValues.CLOSE.toString())) {
            this.nettyResponse.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        } else if (value.getName().equalsIgnoreCase(HttpHeaderValues.KEEP_ALIVE.toString())) {
            this.nettyResponse.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        }
    }

    @Override
    public void setConnection(ConnectionValues[] values) {
        this.nettyResponse.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)values);
    }

    @Override
    public ConnectionValues[] getConnection() {
        List test = this.nettyResponse.headers().getAll((CharSequence)HttpHeaderNames.CONNECTION);
        ArrayList<ConnectionValues> values = new ArrayList<ConnectionValues>();
        for (String header : test) {
            values.add(ConnectionValues.match((String)header, (int)0, (int)header.length()));
        }
        return (ConnectionValues[])values.toArray();
    }

    @Override
    public boolean isKeepAliveSet() {
        return HttpUtil.isKeepAlive((HttpMessage)this.nettyResponse);
    }

    @Override
    public boolean isConnectionSet() {
        return this.containsHeader((HeaderKeys)HttpHeaderKeys.HDR_CONNECTION);
    }

    @Override
    public void setContentEncoding(ContentEncodingValues value) {
        this.headers.set((CharSequence)HttpHeaderNames.CONTENT_ENCODING, (Object)value.getName());
    }

    @Override
    public void setContentEncoding(ContentEncodingValues[] values) {
        this.headers.remove((CharSequence)HttpHeaderNames.CONTENT_ENCODING);
        for (ContentEncodingValues value : values) {
            this.headers.add((CharSequence)HttpHeaderNames.CONTENT_ENCODING, (Object)value.getName());
        }
    }

    @Override
    public ContentEncodingValues[] getContentEncoding() {
        List encodingHeaders = this.headers.getAll((CharSequence)HttpHeaderNames.CONTENT_ENCODING);
        ArrayList<ContentEncodingValues> values = new ArrayList<ContentEncodingValues>();
        for (String encoding : encodingHeaders) {
            values.add(ContentEncodingValues.match((String)encoding, (int)0, (int)encoding.length()));
        }
        return (ContentEncodingValues[])values.toArray();
    }

    @Override
    public void setTransferEncoding(TransferEncodingValues value) {
    }

    @Override
    public void setTransferEncoding(TransferEncodingValues[] values) {
    }

    @Override
    public TransferEncodingValues[] getTransferEncoding() {
        return null;
    }

    @Override
    public boolean isChunkedEncodingSet() {
        return HttpUtil.isTransferEncodingChunked((HttpMessage)this.nettyResponse);
    }

    @Override
    public void setCurrentDate() {
        this.setHeader((HeaderKeys)HttpHeaderKeys.HDR_DATE, HttpDispatcher.getDateFormatter().getRFC1123TimeAsBytes(this.config.getDateHeaderRange()));
    }

    @Override
    public void setExpect(ExpectValues value) {
    }

    @Override
    public byte[] getExpect() {
        return null;
    }

    @Override
    public boolean isExpect100Continue() {
        return HttpUtil.is100ContinueExpected((HttpMessage)this.nettyResponse);
    }

    @Override
    public String getMIMEType() {
        return HttpUtil.getMimeType((HttpMessage)this.nettyResponse).toString();
    }

    @Override
    public void setMIMEType(String type) {
    }

    @Override
    public Charset getCharset() {
        return null;
    }

    @Override
    public void setCharset(Charset set) {
    }

    @Override
    public HttpTrailers getTrailers() {
        return this.nettyTrailerWrapper;
    }

    public HttpHeaders getNettyTrailers() {
        return this.trailers;
    }

    @Override
    public void setVersion(VersionValues version) {
    }

    @Override
    public void setVersion(String version) throws UnsupportedProtocolVersionException {
    }

    @Override
    public void setVersion(byte[] version) throws UnsupportedProtocolVersionException {
    }

    @Override
    public HttpTrailersImpl createTrailers() {
        return null;
    }

    @Override
    public void setDebugContext(Object o) {
    }

    @Override
    public HeaderField getHeader(String name) {
        return new NettyHeader(name, this.headers);
    }

    @Override
    public HeaderField getHeader(byte[] name) {
        return this.getHeader(new String(name, StandardCharsets.UTF_8));
    }

    @Override
    public HeaderField getHeader(HeaderKeys name) {
        return new NettyHeader(name, this.headers);
    }

    @Override
    public List<HeaderField> getHeaders(String name) {
        List values = this.headers.getAll(name);
        ArrayList<HeaderField> result = new ArrayList<HeaderField>();
        for (String value : values) {
            result.add(new NettyHeader(name, value));
        }
        return result;
    }

    @Override
    public List<HeaderField> getHeaders(byte[] name) {
        return this.getHeaders(new String(name, StandardCharsets.UTF_8));
    }

    @Override
    public List<HeaderField> getHeaders(HeaderKeys name) {
        return this.getHeaders(name.getName());
    }

    @Override
    public List<HeaderField> getAllHeaders() {
        List entries = this.headers.entries();
        ArrayList<HeaderField> headers = new ArrayList<HeaderField>();
        for (Map.Entry entry : entries) {
            headers.add(new NettyHeader((String)entry.getKey(), (String)entry.getValue()));
        }
        return headers;
    }

    @Override
    public List<String> getAllHeaderNames() {
        return new ArrayList<String>(this.headers.names());
    }

    @Override
    public Set<String> getAllHeaderNamesSet() {
        return this.headers.names();
    }

    @Override
    public void appendHeader(byte[] header, byte[] value) {
        this.appendHeader(new String(header, StandardCharsets.UTF_8), new String(value, StandardCharsets.UTF_8));
    }

    @Override
    public void appendHeader(byte[] header, byte[] value, int offset, int length) {
    }

    @Override
    public void appendHeader(byte[] header, String value) {
        this.appendHeader(new String(header, StandardCharsets.UTF_8), value);
    }

    @Override
    public void appendHeader(HeaderKeys header, byte[] value) {
        this.appendHeader(header.getName(), new String(value, StandardCharsets.UTF_8));
    }

    @Override
    public void appendHeader(HeaderKeys header, byte[] value, int offset, int length) {
    }

    @Override
    public void appendHeader(HeaderKeys header, String value) {
        this.appendHeader(header.getName(), value);
    }

    @Override
    public void appendHeader(String header, byte[] value) {
        this.appendHeader(header, new String(value, StandardCharsets.UTF_8));
    }

    @Override
    public void appendHeader(String header, byte[] value, int offset, int length) {
    }

    @Override
    public void appendHeader(String header, String value) {
        String normalizedName = HeaderValidator.process(header, HeaderValidator.FieldType.NAME, this.config);
        String normalizedValue = HeaderValidator.process(value, HeaderValidator.FieldType.VALUE, this.config);
        this.headers.add(normalizedName, (Object)normalizedValue);
    }

    @Override
    public int getNumberOfHeaderInstances(String header) {
        return this.headers.getAll(header).size();
    }

    @Override
    public boolean containsHeader(byte[] header) {
        return this.containsHeader(new String(header, StandardCharsets.UTF_8));
    }

    @Override
    public boolean containsHeader(HeaderKeys header) {
        return this.containsHeader(header.getName());
    }

    @Override
    public boolean containsHeader(String header) {
        return this.headers.contains(header);
    }

    @Override
    public int getNumberOfHeaderInstances(byte[] header) {
        return this.getNumberOfHeaderInstances(new String(header, StandardCharsets.UTF_8));
    }

    @Override
    public int getNumberOfHeaderInstances(HeaderKeys header) {
        return this.getNumberOfHeaderInstances(header.toString());
    }

    @Override
    public void removeHeader(byte[] header) {
        this.removeHeader(new String(header, StandardCharsets.UTF_8));
    }

    @Override
    public void removeHeader(byte[] header, int instance) {
    }

    @Override
    public void removeHeader(HeaderKeys header) {
        this.removeHeader(header.getName());
    }

    @Override
    public void removeHeader(HeaderKeys header, int instance) {
    }

    @Override
    public void removeHeader(String header) {
        this.headers.remove(header);
    }

    @Override
    public void removeHeader(String header, int instance) {
    }

    @Override
    public void removeAllHeaders() {
        this.headers.clear();
    }

    @Override
    public void setHeader(byte[] header, byte[] value) {
    }

    @Override
    public void setHeader(byte[] header, byte[] value, int offset, int length) {
    }

    @Override
    public void setHeader(byte[] header, String value) {
    }

    @Override
    public void setHeader(HeaderKeys header, byte[] value) {
    }

    @Override
    public void setHeader(HeaderKeys header, byte[] value, int offset, int length) {
    }

    @Override
    public void setHeader(HeaderKeys header, String value) {
        this.setHeader(header.getName(), value);
    }

    @Override
    public HeaderField setHeaderIfAbsent(HeaderKeys header, String value) {
        Objects.requireNonNull(header);
        Objects.requireNonNull(value);
        if (!this.headers.contains(header.getName())) {
            this.headers.set(header.getName(), (Object)value);
        }
        return null;
    }

    @Override
    public void setHeader(String header, byte[] value) {
    }

    @Override
    public void setHeader(String header, byte[] value, int offset, int length) {
    }

    @Override
    public void setHeader(String header, String value) {
        this.headers.set(header.trim(), (Object)value.trim());
    }

    @Override
    public void setLimitOnNumberOfHeaders(int number) {
    }

    @Override
    public int getLimitOnNumberOfHeaders() {
        return 0;
    }

    @Override
    public void setLimitOfTokenSize(int size) {
    }

    @Override
    public int getLimitOfTokenSize() {
        return 0;
    }

    public int getStatusCodeAsInt() {
        return this.nettyResponse.status().code();
    }

    public StatusCodes getStatusCode() {
        return StatusCodes.getByOrdinal((int)this.getStatusCodeAsInt());
    }

    public void setStatusCode(int code) {
        this.nettyResponse.setStatus(HttpResponseStatus.valueOf((int)code));
    }

    public void setStatusCode(StatusCodes code) {
        this.setStatusCode(code.getIntCode());
    }

    public String getReasonPhrase() {
        return null;
    }

    public byte[] getReasonPhraseBytes() {
        return this.nettyResponse.status().reasonPhrase().getBytes();
    }

    public void setReasonPhrase(String reason) {
    }

    public void setReasonPhrase(byte[] reason) {
    }

    public HttpResponseMessage duplicate() {
        return null;
    }

    @Override
    public HttpServiceContext getServiceContext() {
        return this.context;
    }

    protected void processCookie(HttpCookie cookie, HeaderKeys header) {
        String userAgent;
        String result = null;
        if (Objects.nonNull(cookie) && Objects.nonNull(header) && Objects.nonNull(result = CookieEncoder.encodeCookie(cookie, header, this.config, userAgent = this.getServiceContext().getRequest().getHeader((HeaderKeys)HttpHeaderKeys.HDR_USER_AGENT).asString()))) {
            if (this.config.doNotAllowDuplicateSetCookies() && header.equals((GenericKeys)HttpHeaderKeys.HDR_SET_COOKIE)) {
                if (this.headers.contains(HttpHeaderKeys.HDR_SET_COOKIE.getName())) {
                    this.headers.set(header.getName(), (Object)result);
                }
            } else {
                this.headers.add(header.getName(), (Object)result);
            }
        }
    }

    public long getBytesWritten() {
        return this.getServiceContext().getNumBytesWritten();
    }

    private boolean isBodyAllowedForStatusCode() {
        int statusCode = this.getStatusCodeAsInt();
        return (statusCode < 100 || statusCode >= 200) && statusCode != 204 && statusCode != 304;
    }

    @Override
    public void readExternal(ObjectInput input) throws IOException, ClassNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("De-serializing into: " + this), (Object[])new Object[0]);
        }
        super.readExternal(input);
        if (-1091633150 == this.deserializationVersion) {
            this.setStatusCode(input.readShort());
        } else {
            this.setStatusCode(input.readInt());
        }
        this.setReasonPhrase(this.readByteArray(input));
    }

    @Override
    public void writeExternal(ObjectOutput output) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Serializing: " + this), (Object[])new Object[0]);
        }
        super.writeExternal(output);
        output.writeShort(this.getStatusCodeAsInt());
        this.writeByteArray(output, this.getReasonPhraseBytes());
    }

    public HttpResponse getResponse() {
        return this.nettyResponse;
    }
}

