/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.netty.message;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.internal.HttpChannelConfig;
import com.ibm.ws.http.channel.internal.HttpTrailersImpl;
import com.ibm.ws.http.channel.internal.cookies.CookieCacheData;
import com.ibm.ws.http.channel.internal.cookies.CookieHeaderByteParser;
import com.ibm.ws.http.netty.message.NettyHeader;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.genericbnf.HeaderField;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.genericbnf.exception.UnsupportedProtocolVersionException;
import com.ibm.wsspi.http.HttpCookie;
import com.ibm.wsspi.http.channel.HttpBaseMessage;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import com.ibm.wsspi.http.channel.HttpTrailers;
import com.ibm.wsspi.http.channel.values.ConnectionValues;
import com.ibm.wsspi.http.channel.values.ContentEncodingValues;
import com.ibm.wsspi.http.channel.values.ExpectValues;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import com.ibm.wsspi.http.channel.values.TransferEncodingValues;
import com.ibm.wsspi.http.channel.values.VersionValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.openliberty.http.netty.cookie.CookieDecoder;
import io.openliberty.http.netty.cookie.CookieEncoder;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class NettyBaseMessage
implements HttpBaseMessage,
Externalizable {
    private static final TraceComponent tc = Tr.register(NettyBaseMessage.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    protected static final int SERIALIZATION_V1 = -1091633151;
    protected static final int SERIALIZATION_V2 = -1091633150;
    protected transient int deserializationVersion = -1091633151;
    private boolean inbound = Boolean.FALSE;
    private boolean committed = Boolean.FALSE;
    private int limitOnNumberOfHeaders;
    protected HttpChannelConfig config;
    protected HttpMessage message;
    protected HttpHeaders headers;
    boolean initialized = Boolean.FALSE;
    protected long startTime = 0L;
    protected long endTime = 0L;
    private final Map<HttpHeaderKeys, CookieCacheData> cookieCacheMap = new HashMap<HttpHeaderKeys, CookieCacheData>();
    private transient CookieHeaderByteParser cookieParser;
    private HttpServiceContext serviceContext;
    private int limitOfTokenSize;
    private Map<String, String> headersMap = new HashMap<String, String>();
    private MessageType messageType;
    static final long serialVersionUID = 564145770237616102L;

    protected void init(HttpMessage message, HttpServiceContext serviceContext, HttpChannelConfig config) {
        if (!this.initialized) {
            this.initialized = Boolean.TRUE;
            this.message = message;
            this.headers = message.headers();
            this.config = config;
            this.serviceContext = serviceContext;
            this.limitOnNumberOfHeaders = config.getLimitOnNumberOfHeaders();
            this.limitOfTokenSize = config.getLimitOfFieldSize();
        }
    }

    public MessageType messageType() {
        return this.messageType;
    }

    public MessageType setMessageType(MessageType messageType) {
        this.messageType = messageType;
        return this.messageType;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void readExternal(ObjectInput input) throws IOException, ClassNotFoundException {
        boolean isTrailer;
        int i;
        int len = input.readInt();
        if (-1091633150 == len) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Deserializing a V2 object", (Object[])new Object[0]);
            }
            this.deserializationVersion = -1091633150;
            len = input.readInt();
        }
        this.headersMap = new HashMap<String, String>();
        int number = input.readInt();
        if (-1091633150 == this.deserializationVersion) {
            for (i = 0; i < number; ++i) {
                this.appendHeader(this.readByteArray(input), this.readByteArray(input));
            }
        } else {
            for (i = 0; i < number; ++i) {
                this.appendHeader((String)input.readObject(), (String)input.readObject());
            }
        }
        try {
            if (-1091633150 == this.deserializationVersion) {
                this.setVersion(this.readByteArray(input));
            } else {
                this.setVersion((String)input.readObject());
            }
        }
        catch (UnsupportedProtocolVersionException i2) {
            void exc;
            FFDCFilter.processException((Throwable)i2, (String)"com.ibm.ws.http.netty.message.NettyBaseMessage", (String)"169", (Object)this, (Object[])new Object[]{input});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unknown HTTP version", (Object[])new Object[0]);
            }
            IOException ioe = new IOException("Failed deserialization of version");
            ioe.initCause((Throwable)exc);
            throw ioe;
        }
        boolean bl = -1091633150 == this.deserializationVersion ? input.readBoolean() : (isTrailer = 1 == input.readByte());
        if (isTrailer) {
            // empty if block
        }
    }

    @Override
    public void writeExternal(ObjectOutput output) throws IOException {
        this.marshallCookieCache(this.cookieCacheMap.get(HttpHeaderKeys.HDR_COOKIE));
        this.marshallCookieCache(this.cookieCacheMap.get(HttpHeaderKeys.HDR_COOKIE2));
        this.marshallCookieCache(this.cookieCacheMap.get(HttpHeaderKeys.HDR_SET_COOKIE));
        this.marshallCookieCache(this.cookieCacheMap.get(HttpHeaderKeys.HDR_SET_COOKIE2));
        output.writeInt(-1091633150);
        output.writeInt(this.headersMap.size());
        output.writeInt(this.headersMap.size());
        for (Map.Entry<String, String> entry : this.headersMap.entrySet()) {
            this.writeByteArray(output, entry.getKey().getBytes());
            this.writeByteArray(output, entry.getValue().getBytes());
        }
        this.writeByteArray(output, this.getVersionValue().getByteArray());
    }

    protected byte[] readByteArray(ObjectInput input) throws IOException {
        int length = input.readInt();
        byte[] data = new byte[length];
        input.readFully(data);
        return data;
    }

    protected void writeByteArray(ObjectOutput output, byte[] data) throws IOException {
        output.writeInt(data.length);
        output.write(data);
    }

    public void setDebugContext(Object o) {
        throw new UnsupportedOperationException("setDebugContext unsupported in Netty context");
    }

    public HeaderField getHeader(String name) {
        return new NettyHeader(name, this.headers);
    }

    public HeaderField getHeader(byte[] name) {
        return this.getHeader(new String(name, StandardCharsets.UTF_8));
    }

    public HeaderField getHeader(HeaderKeys name) {
        return new NettyHeader(name, this.headers);
    }

    public List<HeaderField> getHeaders(String name) {
        List values = this.headers.getAll(name);
        ArrayList<HeaderField> result = new ArrayList<HeaderField>();
        for (String value : values) {
            result.add(new NettyHeader(name, value));
        }
        return result;
    }

    public List<HeaderField> getHeaders(byte[] name) {
        return this.getHeaders(new String(name, StandardCharsets.UTF_8));
    }

    public List<HeaderField> getHeaders(HeaderKeys name) {
        return this.getHeaders(name.getName());
    }

    public List<HeaderField> getAllHeaders() {
        List entries = this.headers.entries();
        ArrayList<HeaderField> headers = new ArrayList<HeaderField>();
        for (Map.Entry entry : entries) {
            headers.add(new NettyHeader((String)entry.getKey(), (String)entry.getValue()));
        }
        return headers;
    }

    public List<String> getAllHeaderNames() {
        return new ArrayList<String>(this.headers.names());
    }

    public Set<String> getAllHeaderNamesSet() {
        return this.headers.names();
    }

    public void appendHeader(byte[] header, byte[] value) {
        this.appendHeader(new String(header, StandardCharsets.UTF_8), new String(value, StandardCharsets.UTF_8));
    }

    public void appendHeader(byte[] header, byte[] value, int offset, int length) {
        throw new UnsupportedOperationException("appendHeader(2) not supported in Netty context");
    }

    public void appendHeader(byte[] header, String value) {
        this.appendHeader(new String(header, StandardCharsets.UTF_8), value);
    }

    public void appendHeader(HeaderKeys header, byte[] value) {
        this.appendHeader(header, new String(value, StandardCharsets.UTF_8));
    }

    public void appendHeader(HeaderKeys header, byte[] value, int offset, int length) {
        throw new UnsupportedOperationException("appendHeader(5) not supported in Netty context");
    }

    public void appendHeader(HeaderKeys header, String value) {
        this.appendHeader(header.getName(), value);
    }

    public void appendHeader(String header, byte[] value) {
        this.appendHeader(header, new String(value, StandardCharsets.UTF_8));
    }

    public void appendHeader(String header, byte[] value, int offset, int length) {
        throw new UnsupportedOperationException("appendHeader(8) not supported in Netty context");
    }

    public void appendHeader(String header, String value) {
        this.headers.add(header, (Object)value);
    }

    public int getNumberOfHeaderInstances(String header) {
        return this.headers.getAll(header).size();
    }

    public boolean containsHeader(byte[] header) {
        return this.containsHeader(new String(header, StandardCharsets.UTF_8));
    }

    public boolean containsHeader(HeaderKeys header) {
        return this.containsHeader(header.getName());
    }

    public boolean containsHeader(String header) {
        return this.headers.contains(header);
    }

    public int getNumberOfHeaderInstances(byte[] header) {
        return this.getNumberOfHeaderInstances(new String(header, StandardCharsets.UTF_8));
    }

    public int getNumberOfHeaderInstances(HeaderKeys header) {
        return this.getNumberOfHeaderInstances(header.getName());
    }

    public void removeHeader(byte[] header) {
        this.removeHeader(new String(header, StandardCharsets.UTF_8));
    }

    public void removeHeader(byte[] header, int instance) {
    }

    public void removeHeader(HeaderKeys header) {
        this.removeHeader(header.getName());
    }

    public void removeHeader(HeaderKeys header, int instance) {
    }

    public void removeHeader(String header) {
        this.headers.remove(header);
    }

    public void removeHeader(String header, int instance) {
    }

    public void removeAllHeaders() {
        this.headers.clear();
    }

    public void setHeader(byte[] header, byte[] value) {
    }

    public void setHeader(byte[] header, byte[] value, int offset, int length) {
    }

    public void setHeader(byte[] header, String value) {
    }

    public void setHeader(HeaderKeys header, byte[] value) {
    }

    public void setHeader(HeaderKeys header, byte[] value, int offset, int length) {
    }

    public void setHeader(HeaderKeys header, String value) {
        this.setHeader(header.getName(), value);
    }

    public HeaderField setHeaderIfAbsent(HeaderKeys header, String value) {
        Objects.requireNonNull(header);
        Objects.requireNonNull(value);
        if (!this.headers.contains(header.getName())) {
            this.headers.set(header.getName(), (Object)value);
        }
        return null;
    }

    public void setHeader(String header, byte[] value) {
    }

    public void setHeader(String header, byte[] value, int offset, int length) {
    }

    public void setHeader(String header, String value) {
        this.headers.set(header, (Object)value);
    }

    public void setLimitOnNumberOfHeaders(int number) {
        this.limitOnNumberOfHeaders = number;
    }

    public int getLimitOnNumberOfHeaders() {
        return this.limitOnNumberOfHeaders;
    }

    public void setLimitOfTokenSize(int size) {
        this.limitOfTokenSize = size;
    }

    public int getLimitOfTokenSize() {
        return this.limitOfTokenSize;
    }

    public byte[] getCookieValue(String name) {
        if (name == null) {
            return null;
        }
        HttpCookie cookie = this.getCookie(name);
        if (cookie == null) {
            return null;
        }
        String value = cookie.getValue();
        if (value == null || value.isEmpty()) {
            return null;
        }
        return value.getBytes(StandardCharsets.UTF_8);
    }

    protected void getAllCookieValues(String name, HttpHeaderKeys header, List<String> list) {
        if (!this.cookieCacheExists(header) && !this.containsHeader((HeaderKeys)header)) {
            return;
        }
        CookieCacheData cache = this.getCookieCache(header);
        if (cache.isDirty()) {
            this.parseAllCookies(cache, header);
        }
        cache.getAllCookieValues(name, list);
    }

    public HttpCookie getCookie(String name) {
        if (name == null) {
            return null;
        }
        HttpCookie cookie = null;
        if (this.messageType == MessageType.REQUEST) {
            cookie = this.getCookie(name, HttpHeaderKeys.HDR_COOKIE);
            if (cookie == null) {
                cookie = this.getCookie(name, HttpHeaderKeys.HDR_COOKIE2);
            }
        } else if (this.messageType == MessageType.RESPONSE && (cookie = this.getCookie(name, HttpHeaderKeys.HDR_SET_COOKIE)) == null) {
            cookie = this.getCookie(name, HttpHeaderKeys.HDR_SET_COOKIE2);
        }
        return cookie;
    }

    protected HttpCookie getCookie(String name, HttpHeaderKeys header) {
        if (name == null) {
            return null;
        }
        if (!this.isValidCookieHeader(header) && !this.containsHeader((HeaderKeys)header)) {
            return null;
        }
        CookieCacheData cache = this.getCookieCache(header);
        HttpCookie cookie = cache.getCookie(name);
        if (cookie != null) {
            return cookie;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getCookie --> " + name + " of type " + header.getName() + " not found"), (Object[])new Object[0]);
        }
        return null;
    }

    public List<HttpCookie> getAllCookies() {
        LinkedList<HttpCookie> list = new LinkedList<HttpCookie>();
        if (this.messageType == MessageType.REQUEST) {
            this.addAllCookies(HttpHeaderKeys.HDR_COOKIE, list);
            this.addAllCookies(HttpHeaderKeys.HDR_COOKIE2, list);
        } else if (this.messageType == MessageType.RESPONSE) {
            this.addAllCookies(HttpHeaderKeys.HDR_SET_COOKIE, list);
            this.addAllCookies(HttpHeaderKeys.HDR_SET_COOKIE2, list);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getAllCookies: Found " + list.size() + " cookie(s). Is incoming: " + this.isIncoming()), (Object[])new Object[0]);
        }
        return list;
    }

    public List<HttpCookie> getAllCookies(String name) {
        if (name == null) {
            return Collections.emptyList();
        }
        LinkedList<HttpCookie> results = new LinkedList<HttpCookie>();
        if (this.messageType == MessageType.REQUEST) {
            this.addAllCookies(name, HttpHeaderKeys.HDR_COOKIE, results);
            this.addAllCookies(name, HttpHeaderKeys.HDR_COOKIE2, results);
        } else {
            this.addAllCookies(name, HttpHeaderKeys.HDR_SET_COOKIE, results);
            this.addAllCookies(name, HttpHeaderKeys.HDR_SET_COOKIE2, results);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getAllCookies: Found " + results.size() + " cookie(s) matching [" + name + "]. Is incoming: " + this.isIncoming()), (Object[])new Object[0]);
        }
        return results;
    }

    public boolean setCookie(HttpCookie cookie, HttpHeaderKeys cookieType) {
        if (this.isCommitted()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Not adding cookie to committed message: " + cookie.getName() + " " + cookieType.getName()), (Object[])new Object[0]);
            }
            return false;
        }
        this.getCookieCache(cookieType).addNewCookie(cookie.clone());
        return true;
    }

    public boolean setCookie(String name, String value, HttpHeaderKeys cookieHeader) {
        return this.setCookie(new HttpCookie(name, value), cookieHeader);
    }

    @ManualTrace
    public boolean removeCookie(String name, HttpHeaderKeys cookieHeader) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("removeCookie: " + name), (Object[])new Object[0]);
        }
        if (this.isCommitted()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Not removing committed cookie: " + name), (Object[])new Object[0]);
            }
            return false;
        }
        HttpCookie cookie = this.getCookie(name, cookieHeader);
        if (cookie == null) {
            return false;
        }
        return this.getCookieCache(cookieHeader).removeCookie(cookie);
    }

    public boolean containsCookie(String name, HttpHeaderKeys cookieHeader) {
        boolean result = Boolean.FALSE;
        if (Objects.nonNull(name) && Objects.nonNull(cookieHeader)) {
            result = Objects.nonNull(this.getCookie(name, cookieHeader));
        }
        return result;
    }

    protected CookieCacheData getCookieCache(HttpHeaderKeys header) {
        if (!this.isValidCookieHeader(header)) {
            throw new IllegalArgumentException("Not a recognized cookie header: " + header.getName());
        }
        CookieCacheData cache = this.cookieCacheMap.computeIfAbsent(header, h -> new CookieCacheData((HttpHeaderKeys)h));
        this.parseNewCookieLinesIfNeeded(cache);
        return cache;
    }

    private boolean isValidCookieHeader(HttpHeaderKeys header) {
        return header == HttpHeaderKeys.HDR_COOKIE || header == HttpHeaderKeys.HDR_COOKIE2 || header == HttpHeaderKeys.HDR_SET_COOKIE || header == HttpHeaderKeys.HDR_SET_COOKIE2;
    }

    private void parseAllCookies(CookieCacheData cache, HttpHeaderKeys header) {
        List<HeaderField> headerList;
        int size;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Parsing all cookies for " + header.getName()), (Object[])new Object[0]);
        }
        if ((size = (headerList = this.getHeaders((HeaderKeys)header)).size()) == 0) {
            return;
        }
        for (int i = cache.getHeaderIndex(); i < size; ++i) {
            String headerValue = headerList.get(i).asString();
            cache.addParsedCookies(CookieDecoder.decode(headerValue, header));
            cache.incrementHeaderIndex();
        }
    }

    public List<String> getAllCookieValues(String name) {
        return null;
    }

    public boolean isIncoming() {
        return this.inbound;
    }

    public void incoming(boolean isInbound) {
        this.inbound = isInbound;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void setCommitted() {
        this.committed = Boolean.TRUE;
    }

    public void setCommitted(boolean committed) {
        this.committed = committed;
    }

    public void clear() {
        this.cookieCacheMap.clear();
        this.committed = false;
    }

    public void destroy() {
        this.clear();
    }

    public boolean isBodyExpected() {
        if (this.isChunkedEncodingSet()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Msg says chunked encoding: " + this), (Object[])new Object[0]);
            }
            return true;
        }
        if (0L < this.getContentLength()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Msg says content-length: " + this.getContentLength() + " " + this), (Object[])new Object[0]);
            }
            return true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("No body expected at base layer: " + this), (Object[])new Object[0]);
        }
        return false;
    }

    public boolean isBodyAllowed() {
        return 0L != this.getContentLength();
    }

    public void setContentLength(long length) {
        if (HttpUtil.isTransferEncodingChunked((HttpMessage)this.message)) {
            HttpUtil.setTransferEncodingChunked((HttpMessage)this.message, (boolean)false);
        }
        HttpUtil.setContentLength((HttpMessage)this.message, (long)length);
    }

    public long getContentLength() {
        return HttpUtil.isContentLengthSet((HttpMessage)this.message) ? HttpUtil.getContentLength((HttpMessage)this.message) : -1L;
    }

    public void setConnection(ConnectionValues value) {
    }

    public void setConnection(ConnectionValues[] values) {
    }

    public ConnectionValues[] getConnection() {
        return null;
    }

    public boolean isKeepAliveSet() {
        return HttpUtil.isKeepAlive((HttpMessage)this.message);
    }

    public boolean isConnectionSet() {
        return this.containsHeader((HeaderKeys)HttpHeaderKeys.HDR_CONNECTION);
    }

    public void setContentEncoding(ContentEncodingValues value) {
    }

    public void setContentEncoding(ContentEncodingValues[] values) {
    }

    public ContentEncodingValues[] getContentEncoding() {
        return null;
    }

    public void setTransferEncoding(TransferEncodingValues value) {
        throw new UnsupportedOperationException("Tried setting transfer encoding in Netty!");
    }

    public void setTransferEncoding(TransferEncodingValues[] values) {
        throw new UnsupportedOperationException("Tried setting transfer encoding in Netty!");
    }

    public TransferEncodingValues[] getTransferEncoding() {
        return null;
    }

    public boolean isChunkedEncodingSet() {
        return HttpUtil.isTransferEncodingChunked((HttpMessage)this.message);
    }

    public void setCurrentDate() {
    }

    public void setExpect(ExpectValues value) {
    }

    public byte[] getExpect() {
        return null;
    }

    public boolean isExpect100Continue() {
        return HttpUtil.is100ContinueExpected((HttpMessage)this.message);
    }

    public String getMIMEType() {
        return HttpUtil.getMimeType((HttpMessage)this.message).toString();
    }

    public void setMIMEType(String type) {
    }

    public Charset getCharset() {
        return null;
    }

    public void setCharset(Charset set) {
    }

    public HttpTrailers getTrailers() {
        return null;
    }

    public VersionValues getVersionValue() {
        if (this.message.headers().contains((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text())) {
            return VersionValues.V20;
        }
        return VersionValues.find((String)this.message.protocolVersion().text());
    }

    public String getVersion() {
        if (this.message.headers().contains((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text())) {
            return VersionValues.V20.getName();
        }
        return this.message.protocolVersion().text();
    }

    public void setVersion(VersionValues version) {
    }

    public void setVersion(String version) throws UnsupportedProtocolVersionException {
    }

    public void setVersion(byte[] version) throws UnsupportedProtocolVersionException {
    }

    public HttpTrailersImpl createTrailers() {
        return null;
    }

    public void processCookies() {
        if (MessageType.REQUEST == this.messageType) {
            this.marshallCookieCache(this.cookieCacheMap.get(HttpHeaderKeys.HDR_COOKIE));
            this.marshallCookieCache(this.cookieCacheMap.get(HttpHeaderKeys.HDR_COOKIE2));
        } else if (MessageType.RESPONSE == this.messageType) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Checking to see if we should mark the cookie cache as dirty - samesite is " + this.config.useSameSiteConfig() + " doNotAllowDuplicateSetCookie is " + this.config.doNotAllowDuplicateSetCookies()), (Object[])new Object[0]);
            }
            if (this.config.useSameSiteConfig() || this.config.doNotAllowDuplicateSetCookies()) {
                if (this.containsHeader((HeaderKeys)HttpHeaderKeys.HDR_SET_COOKIE)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Marking set-cookie cache dirty", (Object[])new Object[0]);
                    }
                    this.getCookieCache(HttpHeaderKeys.HDR_SET_COOKIE).setIsDirty(true);
                }
                if (this.containsHeader((HeaderKeys)HttpHeaderKeys.HDR_SET_COOKIE2)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Marking set-cookie2 cache dirty", (Object[])new Object[0]);
                    }
                    this.getCookieCache(HttpHeaderKeys.HDR_SET_COOKIE2).setIsDirty(true);
                }
            }
            this.marshallCookieCache(this.cookieCacheMap.get(HttpHeaderKeys.HDR_SET_COOKIE));
            this.marshallCookieCache(this.cookieCacheMap.get(HttpHeaderKeys.HDR_SET_COOKIE2));
        }
    }

    protected void marshallCookieCache(CookieCacheData cache) {
        if (cache == null || !cache.isDirty()) {
            return;
        }
        HttpHeaderKeys type = cache.getHeaderType();
        this.parseNewCookieLinesIfNeeded(cache);
        this.removeHeader((HeaderKeys)type);
        this.marshallCookies(cache.getParsedList(), (HeaderKeys)type);
        cache.setIsDirty(false);
    }

    @ManualTrace
    private void marshallCookies(List<HttpCookie> list, HeaderKeys header) {
        boolean filterDuplicates;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"marshallCookies", (Object[])new Object[0]);
        }
        HashMap<String, String> setCookieNames = null;
        boolean bl = filterDuplicates = this.config.doNotAllowDuplicateSetCookies() && (header == HttpHeaderKeys.HDR_SET_COOKIE || header == HttpHeaderKeys.HDR_SET_COOKIE2);
        if (filterDuplicates) {
            setCookieNames = new HashMap<String, String>();
        }
        String userAgent = null;
        if (this.getServiceContext() != null && this.getServiceContext().getRequest() != null) {
            userAgent = this.getServiceContext().getRequest().getHeader((HeaderKeys)HttpHeaderKeys.HDR_USER_AGENT).asString();
        }
        for (HttpCookie cookie : list) {
            String value = CookieEncoder.encodeCookie(cookie, header, this.config, userAgent);
            if (null == value) continue;
            if (filterDuplicates) {
                setCookieNames.put(cookie.getName(), value);
                continue;
            }
            this.appendHeader(header, value);
        }
        if (filterDuplicates && setCookieNames != null) {
            this.removeHeader(header.getName());
            for (String headerValue : setCookieNames.values()) {
                this.appendHeader(header, headerValue);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"marshallCookies");
        }
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public HttpServiceContext getServiceContext() {
        return this.serviceContext;
    }

    private boolean shouldParseCookieHeader(HttpHeaderKeys header) {
        if (header == HttpHeaderKeys.HDR_COOKIE || header == HttpHeaderKeys.HDR_COOKIE2) {
            return this.messageType == MessageType.REQUEST && this.isIncoming();
        }
        return this.messageType == MessageType.RESPONSE && this.isIncoming();
    }

    protected boolean cookieCacheExists(HttpHeaderKeys header) {
        return this.cookieCacheMap.containsKey(header);
    }

    private void parseNewCookieLinesIfNeeded(CookieCacheData cache) {
        if (!this.shouldParseCookieHeader(cache.getHeaderType())) {
            return;
        }
        HttpHeaderKeys header = cache.getHeaderType();
        List<HeaderField> fields = this.getHeaders((HeaderKeys)header);
        int size = fields.size();
        for (int i = cache.getHeaderIndex(); i < size; ++i) {
            String lineValue = fields.get(i).asString();
            List<HttpCookie> decoded = CookieDecoder.decode(lineValue, header);
            cache.addParsedCookies(decoded);
            cache.incrementHeaderIndex();
        }
    }

    protected void addAllCookies(HttpHeaderKeys header, List<HttpCookie> list) {
        if (!this.containsHeader((HeaderKeys)header) && !this.cookieCacheExists(header)) {
            return;
        }
        CookieCacheData cache = this.getCookieCache(header);
        cache.getAllCookies(list);
    }

    protected void addAllCookies(String name, HttpHeaderKeys header, List<HttpCookie> list) {
        if (!this.containsHeader((HeaderKeys)header) && !this.cookieCacheExists(header)) {
            return;
        }
        CookieCacheData cache = this.getCookieCache(header);
        cache.getAllCookies(name, list);
    }

    public static enum MessageType {
        REQUEST,
        RESPONSE;

    }
}

