/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.logging.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TrConfigurator;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.http.logging.LogFile;
import com.ibm.wsspi.kernel.service.utils.MetatypeUtils;
import com.ibm.wsspi.logging.TextFileOutputStreamFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class LoggerOffThread
implements LogFile {
    protected static final TraceComponent tc = Tr.register(LoggerOffThread.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    protected static final long TIMEOUT = 10000L;
    private File myFile = null;
    private String myName = null;
    private String myFullName = null;
    private FileChannel myChannel = null;
    private WorkerThread myWorker = null;
    private State state = State.IDLE;
    private long maxFileSize = -1L;
    private int maxBackupFiles = 1;
    private String rolloverStartTime = "";
    private long rolloverInterval = -1L;

    public LoggerOffThread(String name) throws FileNotFoundException {
        this.setFilename(name);
    }

    protected LoggerOffThread() {
    }

    public void setFilename(String name) throws FileNotFoundException {
        boolean started = this.isStarted();
        if (started) {
            this.stop();
        }
        this.myFullName = name;
        this.myFile = new File(name);
        this.myName = this.myFile.getName();
        this.myChannel = this.createFileOutputStream().getChannel();
        if (started) {
            this.start();
        }
    }

    protected FileOutputStream createFileOutputStream() throws FileNotFoundException {
        FileOutputStream fileOutputStream = null;
        TextFileOutputStreamFactory f = TrConfigurator.getFileOutputStreamFactory();
        try {
            fileOutputStream = f.createOutputStream(this.myFile, true);
        }
        catch (IOException e) {
            fileOutputStream = new FileOutputStream(this.myFile, true);
        }
        return fileOutputStream;
    }

    protected FileChannel getChannel() {
        return this.myChannel;
    }

    protected void setChannel(FileChannel channel) {
        this.myChannel = channel;
    }

    protected File getFile() {
        return this.myFile;
    }

    public String getFilePathName() {
        return this.myFullName;
    }

    public String getFileName() {
        return this.myName;
    }

    public boolean log(WsByteBuffer data) {
        if (null == data) {
            return false;
        }
        if (State.RUNNING != this.state) {
            data.release();
            return false;
        }
        return this.myWorker.enqueue(data);
    }

    public boolean start() {
        if (State.IDLE != this.state) {
            return false;
        }
        if (null == this.myWorker) {
            this.myWorker = new WorkerThread();
        }
        this.myWorker.start();
        this.state = State.RUNNING;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)(this.getFileName() + ": started\n" + this), (Object[])new Object[0]);
        }
        return true;
    }

    public boolean stop() {
        if (State.RUNNING != this.state) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(this.myName + ": Logger already stopped"), (Object[])new Object[0]);
            }
            return true;
        }
        this.state = State.IDLE;
        this.myWorker.triggerStop();
        this.myWorker = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)(this.getFileName() + ": stopped"), (Object[])new Object[0]);
        }
        return true;
    }

    public boolean disable() {
        block4: {
            if (State.RUNNING == this.state) {
                this.stop();
            }
            try {
                this.myChannel.close();
            }
            catch (IOException ioe) {
                FFDCFilter.processException((Throwable)ioe, (String)(this.getClass().getName() + ".disable"), (String)"124", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Failed to close the output file: " + this.myChannel), (Object[])new Object[0]);
            }
        }
        this.state = State.DISABLED;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)(this.getFileName() + ": disabled"), (Object[])new Object[0]);
        }
        return true;
    }

    public boolean isStarted() {
        return State.RUNNING == this.state;
    }

    public boolean setMaximumSize(long size) {
        if (-1L > size) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(this.myName + ": Invalid file size-> " + size), (Object[])new Object[0]);
            }
            return false;
        }
        this.maxFileSize = 0L == size ? -1L : size;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.myName + ": Set maximum size to " + this.maxFileSize), (Object[])new Object[0]);
        }
        return true;
    }

    public long getMaximumSize() {
        return this.maxFileSize;
    }

    public int getMaximumBackupFiles() {
        return this.maxBackupFiles;
    }

    public boolean setMaximumBackupFiles(int number) {
        if (0 > number) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(this.myName + ": Invalid negative number of backup files-> " + number), (Object[])new Object[0]);
            }
            return false;
        }
        this.maxBackupFiles = number;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.myName + ": Set maximum files to " + this.maxBackupFiles), (Object[])new Object[0]);
        }
        return true;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(super.toString());
        buffer.append("\n  FilePathName: " + this.myFullName);
        buffer.append("\n  FileName: " + this.myName);
        buffer.append("\n  MaxFileSize: " + this.maxFileSize);
        buffer.append("\n  MaxBackupFiles: " + this.maxBackupFiles);
        buffer.append("\n  State: " + (Object)((Object)this.state));
        buffer.append("\n  Worker: " + this.myWorker);
        return buffer.toString();
    }

    public void setRolloverStartTime(String time) {
        this.rolloverStartTime = time;
    }

    public String getRolloverStartTime() {
        return this.rolloverStartTime;
    }

    public void setRolloverInterval(String interval) {
        this.rolloverInterval = MetatypeUtils.evaluateDuration((String)interval, (TimeUnit)TimeUnit.MINUTES);
    }

    public long getRolloverInterval() {
        return this.rolloverInterval;
    }

    public WorkerThread getWorkerThread() {
        return this.myWorker;
    }

    protected class WorkerThread
    extends Thread {
        private WorkerState workerState = WorkerState.RUNNING;
        private final Object stopLock = new Object(){};
        private final Object lock = new Object(){};
        private LinkedList<WsByteBuffer> queue = new LinkedList();
        private LinkedList<File> backups = null;
        private String fileinfo = null;
        private String extensioninfo = null;
        private SimpleDateFormat myFormat = null;
        private long bytesWritten = 0L;

        protected WorkerThread() {
        }

        @Override
        public void start() {
            String fileinfoName;
            File[] backupFiles;
            File directory;
            if (0 <= LoggerOffThread.this.getMaximumBackupFiles()) {
                this.myFormat = new SimpleDateFormat("_yy.MM.dd_HH.mm.ss", Locale.US);
                int index = LoggerOffThread.this.getFileName().lastIndexOf(".");
                if (-1 != index) {
                    this.fileinfo = LoggerOffThread.this.getFilePathName().substring(0, index += LoggerOffThread.this.getFilePathName().length() - LoggerOffThread.this.getFileName().length());
                    this.extensioninfo = LoggerOffThread.this.getFilePathName().substring(index);
                } else {
                    this.fileinfo = LoggerOffThread.this.getFilePathName();
                    this.extensioninfo = "";
                }
                this.backups = new LinkedList();
            }
            if (LoggerOffThread.this.getMaximumBackupFiles() > 0 && (directory = new File(LoggerOffThread.this.getFilePathName()).getParentFile()) != null && directory.isDirectory() && (backupFiles = directory.listFiles((arg_0, arg_1) -> WorkerThread.lambda$start$0(fileinfoName = new File(this.fileinfo).getName(), arg_0, arg_1))) != null) {
                Arrays.sort(backupFiles, Comparator.comparingLong(File::lastModified));
                this.backups.addAll(Arrays.asList(backupFiles));
                while (this.backups.size() > LoggerOffThread.this.getMaximumBackupFiles()) {
                    File oldestFile = this.backups.poll();
                    if (oldestFile == null || !oldestFile.exists()) continue;
                    oldestFile.delete();
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Deleted old log file: " + oldestFile.getName()), (Object[])new Object[0]);
                }
            }
            try {
                this.bytesWritten = LoggerOffThread.this.myChannel.size();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("bytesWritten : " + this.bytesWritten), (Object[])new Object[0]);
                }
            }
            catch (IOException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Unable to aquire current file size. Setting to 0", (Object[])new Object[0]);
                }
                this.bytesWritten = 0L;
            }
            super.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean enqueue(WsByteBuffer buff) {
            if (WorkerState.RUNNING != this.workerState) {
                buff.release();
                return false;
            }
            Object object = this.lock;
            synchronized (object) {
                this.queue.add(buff);
                this.lock.notify();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void triggerStop() {
            Object object;
            block15: {
                if (WorkerState.RUNNING != this.workerState) {
                    return;
                }
                this.workerState = WorkerState.STOPPING;
                object = this.lock;
                synchronized (object) {
                    this.lock.notify();
                }
                try {
                    if (WorkerState.STOPPING != this.workerState) break block15;
                    object = this.stopLock;
                    synchronized (object) {
                        if (WorkerState.STOPPING == this.workerState) {
                            this.stopLock.wait(10000L);
                        }
                    }
                }
                catch (InterruptedException ie) {
                    FFDCFilter.processException((Throwable)ie, (String)(this.getClass().getName() + ".triggerStop"), (String)"201", (Object)this);
                }
            }
            object = this.lock;
            synchronized (object) {
                while (!this.queue.isEmpty()) {
                    this.queue.removeFirst().release();
                }
            }
            if (null != this.backups) {
                this.myFormat = null;
                this.backups = null;
            }
        }

        private void renameFile(File source, File target) {
            boolean rc;
            if (!source.exists()) {
                return;
            }
            if (target.exists()) {
                target.delete();
            }
            if (!(rc = source.renameTo(target)) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(LoggerOffThread.this.getFileName() + ": Unable to rename " + source + " to " + target), (Object[])new Object[0]);
            }
        }

        private void addBackup() {
            String newname = this.fileinfo + this.myFormat.format(new Date(HttpDispatcher.getApproxTime())) + this.extensioninfo;
            File newFile = new File(newname);
            this.renameFile(LoggerOffThread.this.getFile(), newFile);
            this.backups.addFirst(newFile);
            if (LoggerOffThread.this.getMaximumBackupFiles() > 0) {
                while (this.backups.size() >= LoggerOffThread.this.getMaximumBackupFiles()) {
                    File oldest = this.backups.removeLast();
                    if (null == oldest || !oldest.exists()) continue;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(LoggerOffThread.this.getFileName() + ": Purging oldest backup-> " + oldest.getName()), (Object[])new Object[0]);
                    }
                    oldest.delete();
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(LoggerOffThread.this.getFileName() + ": number of backup files-> " + this.backups.size()), (Object[])new Object[0]);
            }
        }

        protected void rotate() {
            block8: {
                block7: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(LoggerOffThread.this.getFileName() + ": Rotating output log"), (Object[])new Object[0]);
                    }
                    this.bytesWritten = 0L;
                    try {
                        LoggerOffThread.this.getChannel().close();
                    }
                    catch (IOException ioe) {
                        FFDCFilter.processException((Throwable)ioe, (String)(this.getClass().getName() + ".rotate"), (String)"547", (Object)this);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                        Tr.debug((TraceComponent)tc, (String)(LoggerOffThread.this.getFileName() + ": Failed to close the output file; " + ioe), (Object[])new Object[0]);
                    }
                }
                try {
                    if (0 <= LoggerOffThread.this.getMaximumBackupFiles()) {
                        this.addBackup();
                    }
                    LoggerOffThread.this.setChannel(LoggerOffThread.this.createFileOutputStream().getChannel());
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)(this.getClass().getName() + ".rotate"), (String)"564", (Object)this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block8;
                    Tr.event((TraceComponent)tc, (String)(LoggerOffThread.this.getFileName() + ": error in rotate; " + t), (Object[])new Object[0]);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Completed rotation : " + LoggerOffThread.this.getFileName()), (Object[])new Object[0]);
            }
        }

        private boolean isOverFileLimit(int addition) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("isOverFileLimit, " + LoggerOffThread.this.getMaximumSize()), (Object[])new Object[0]);
            }
            if (-1L == LoggerOffThread.this.getMaximumSize()) {
                return false;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("bytesWritten : " + this.bytesWritten + ", addition : " + addition), (Object[])new Object[0]);
            }
            if (this.bytesWritten + (long)addition < LoggerOffThread.this.getMaximumSize()) {
                return false;
            }
            long newlen = this.bytesWritten + (long)addition;
            return newlen > LoggerOffThread.this.getMaximumSize() || 0L > newlen;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void logData(WsByteBuffer data) {
            int written;
            int length = data.remaining();
            if (this.isOverFileLimit(length)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"logData, rotate", (Object[])new Object[0]);
                }
                this.rotate();
            }
            try {
                ByteBuffer buffer = data.getWrappedByteBuffer();
                for (written = 0; written < length; written += LoggerOffThread.this.getChannel().write(buffer)) {
                }
            }
            catch (IOException ioe) {
                FFDCFilter.processException((Throwable)ioe, (String)(this.getClass().getName() + ".logData"), (String)"235", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)(LoggerOffThread.this.getFileName() + ": error writing to log; " + ioe), (Object[])new Object[0]);
                }
            }
            finally {
                this.bytesWritten += (long)written;
                data.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            LinkedList<Object> workList = new LinkedList();
            while (true) {
                if (!this.queue.isEmpty()) {
                    object = this.lock;
                    synchronized (object) {
                        LinkedList tmpList = workList;
                        workList = this.queue;
                        this.queue = tmpList;
                    }
                    while (!workList.isEmpty()) {
                        try {
                            this.logData((WsByteBuffer)workList.removeFirst());
                        }
                        catch (Throwable t) {
                            FFDCFilter.processException((Throwable)t, (String)(this.getClass().getName() + ".run"), (String)"588", (Object)this);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)(LoggerOffThread.this.getFileName() + ": Unexpected exception in logData; " + t), (Object[])new Object[0]);
                        }
                    }
                }
                if (WorkerState.RUNNING != this.workerState) break;
                if (!this.queue.isEmpty()) continue;
                try {
                    Object t = this.lock;
                    synchronized (t) {
                        if (!this.queue.isEmpty()) {
                            continue;
                        }
                        this.lock.wait(10000L);
                        continue;
                    }
                }
                catch (InterruptedException ie) {
                    FFDCFilter.processException((Throwable)ie, (String)(this.getClass().getName() + ".run"), (String)"278", (Object)this);
                    continue;
                }
                break;
            }
            this.workerState = WorkerState.STOPPED;
            object = this.stopLock;
            synchronized (object) {
                this.stopLock.notify();
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            sb.append("\n    Current file size: ");
            sb.append(LoggerOffThread.this.getFile().length());
            sb.append("\n    Number of backups: ");
            sb.append(null != this.backups ? this.backups.size() : 0);
            sb.append("\n    State: ");
            sb.append((Object)this.workerState);
            return sb.toString();
        }

        private static /* synthetic */ boolean lambda$start$0(String fileinfoName, File dir, String name) {
            return name.startsWith(fileinfoName);
        }
    }

    private static enum State {
        IDLE,
        RUNNING,
        DISABLED;

    }

    protected static enum WorkerState {
        RUNNING,
        STOPPING,
        STOPPED;

    }
}

