/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.logging.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.ws.http.logging.internal.AccessLogger;
import com.ibm.ws.http.logging.internal.DebugLogger;
import com.ibm.ws.http.logging.internal.DisabledLogger;
import com.ibm.ws.http.logging.internal.FRCALogger;
import com.ibm.wsspi.http.logging.AccessLog;
import com.ibm.wsspi.http.logging.DebugLog;
import com.ibm.wsspi.http.logging.HTTPLoggingService;
import com.ibm.wsspi.http.logging.LogUtils;
import java.util.Map;

public class HTTPLoggingServiceImpl
implements HTTPLoggingService {
    private static final TraceComponent tc = Tr.register(HTTPLoggingServiceImpl.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private boolean bRunning = false;
    private AccessLog ncsaLog = DisabledLogger.getRef();
    private AccessLog frcaLog = DisabledLogger.getRef();
    private DebugLog debugLog = DisabledLogger.getRef();

    public HTTPLoggingServiceImpl(Map<String, Object> config) {
        if (Boolean.parseBoolean((String)config.get("error.enabled"))) {
            this.parseErrorLog(config);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Error log is disabled by config", (Object[])new Object[0]);
        }
        if (Boolean.parseBoolean((String)config.get("access.enabled"))) {
            this.parseAccessLog(config);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Access log is disabled by config", (Object[])new Object[0]);
        }
        if (Boolean.parseBoolean((String)config.get("frca.enabled"))) {
            this.parseFRCALog(config);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"FRCA log is disabled by config", (Object[])new Object[0]);
        }
        HttpDispatcher.getFramework().registerService(HTTPLoggingService.class, (Object)this);
    }

    private void parseAccessLog(Map<String, Object> config) {
        String backups;
        String filename = (String)config.get("access.filePath");
        if (null == filename || 0 == filename.trim().length()) {
            return;
        }
        try {
            this.ncsaLog = new AccessLogger(filename.trim());
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)(this.getClass().getName() + ".parseAccessLog"), (String)"1", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Logging service was unable to open a file: " + filename + "; " + t), (Object[])new Object[0]);
            }
            return;
        }
        String format = (String)config.get("access.logFormat");
        this.ncsaLog.setFormat(LogUtils.convertNCSAFormat((String)format));
        String size = (String)config.get("access.maximumSize");
        if (null != size && !this.ncsaLog.setMaximumSize((long)this.convertInt(size, 0) * 0x100000L) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Logging service has invalid access log size: " + size), (Object[])new Object[0]);
        }
        if (null != (backups = (String)config.get("access.maximumBackupFiles"))) {
            this.ncsaLog.setMaximumBackupFiles(this.convertInt(backups, 1));
        }
    }

    private void parseErrorLog(Map<String, Object> config) {
        String backups;
        String filename = (String)config.get("error.filePath");
        if (null == filename || 0 == filename.trim().length()) {
            return;
        }
        try {
            this.debugLog = new DebugLogger(filename);
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)(this.getClass().getName() + ".parseErrorLog"), (String)"1", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Logging service was unable to open debug file: " + filename + "; " + t), (Object[])new Object[0]);
            }
            return;
        }
        String levelName = (String)config.get("error.logLevel");
        this.debugLog.setCurrentLevel(LogUtils.convertDebugLevel((String)levelName));
        String size = (String)config.get("error.maximumSize");
        if (null != size && !this.debugLog.setMaximumSize((long)this.convertInt(size, 0) * 0x100000L) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Logging service has invalid error log size: " + size), (Object[])new Object[0]);
        }
        if (null != (backups = (String)config.get("error.maximumBackupFiles"))) {
            this.debugLog.setMaximumBackupFiles(this.convertInt(backups, 1));
        }
    }

    private void parseFRCALog(Map<String, Object> config) {
        String backups;
        String filename = (String)config.get("frca.filePath");
        if (null == filename || 0 == filename.trim().length()) {
            return;
        }
        try {
            this.frcaLog = new FRCALogger(filename);
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)(this.getClass().getName() + ".parseFRCALog"), (String)"1", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Logging service was unable to open FRCA file: " + filename + "; " + t), (Object[])new Object[0]);
            }
            return;
        }
        String format = (String)config.get("frca.logFormat");
        this.frcaLog.setFormat(LogUtils.convertNCSAFormat((String)format));
        String size = (String)config.get("frca.maximumSize");
        if (null != size && !this.frcaLog.setMaximumSize((long)this.convertInt(size, 0) * 0x100000L) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Logging service has invalid frca log size: " + size), (Object[])new Object[0]);
        }
        if (null != (backups = (String)config.get("frca.maximumBackupsFiles"))) {
            this.frcaLog.setMaximumBackupFiles(this.convertInt(backups, 1));
        }
    }

    public void start() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"start", (Object[])new Object[0]);
        }
        if (!this.bRunning) {
            this.ncsaLog.start();
            this.frcaLog.start();
            this.debugLog.start();
            this.bRunning = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public void stop() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stop", (Object[])new Object[0]);
        }
        if (this.bRunning) {
            this.bRunning = false;
            this.ncsaLog.stop();
            this.frcaLog.stop();
            this.debugLog.stop();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroy", (Object[])new Object[0]);
        }
        this.bRunning = false;
        this.ncsaLog.disable();
        this.frcaLog.disable();
        this.debugLog.disable();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    public AccessLog getAccessLog() {
        return this.ncsaLog;
    }

    public AccessLog getFRCALog() {
        return this.frcaLog;
    }

    public DebugLog getDebugLog() {
        return this.debugLog;
    }

    private int convertInt(String input, int defaultValue) {
        try {
            return Integer.parseInt(input.trim());
        }
        catch (NumberFormatException nfe) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Malformed input: " + input), (Object[])new Object[0]);
            }
            return defaultValue;
        }
    }
}

