/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.logging.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.genericbnf.internal.GenericUtils;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.ws.http.logging.internal.LoggerOnThread;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.genericbnf.HeaderField;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.http.channel.HttpChannelUtils;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import com.ibm.wsspi.http.logging.AccessLog;
import java.io.FileNotFoundException;
import java.util.Iterator;

public class FRCALogger
extends LoggerOnThread
implements AccessLog {
    private static final TraceComponent tc = Tr.register(FRCALogger.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private AccessLog.Format myFormat = AccessLog.Format.COMMON;

    public FRCALogger(String filename) throws FileNotFoundException {
        super(filename);
    }

    public AccessLog.Format getFormat() {
        return this.myFormat;
    }

    public void setFormat(AccessLog.Format format) {
        this.myFormat = format;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Set access format to " + format), (Object[])new Object[0]);
        }
    }

    public void log(HttpRequestMessage request, HttpResponseMessage response, String version, String userId, String remoteAddr, long numBytes) {
        block16: {
            if (!this.isStarted()) {
                return;
            }
            try {
                StringBuilder sb = new StringBuilder(128);
                sb.append(remoteAddr);
                if (null == userId) {
                    sb.append(" - - [");
                } else {
                    sb.append(" - ");
                    sb.append(userId);
                    sb.append(" [");
                }
                sb.append(HttpDispatcher.getDateFormatter().getNCSATime());
                sb.append("] \"");
                sb.append(request.getMethodValue().getName());
                sb.append(' ');
                sb.append(request.getRequestURI());
                String query = request.getQueryString();
                if (null != query) {
                    sb.append('?');
                    sb.append(GenericUtils.nullOutPasswords(query, (byte)38));
                }
                sb.append(' ');
                sb.append(version);
                sb.append("\" ");
                sb.append(response.getStatusCodeAsInt());
                sb.append(' ');
                if (-1L != response.getContentLength()) {
                    sb.append(response.getContentLength());
                } else {
                    sb.append(numBytes);
                }
                if (AccessLog.Format.COMBINED.equals((Object)this.getFormat())) {
                    String val = request.getHeader((HeaderKeys)HttpHeaderKeys.HDR_REFERER).asString();
                    if (null == val) {
                        sb.append(" -");
                    } else {
                        sb.append(" \"");
                        sb.append(val);
                        sb.append("\"");
                    }
                    val = request.getHeader((HeaderKeys)HttpHeaderKeys.HDR_USER_AGENT).asString();
                    if (null == val) {
                        sb.append(" -");
                    } else {
                        sb.append(" \"");
                        sb.append(val);
                        sb.append('\"');
                    }
                    int count = request.getNumberOfHeaderInstances((HeaderKeys)HttpHeaderKeys.HDR_COOKIE);
                    if (0 == count) {
                        sb.append(" -");
                    } else {
                        sb.append(" \"");
                        Iterator it = request.getHeaders((HeaderKeys)HttpHeaderKeys.HDR_COOKIE).iterator();
                        sb.append(((HeaderField)it.next()).asString());
                        while (it.hasNext()) {
                            sb.append(", ");
                            sb.append(((HeaderField)it.next()).asString());
                        }
                        sb.append('\"');
                    }
                }
                sb.append("\r\n");
                WsByteBuffer wsbb = HttpDispatcher.getBufferManager().allocate(sb.length());
                wsbb.put(HttpChannelUtils.getBytes((StringBuilder)sb));
                wsbb.flip();
                super.log(wsbb);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)(this.getClass().getName() + ".log"), (String)"1", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block16;
                Tr.event((TraceComponent)tc, (String)("Exception while writing log msg; " + t), (Object[])new Object[0]);
            }
        }
    }

    public void log(byte[] message) {
        block3: {
            if (!this.isStarted()) {
                return;
            }
            try {
                WsByteBuffer wsbb = HttpDispatcher.getBufferManager().allocate(message.length + 2);
                wsbb.put(message);
                wsbb.flip();
                super.log(wsbb);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)(this.getClass().getName() + ".log"), (String)"2", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block3;
                Tr.event((TraceComponent)tc, (String)("Error writing to log; " + t), (Object[])new Object[0]);
            }
        }
    }

    public void log(String message) {
        if (this.isStarted()) {
            this.log(GenericUtils.getEnglishBytes(message));
        }
    }

    @Override
    public String toString() {
        return super.toString() + "\n  NCSA Format: " + this.getFormat();
    }
}

