/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.logging.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.genericbnf.internal.GenericUtils;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.ws.http.logging.internal.LoggerOnThread;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.http.channel.HttpChannelUtils;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import com.ibm.wsspi.http.logging.DebugLog;
import java.io.FileNotFoundException;

public class DebugLogger
extends LoggerOnThread
implements DebugLog {
    private static final TraceComponent tc = Tr.register(DebugLogger.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private DebugLog.Level myLevel = DebugLog.Level.WARN;

    public DebugLogger(String filename) throws FileNotFoundException {
        super(filename);
    }

    public DebugLog.Level getCurrentLevel() {
        return this.myLevel;
    }

    public void setCurrentLevel(DebugLog.Level logLevel) {
        this.myLevel = logLevel;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Set the loglevel to " + logLevel), (Object[])new Object[0]);
        }
    }

    public boolean isEnabled(DebugLog.Level logLevel) {
        return 0 <= this.myLevel.compareTo((Enum)logLevel);
    }

    public void log(DebugLog.Level logLevel, byte[] message, HttpServiceContext hsc) {
        block5: {
            if (!this.isEnabled(logLevel) || null == message) {
                return;
            }
            try {
                StringBuilder sb = new StringBuilder(125);
                sb.append('[');
                sb.append(HttpDispatcher.getDateFormatter().getRFC1123Time());
                sb.append("] [");
                sb.append(logLevel.name());
                sb.append("] [");
                if (null == hsc) {
                    sb.append("-/-");
                } else {
                    sb.append(hsc.getRemoteAddr().getHostAddress());
                    sb.append(':');
                    sb.append(hsc.getRemotePort());
                    sb.append('/');
                    sb.append(hsc.getLocalAddr().getHostAddress());
                    sb.append(':');
                    sb.append(hsc.getLocalPort());
                }
                sb.append("] ");
                byte[] data = HttpChannelUtils.getBytes((StringBuilder)sb);
                WsByteBuffer wsbb = HttpDispatcher.getBufferManager().allocateDirect(data.length + message.length + 2);
                wsbb.put(data);
                wsbb.put(message);
                wsbb.put(CRLF);
                wsbb.flip();
                super.log(wsbb);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)(this.getClass().getName() + ".log"), (String)"1", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block5;
                Tr.event((TraceComponent)tc, (String)("Error writing to log; " + t), (Object[])new Object[0]);
            }
        }
    }

    public void log(DebugLog.Level logLevel, String message, HttpServiceContext hsc) {
        if (this.isEnabled(logLevel) && null != message) {
            this.log(logLevel, GenericUtils.getEnglishBytes(message), hsc);
        }
    }

    public void log(DebugLog.Level logLevel, byte[] message, String remoteIP, String remotePort, String localIP, String localPort) {
        block3: {
            if (!this.isEnabled(logLevel) || null == message) {
                return;
            }
            try {
                StringBuilder sb = new StringBuilder(125);
                sb.append('[');
                sb.append(HttpDispatcher.getDateFormatter().getRFC1123Time());
                sb.append("] [");
                sb.append(logLevel.name());
                sb.append("] [");
                sb.append(remoteIP);
                sb.append(':');
                sb.append(remotePort);
                sb.append('/');
                sb.append(localIP);
                sb.append(':');
                sb.append(localPort);
                sb.append("] ");
                byte[] data = HttpChannelUtils.getBytes((StringBuilder)sb);
                WsByteBuffer wsbb = HttpDispatcher.getBufferManager().allocateDirect(data.length + message.length + 2);
                wsbb.put(data);
                wsbb.put(message);
                wsbb.put(CRLF);
                wsbb.flip();
                super.log(wsbb);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)(this.getClass().getName() + ".log"), (String)"3", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block3;
                Tr.event((TraceComponent)tc, (String)("Error writing to log; " + t), (Object[])new Object[0]);
            }
        }
    }

    public void log(DebugLog.Level logLevel, String message, String remoteIP, String remotePort, String localIP, String localPort) {
        if (this.isEnabled(logLevel) && null != message) {
            this.log(logLevel, GenericUtils.getEnglishBytes(message), remoteIP, remotePort, localIP, localPort);
        }
    }

    @Override
    public String toString() {
        return super.toString() + "\n  LogLevel: " + this.getCurrentLevel();
    }
}

