/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.productinfo.DuplicateProductInfoException;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.kernel.productinfo.ProductInfoParseException;
import com.ibm.ws.kernel.productinfo.ProductInfoReplaceException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.http.WelcomePage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={WelcomePage.class}, property={"service.vendor=IBM"})
public class DefaultWelcomePage
implements WelcomePage {
    private Bundle bundle;
    private String version;
    static final long serialVersionUID = 8009737131008840492L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Activate
    protected void activate(BundleContext context) {
        this.bundle = context.getBundle();
        try {
            ProductInfo info = (ProductInfo)ProductInfo.getAllProductInfo().get("io.openliberty");
            if (info != null) {
                this.version = info.getVersion();
            }
        }
        catch (DuplicateProductInfoException | ProductInfoParseException | ProductInfoReplaceException throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.http.internal.DefaultWelcomePage", (String)"49", (Object)this, (Object[])new Object[]{context});
        }
    }

    public InputStream openWelcomePage(String url) {
        if ("/".equals(url)) {
            url = "/index.html";
        }
        if ("/version.js".equals(url)) {
            StringBuilder versionJs = new StringBuilder();
            versionJs.append("var current = {\r\n");
            versionJs.append(" version: \"");
            if (this.version != null) {
                versionJs.append(this.version);
            }
            versionJs.append("\"\r\n");
            versionJs.append("}");
            return new ByteArrayInputStream(versionJs.toString().getBytes(StandardCharsets.UTF_8));
        }
        return this.safeOpen("/OSGI-INF/welcome" + url);
    }

    private InputStream safeOpen(String file) {
        URL url = this.bundle.getEntry(file);
        if (url != null) {
            try {
                return url.openStream();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.http.internal.DefaultWelcomePage", (String)"80", (Object)this, (Object[])new Object[]{file});
            }
        }
        return null;
    }

    public InputStream openNotFoundPage() {
        return this.safeOpen("/OSGI-INF/notFound/index.html");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.internal.DefaultWelcomePage", DefaultWelcomePage.class, (String)"HttpTransport", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    }
}

