/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.dispatcher.internal.channel;

import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.http.channel.internal.HttpTrailerGeneratorImpl;
import com.ibm.ws.http.channel.internal.HttpTrailersImpl;
import com.ibm.ws.http.channel.internal.outbound.HttpOutputStreamImpl;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.ws.http.dispatcher.internal.channel.HttpDispatcherLink;
import com.ibm.wsspi.genericbnf.HeaderField;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.genericbnf.exception.UnsupportedProtocolVersionException;
import com.ibm.wsspi.http.HttpCookie;
import com.ibm.wsspi.http.HttpResponse;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import com.ibm.wsspi.http.channel.values.VersionValues;
import com.ibm.wsspi.http.ee7.HttpOutputStreamEE7;
import io.openliberty.http.ext.HttpResponseExt;
import java.util.ArrayList;
import java.util.List;

@Trivial
public class HttpResponseImpl
implements HttpResponse,
HttpResponseExt {
    private HttpInboundServiceContext isc = null;
    private HttpResponseMessage message = null;
    private HttpOutputStreamImpl body = null;
    private HttpDispatcherLink connlink = null;

    public HttpResponseImpl(HttpDispatcherLink link) {
        this.connlink = link;
    }

    public void init(HttpInboundServiceContext context) {
        this.isc = context;
        this.message = context.getResponse();
        this.body = null;
    }

    public boolean isCommitted() {
        return this.message.isCommitted();
    }

    public void addCookie(HttpCookie cookie) {
        this.message.setCookie(cookie, HttpHeaderKeys.HDR_SET_COOKIE);
    }

    public HttpCookie getCookie(String name) {
        return this.message.getCookie(name);
    }

    public List<HttpCookie> getCookies(String name) {
        return this.message.getAllCookies(name);
    }

    public boolean isPersistent() {
        return this.isc.isPersistent();
    }

    public List<HttpCookie> getCookies() {
        return this.message.getAllCookies();
    }

    public void removeCookie(HttpCookie cookie) {
        this.message.removeCookie(cookie.getName(), HttpHeaderKeys.HDR_SET_COOKIE);
    }

    public long getContentLength() {
        return this.message.getContentLength();
    }

    public void setContentLength(long length) {
        this.message.setContentLength(length);
        if (this.body != null) {
            this.body.setContentLength(length);
        }
    }

    public void setHeader(String name, String value) {
        this.message.setHeader(name, value);
    }

    public void setHeader(HttpHeaderKeys key, String value) {
        this.message.setHeader((HeaderKeys)key, value);
    }

    public String setHeaderIfAbsent(HttpHeaderKeys key, String value) {
        HeaderField oldValue = this.message.setHeaderIfAbsent((HeaderKeys)key, value);
        return oldValue == null ? null : oldValue.asString();
    }

    public void removeHeader(String name) {
        this.message.removeHeader(name);
    }

    public void removeHeader(HttpHeaderKeys key) {
        this.message.removeHeader((HeaderKeys)key);
    }

    public void removeAllHeaders() {
        this.message.removeAllHeaders();
    }

    public void addHeader(String name, String value) {
        this.message.appendHeader(name, value);
    }

    public HttpOutputStreamImpl getBody() {
        if (null == this.body) {
            long messageContentLength;
            this.body = HttpDispatcher.useEE7Streams() ? new HttpOutputStreamEE7(this.isc) : new HttpOutputStreamImpl(this.isc);
            this.body.setVirtualConnection(this.connlink.getVirtualConnection());
            if (this.message != null && (messageContentLength = this.getContentLength()) != -1L) {
                this.body.setContentLength(this.getContentLength());
            }
        }
        return this.body;
    }

    public String getHeader(String name) {
        return this.message.getHeader(name).asString();
    }

    public String getHeader(HttpHeaderKeys key) {
        return this.message.getHeader((HeaderKeys)key).asString();
    }

    public List<String> getHeaders(String name) {
        List hdrs = this.message.getHeaders(name);
        ArrayList<String> values = new ArrayList<String>(hdrs.size());
        for (HeaderField header : hdrs) {
            values.add(header.asString());
        }
        return values;
    }

    public List<String> getHeaders() {
        List hdrs = this.message.getAllHeaders();
        ArrayList<String> values = new ArrayList<String>(hdrs.size());
        for (HeaderField header : hdrs) {
            values.add(header.getName());
        }
        return values;
    }

    public List<String> getHeaderNames() {
        return this.message.getAllHeaderNames();
    }

    public String getReason() {
        return this.message.getReasonPhrase();
    }

    public int getStatus() {
        return this.message.getStatusCodeAsInt();
    }

    public String getVersion() {
        return this.message.getVersion();
    }

    public void setReason(String phrase) {
        this.message.setReasonPhrase(phrase);
    }

    public void setStatus(int code) {
        this.message.setStatusCode(code);
    }

    public void setVersion(String version) {
        try {
            this.message.setVersion(version);
        }
        catch (UnsupportedProtocolVersionException e) {
            this.message.setVersion(VersionValues.V11);
        }
    }

    public void reset() {
        this.message.clear();
        this.body.clear();
    }

    public void setTrailer(String name, String value) {
        HttpHeaderKeys key;
        HttpTrailersImpl trailers = this.message.createTrailers();
        if (trailers == null) {
            trailers = this.message.getTrailers();
        }
        if (trailers.containsDeferredTrailer((HeaderKeys)(key = HttpHeaderKeys.find((String)name, (boolean)false)))) {
            trailers.removeDeferredTrailer((HeaderKeys)key);
        }
        HttpTrailerGeneratorImpl generator = new HttpTrailerGeneratorImpl((HeaderKeys)key, value);
        trailers.setDeferredTrailer((HeaderKeys)key, generator);
    }

    public void writeTrailers() {
        HttpTrailersImpl trailers = this.message.createTrailers();
        if (trailers == null) {
            trailers = this.message.getTrailers();
        }
        trailers.computeRemainingTrailers();
    }
}

