/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal.values;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http.channel.internal.values.CookieData;
import com.ibm.wsspi.genericbnf.GenericKeys;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.http.HttpCookie;
import com.ibm.wsspi.http.channel.HttpChannelUtils;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;

public class CookiePathData
extends CookieData {
    private static final TraceComponent tc = Tr.register(CookiePathData.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");

    public CookiePathData() {
        super("path");
    }

    @Override
    public boolean set(HttpCookie cookie, byte[] attribValue) {
        if (null != attribValue && 0 < attribValue.length) {
            cookie.setPath(HttpChannelUtils.getEnglishString((byte[])attribValue));
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Cookie path set to " + cookie.getPath()), (Object[])new Object[0]);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean validForHeader(HeaderKeys hdr, boolean includesDollar) {
        if (HttpHeaderKeys.HDR_COOKIE.equals((GenericKeys)hdr) || HttpHeaderKeys.HDR_COOKIE2.equals((GenericKeys)hdr)) {
            return includesDollar;
        }
        if (HttpHeaderKeys.HDR_SET_COOKIE.equals((GenericKeys)hdr) || HttpHeaderKeys.HDR_SET_COOKIE2.equals((GenericKeys)hdr)) {
            return !includesDollar;
        }
        return false;
    }
}

