/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal.outbound;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http.channel.internal.CallbackIDs;
import com.ibm.ws.http.channel.internal.outbound.HttpOutboundServiceContextImpl;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.tcpchannel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPWriteRequestContext;
import java.io.IOException;

public class HttpOSCWriteCallback
implements TCPWriteCompletedCallback {
    private static final TraceComponent tc = Tr.register(HttpOSCWriteCallback.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private static final HttpOSCWriteCallback myInstance = new HttpOSCWriteCallback();

    private HttpOSCWriteCallback() {
    }

    public static final HttpOSCWriteCallback getRef() {
        return myInstance;
    }

    public void complete(VirtualConnection vc, TCPWriteRequestContext wsc) {
        HttpOutboundServiceContextImpl mySC;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("complete() called: vc=" + vc), (Object[])new Object[0]);
        }
        if ((mySC = (HttpOutboundServiceContextImpl)vc.getStateMap().get((Object)CallbackIDs.CALLBACK_HTTPOSC)).isEarlyRead()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Notifying app channel of write complete", (Object[])new Object[0]);
            }
            mySC.getAppWriteCallback().complete(vc);
            return;
        }
        if (mySC.isHeadersSentState() && 0L == mySC.getNumBytesWritten() && mySC.shouldReadResponseImmediately()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Sent headers, reading for response", (Object[])new Object[0]);
            }
            mySC.startResponseRead();
            return;
        }
        if (!mySC.isMessageSent()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Calling write complete callback of app channel.", (Object[])new Object[0]);
            }
            mySC.getAppWriteCallback().complete(vc);
        } else if (mySC.shouldReadResponseImmediately()) {
            mySC.readAsyncResponse();
        } else {
            mySC.startResponseRead();
        }
    }

    public void error(VirtualConnection vc, TCPWriteRequestContext wsc, IOException ioe) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("error() called: vc=" + vc + " ioe=" + ioe), (Object[])new Object[0]);
        }
        HttpOutboundServiceContextImpl mySC = (HttpOutboundServiceContextImpl)vc.getStateMap().get((Object)CallbackIDs.CALLBACK_HTTPOSC);
        mySC.setPersistent(false);
        mySC.reConnect(vc, ioe);
    }
}

