/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal.outbound;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.internal.CallbackIDs;
import com.ibm.ws.http.channel.internal.outbound.HttpOutboundServiceContextImpl;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.tcpchannel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPReadRequestContext;
import java.io.IOException;

public class HttpOSCReadCallback
implements TCPReadCompletedCallback {
    private static final TraceComponent tc = Tr.register(HttpOSCReadCallback.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private static final HttpOSCReadCallback myInstance = new HttpOSCReadCallback();

    private HttpOSCReadCallback() {
    }

    public static final HttpOSCReadCallback getRef() {
        return myInstance;
    }

    public void complete(VirtualConnection vc, TCPReadRequestContext req) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("complete() called: vc=" + vc), (Object[])new Object[0]);
        }
        HttpOutboundServiceContextImpl mySC = (HttpOutboundServiceContextImpl)vc.getStateMap().get((Object)CallbackIDs.CALLBACK_HTTPOSC);
        VirtualConnection readVC = null;
        try {
            do {
                if (mySC.parseMessage()) {
                    mySC.handleParsedMessage();
                    return;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Reading for more data", (Object[])new Object[0]);
                }
                mySC.setupReadBuffers(mySC.getHttpConfig().getIncomingHdrBufferSize(), false);
            } while (null != (readVC = req.read(1L, (TCPReadCompletedCallback)this, false, mySC.getReadTimeout())));
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".complete"), (String)"112", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caught exception: " + e.getMessage()), (Object[])new Object[0]);
            }
            mySC.setPersistent(false);
            mySC.getAppWriteCallback().error(vc, (Throwable)e);
        }
    }

    public void error(VirtualConnection vc, TCPReadRequestContext req, IOException ioe) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("error() called: vc=" + vc + " ioe=" + ioe), (Object[])new Object[0]);
        }
        HttpOutboundServiceContextImpl mySC = (HttpOutboundServiceContextImpl)vc.getStateMap().get((Object)CallbackIDs.CALLBACK_HTTPOSC);
        mySC.setPersistent(false);
        mySC.reConnect(vc, ioe);
    }
}

