/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal.inbound;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http.channel.internal.CallbackIDs;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundServiceContextImpl;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import com.ibm.wsspi.http.channel.exception.HttpInvalidMessageException;
import com.ibm.wsspi.http.logging.DebugLog;
import com.ibm.wsspi.tcpchannel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPWriteRequestContext;
import java.io.IOException;

public class HttpISCWriteCallback
implements TCPWriteCompletedCallback {
    private static final TraceComponent tc = Tr.register(HttpISCWriteCallback.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private static final HttpISCWriteCallback myInstance = new HttpISCWriteCallback();

    private HttpISCWriteCallback() {
    }

    public static final HttpISCWriteCallback getRef() {
        return myInstance;
    }

    public void complete(VirtualConnection vc, TCPWriteRequestContext wsc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("complete() called: vc=" + vc), (Object[])new Object[0]);
        }
        HttpInboundServiceContextImpl mySC = (HttpInboundServiceContextImpl)vc.getStateMap().get((Object)CallbackIDs.CALLBACK_HTTPISC);
        if (null != wsc) {
            wsc.setBuffers(null);
        }
        if (mySC.isMessageSent()) {
            mySC.logFinalResponse(mySC.getNumBytesWritten());
            HttpInvalidMessageException inv = mySC.checkResponseValidity();
            if (null != inv) {
                mySC.setPersistent(false);
                if (null != mySC.getAppWriteCallback()) {
                    mySC.getAppWriteCallback().error(vc, (Throwable)inv);
                }
                return;
            }
        }
        if (null != mySC.getAppWriteCallback()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Calling write complete callback of app channel.", (Object[])new Object[0]);
            }
            if (mySC.getResponseImpl().isTemporaryStatusCode()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Temp response sent, resetting send flags", (Object[])new Object[0]);
                }
                mySC.resetWrite();
            }
            mySC.getAppWriteCallback().complete(vc);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"No available app channel callback", (Object[])new Object[0]);
        }
    }

    public void error(VirtualConnection vc, TCPWriteRequestContext wsc, IOException ioe) {
        HttpInboundServiceContextImpl mySC;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("error called: vc=" + vc + " ioe=" + ioe), (Object[])new Object[0]);
        }
        if ((mySC = (HttpInboundServiceContextImpl)vc.getStateMap().get((Object)CallbackIDs.CALLBACK_HTTPISC)).getHttpConfig().getDebugLog().isEnabled(DebugLog.Level.WARN)) {
            mySC.getHttpConfig().getDebugLog().log(DebugLog.Level.WARN, "The write of the response failed from a socket exception.", (HttpServiceContext)mySC);
        }
        mySC.logLegacyMessage();
        mySC.setPersistent(false);
        if (null != mySC.getAppWriteCallback()) {
            mySC.getAppWriteCallback().error(vc, (Throwable)ioe);
        } else {
            mySC.getLink().getDeviceLink().close(vc, (Exception)ioe);
        }
    }
}

