/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal.inbound;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http.channel.internal.CallbackIDs;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundLink;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundServiceContextImpl;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import com.ibm.wsspi.http.channel.values.StatusCodes;
import com.ibm.wsspi.http.logging.DebugLog;
import com.ibm.wsspi.tcpchannel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPWriteRequestContext;
import java.io.IOException;

public class Http100ContWriteCallback
implements TCPWriteCompletedCallback {
    private static final TraceComponent tc = Tr.register(Http100ContWriteCallback.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private static final Http100ContWriteCallback myInstance = new Http100ContWriteCallback();

    private Http100ContWriteCallback() {
    }

    public static final Http100ContWriteCallback getRef() {
        return myInstance;
    }

    public void complete(VirtualConnection vc, TCPWriteRequestContext wsc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("complete() called for vc=" + vc), (Object[])new Object[0]);
        }
        HttpInboundLink link = (HttpInboundLink)((Object)vc.getStateMap().get((Object)CallbackIDs.CALLBACK_HTTPICL));
        link.getHTTPContext().resetMsgSentState();
        HttpResponseMessage msg = link.getHTTPContext().getResponse();
        msg.setStatusCode(StatusCodes.OK);
        msg.removeHeader((HeaderKeys)HttpHeaderKeys.HDR_CONTENT_LENGTH);
        link.handleDiscrimination();
    }

    public void error(VirtualConnection vc, TCPWriteRequestContext wsc, IOException ioe) {
        HttpInboundServiceContextImpl isc;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("error() called for vc=" + vc + " ioe=" + ioe), (Object[])new Object[0]);
        }
        if ((isc = (HttpInboundServiceContextImpl)vc.getStateMap().get((Object)CallbackIDs.CALLBACK_HTTPISC)).getHttpConfig().getDebugLog().isEnabled(DebugLog.Level.WARN)) {
            isc.getHttpConfig().getDebugLog().log(DebugLog.Level.WARN, "The write of the response failed from a socket exception.", (HttpServiceContext)isc);
        }
        isc.getLink().close(vc, ioe);
    }
}

