/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http.channel.internal.CallbackIDs;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundServiceContextImpl;
import com.ibm.ws.http.channel.internal.outbound.HttpOutboundServiceContextImpl;
import com.ibm.wsspi.channelfw.OutboundVirtualConnection;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.tcpchannel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPReadRequestContext;
import java.io.IOException;

public class TrailerCallback
implements TCPReadCompletedCallback {
    private static final TraceComponent tc = Tr.register(TrailerCallback.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private static final TrailerCallback myInstance = new TrailerCallback();

    private TrailerCallback() {
    }

    public static final TrailerCallback getRef() {
        return myInstance;
    }

    public void complete(VirtualConnection vc, TCPReadRequestContext rsc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("complete() called: vc=" + vc), (Object[])new Object[0]);
        }
        if (vc instanceof OutboundVirtualConnection) {
            HttpOutboundServiceContextImpl osc = (HttpOutboundServiceContextImpl)vc.getStateMap().get((Object)CallbackIDs.CALLBACK_HTTPOSC);
            osc.continueRead();
        } else {
            HttpInboundServiceContextImpl isc = (HttpInboundServiceContextImpl)vc.getStateMap().get((Object)CallbackIDs.CALLBACK_HTTPISC);
            isc.continueRead();
        }
    }

    public void error(VirtualConnection vc, TCPReadRequestContext rsc, IOException ioe) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("error() called: vc=" + vc + " ioe=" + ioe), (Object[])new Object[0]);
        }
        if (vc instanceof OutboundVirtualConnection) {
            HttpOutboundServiceContextImpl osc = (HttpOutboundServiceContextImpl)vc.getStateMap().get((Object)CallbackIDs.CALLBACK_HTTPOSC);
            osc.setPersistent(false);
            osc.getAppReadCallback().error(vc, (Throwable)ioe);
        } else {
            HttpInboundServiceContextImpl isc = (HttpInboundServiceContextImpl)vc.getStateMap().get((Object)CallbackIDs.CALLBACK_HTTPISC);
            isc.setPersistent(false);
            isc.getAppReadCallback().error(vc, (Throwable)ioe);
        }
    }
}

