/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.wsdl.interceptors;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.AbstractInDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.service.model.ServiceModelUtil;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.constants.Constants;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class DocLiteralInInterceptor
extends AbstractInDatabindingInterceptor {
    public static final String KEEP_PARAMETERS_WRAPPER = DocLiteralInInterceptor.class.getName() + ".DocLiteralInInterceptor.keep-parameters-wrapper";
    private static final Logger LOG = LogUtils.getL7dLogger(DocLiteralInInterceptor.class);
    static final long serialVersionUID = 6178437772347382148L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public DocLiteralInInterceptor() {
        super("unmarshal");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl.interceptors.DocLiteralInInterceptor", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.wsdl.interceptors.DocLiteralInInterceptor", "<init>", (Object)this);
        }
    }

    /*
     * Exception decompiling
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleMessage(@Sensitive Message message) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void getBindingOperationForEmptyBody(Collection<OperationInfo> operations, Endpoint ep, Exchange exchange) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl.interceptors.DocLiteralInInterceptor", "getBindingOperationForEmptyBody", new Object[]{operations, ep, exchange});
        }
        for (OperationInfo op : operations) {
            MessageInfo bmsg = op.getInput();
            int bPartsNum = bmsg.getMessagePartsNumber();
            if (bPartsNum != 0 && (bPartsNum != 1 || !Constants.XSD_ANYTYPE.equals(bmsg.getFirstMessagePart().getTypeQName()))) continue;
            BindingOperationInfo boi = ep.getEndpointInfo().getBinding().getOperation(op);
            exchange.put(BindingOperationInfo.class, (Object)boi);
            exchange.setOneWay(op.isOneWay());
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.wsdl.interceptors.DocLiteralInInterceptor", "getBindingOperationForEmptyBody");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private BindingOperationInfo getBindingOperationInfo(@Sensitive DepthXMLStreamReader xmlReader, Exchange exchange, BindingOperationInfo bop, boolean client) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            Object[] objectArray = new Object[4];
            objectArray[0] = "<sensitive org.apache.cxf.staxutils.DepthXMLStreamReader>";
            objectArray[1] = exchange;
            objectArray[2] = bop;
            objectArray[3] = client;
            LOG.entering("org.apache.cxf.wsdl.interceptors.DocLiteralInInterceptor", "getBindingOperationInfo", objectArray);
        }
        if (bop != null && bop.isUnwrapped()) {
            bop = bop.getWrappedOperation();
        }
        if (bop == null) {
            QName startQName = xmlReader == null ? new QName("http://cxf.apache.org/jaxws/provider", "invoke") : xmlReader.getName();
            bop = this.getBindingOperationInfo(exchange, startQName, client);
        }
        BindingOperationInfo bindingOperationInfo = bop;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bindingOperationInfo = bindingOperationInfo;
            LOG.exiting("org.apache.cxf.wsdl.interceptors.DocLiteralInInterceptor", "getBindingOperationInfo", bindingOperationInfo);
        }
        return bindingOperationInfo;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void validatePart(MessagePartInfo p, QName elName, Message m) {
        OperationInfo op;
        Boolean b;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl.interceptors.DocLiteralInInterceptor", "validatePart", new Object[]{p, elName, m});
        }
        if (p == null) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("NO_PART_FOUND", LOG, new Object[]{elName}), Fault.FAULT_CODE_CLIENT);
        }
        boolean synth = false;
        if (p.getMessageInfo() != null && p.getMessageInfo().getOperation() != null && (b = (Boolean)(op = p.getMessageInfo().getOperation()).getProperty("operation.is.synthetic")) != null) {
            synth = b;
        }
        if (MessageUtils.getContextualBoolean((Message)m, (String)"soap.no.validate.parts", (boolean)false)) {
            synth = true;
        }
        if (synth) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.wsdl.interceptors.DocLiteralInInterceptor", "validatePart");
            }
            return;
        }
        if (p.isElement() ? p.getConcreteName() != null && !elName.equals(p.getConcreteName()) && !synth : !elName.equals(p.getName()) && !elName.equals(p.getConcreteName()) && !synth) {
            throw new Fault("UNEXPECTED_ELEMENT", LOG, null, new Object[]{elName, p.getConcreteName()});
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.wsdl.interceptors.DocLiteralInInterceptor", "validatePart");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void getPara(DepthXMLStreamReader xmlReader, DataReader<XMLStreamReader> dr, MessageContentsList parameters, Iterator<MessagePartInfo> itr, Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl.interceptors.DocLiteralInInterceptor", "getPara", new Object[]{xmlReader, dr, parameters, itr, message});
        }
        boolean hasNext = true;
        while (itr.hasNext()) {
            MessagePartInfo part = itr.next();
            if (hasNext) {
                hasNext = StaxUtils.toNextElement((DepthXMLStreamReader)xmlReader);
            }
            Object obj = null;
            if (hasNext) {
                QName rname = xmlReader.getName();
                while (part != null && !rname.equals(part.getConcreteName())) {
                    if (part.getXmlSchema() instanceof XmlSchemaElement) {
                        parameters.put(part, null);
                    }
                    if (itr.hasNext()) {
                        part = itr.next();
                        continue;
                    }
                    part = null;
                }
                if (part == null) {
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        LOG.exiting("org.apache.cxf.wsdl.interceptors.DocLiteralInInterceptor", "getPara");
                    }
                    return;
                }
                if (rname.equals(part.getConcreteName())) {
                    obj = dr.read(part, (Object)xmlReader);
                }
            }
            parameters.put(part, obj);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.wsdl.interceptors.DocLiteralInInterceptor", "getPara");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private MessageInfo setMessage(Message message, BindingOperationInfo operation, boolean requestor, ServiceInfo si) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl.interceptors.DocLiteralInInterceptor", "setMessage", new Object[]{message, operation, requestor, si});
        }
        MessageInfo msgInfo = this.getMessageInfo(message, operation, requestor);
        MessageInfo messageInfo = this.setMessage(message, operation, requestor, si, msgInfo);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            messageInfo = messageInfo;
            LOG.exiting("org.apache.cxf.wsdl.interceptors.DocLiteralInInterceptor", "setMessage", messageInfo);
        }
        return messageInfo;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected BindingOperationInfo getBindingOperationInfo(Exchange exchange, QName name, boolean client) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl.interceptors.DocLiteralInInterceptor", "getBindingOperationInfo", new Object[]{exchange, name, client});
        }
        BindingOperationInfo bop = ServiceModelUtil.getOperationForWrapperElement((Exchange)exchange, (QName)name, (boolean)client);
        if (bop == null) {
            bop = super.getBindingOperationInfo(exchange, name, client);
        }
        if (bop != null) {
            exchange.put(BindingOperationInfo.class, (Object)bop);
        }
        BindingOperationInfo bindingOperationInfo = bop;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bindingOperationInfo = bindingOperationInfo;
            LOG.exiting("org.apache.cxf.wsdl.interceptors.DocLiteralInInterceptor", "getBindingOperationInfo", bindingOperationInfo);
        }
        return bindingOperationInfo;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean shouldWrapParameters(MessageInfo msgInfo, Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl.interceptors.DocLiteralInInterceptor", "shouldWrapParameters", new Object[]{msgInfo, message});
        }
        Object keepParametersWrapperFlag = message.get((Object)KEEP_PARAMETERS_WRAPPER);
        if (keepParametersWrapperFlag == null) {
            boolean bl = msgInfo.getFirstMessagePart().getTypeClass() != null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.wsdl.interceptors.DocLiteralInInterceptor", "shouldWrapParameters", bl);
            }
            return bl;
        }
        boolean bl = Boolean.parseBoolean(keepParametersWrapperFlag.toString());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.wsdl.interceptors.DocLiteralInInterceptor", "shouldWrapParameters", bl);
        }
        return bl;
    }
}

