/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.wsdl.interceptors;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class BareOutInterceptor
extends AbstractOutDatabindingInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(BareOutInterceptor.class);
    static final long serialVersionUID = 4035005500805296320L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public BareOutInterceptor() {
        super("marshal");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl.interceptors.BareOutInterceptor", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.wsdl.interceptors.BareOutInterceptor", "<init>", (Object)this);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleMessage(Message message) {
        List parts;
        MessageContentsList objs;
        BindingOperationInfo operation;
        Exchange exchange;
        block17: {
            BindingMessageInfo bmsg;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.wsdl.interceptors.BareOutInterceptor", "handleMessage", new Object[]{message});
            }
            exchange = message.getExchange();
            operation = exchange.getBindingOperationInfo();
            if (operation == null) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("BareOutInterceptor: Operation is NULL, returning...");
                }
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    LOG.exiting("org.apache.cxf.wsdl.interceptors.BareOutInterceptor", "handleMessage");
                }
                return;
            }
            objs = MessageContentsList.getContentsList((Message)message);
            if (objs == null || objs.isEmpty()) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("BareOutInterceptor: MessageContentsList is empty, returning...");
                }
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    LOG.exiting("org.apache.cxf.wsdl.interceptors.BareOutInterceptor", "handleMessage");
                }
                return;
            }
            boolean client = this.isRequestor(message);
            if (!client) {
                if (operation.getOutput() != null) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("BareOutInterceptor: Getoutput for operation: " + operation.getName());
                    }
                    bmsg = operation.getOutput();
                    parts = bmsg.getMessageParts();
                    break block17;
                } else {
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("BareOutInterceptor: Operation output is NULL, returning");
                    }
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        LOG.exiting("org.apache.cxf.wsdl.interceptors.BareOutInterceptor", "handleMessage");
                    }
                    return;
                }
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("BareOutInterceptor: Get input message parts...");
            }
            bmsg = operation.getInput();
            parts = bmsg.getMessageParts();
        }
        if (LOG.isLoggable(Level.FINEST)) {
            for (MessagePartInfo mp1 : parts) {
                LOG.finest("BareOutInterceptor: Msg Part: " + mp1.toString());
            }
        }
        this.writeParts(message, exchange, operation, objs, parts);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.wsdl.interceptors.BareOutInterceptor", "handleMessage");
        }
    }
}

